/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.concurrent.ExecutionException;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.state.InputStateHandle;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.OutputStateHandle;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFutures;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;

public class OperatorSnapshotFinalizer {
    private final OperatorSubtaskState jobManagerOwnedState;
    private final OperatorSubtaskState taskLocalState;

    public static OperatorSnapshotFinalizer create(OperatorSnapshotFutures snapshotFutures) throws ExecutionException, InterruptedException {
        Preconditions.checkNotNull(snapshotFutures);
        SnapshotResult<KeyedStateHandle> keyedManaged = FutureUtils.runIfNotDoneAndGet(snapshotFutures.getKeyedStateManagedFuture());
        SnapshotResult<KeyedStateHandle> keyedRaw = FutureUtils.runIfNotDoneAndGet(snapshotFutures.getKeyedStateRawFuture());
        SnapshotResult<OperatorStateHandle> operatorManaged = FutureUtils.runIfNotDoneAndGet(snapshotFutures.getOperatorStateManagedFuture());
        SnapshotResult<OperatorStateHandle> operatorRaw = FutureUtils.runIfNotDoneAndGet(snapshotFutures.getOperatorStateRawFuture());
        SnapshotResult<StateObjectCollection<InputStateHandle>> inputChannel = snapshotFutures.getInputChannelStateFuture().get();
        SnapshotResult<StateObjectCollection<OutputStateHandle>> resultSubpartition = snapshotFutures.getResultSubpartitionStateFuture().get();
        OperatorSubtaskState jobManagerOwnedState = OperatorSubtaskState.builder().setManagedOperatorState(StateObjectCollection.singletonOrEmpty(operatorManaged.getJobManagerOwnedSnapshot())).setRawOperatorState(StateObjectCollection.singletonOrEmpty(operatorRaw.getJobManagerOwnedSnapshot())).setManagedKeyedState(StateObjectCollection.singletonOrEmpty(keyedManaged.getJobManagerOwnedSnapshot())).setRawKeyedState(StateObjectCollection.singletonOrEmpty(keyedRaw.getJobManagerOwnedSnapshot())).setInputChannelState(StateObjectCollection.emptyIfNull(inputChannel.getJobManagerOwnedSnapshot())).setResultSubpartitionState(StateObjectCollection.emptyIfNull(resultSubpartition.getJobManagerOwnedSnapshot())).build();
        OperatorSubtaskState taskLocalState = OperatorSubtaskState.builder().setManagedOperatorState(StateObjectCollection.singletonOrEmpty(operatorManaged.getTaskLocalSnapshot())).setRawOperatorState(StateObjectCollection.singletonOrEmpty(operatorRaw.getTaskLocalSnapshot())).setManagedKeyedState(StateObjectCollection.singletonOrEmpty(keyedManaged.getTaskLocalSnapshot())).setRawKeyedState(StateObjectCollection.singletonOrEmpty(keyedRaw.getTaskLocalSnapshot())).setInputChannelState(StateObjectCollection.emptyIfNull(inputChannel.getTaskLocalSnapshot())).setResultSubpartitionState(StateObjectCollection.emptyIfNull(resultSubpartition.getTaskLocalSnapshot())).build();
        return new OperatorSnapshotFinalizer(jobManagerOwnedState, taskLocalState);
    }

    public OperatorSnapshotFinalizer(OperatorSubtaskState jobManagerOwnedState, OperatorSubtaskState taskLocalState) {
        this.jobManagerOwnedState = Preconditions.checkNotNull(jobManagerOwnedState);
        this.taskLocalState = Preconditions.checkNotNull(taskLocalState);
    }

    public OperatorSubtaskState getTaskLocalState() {
        return this.taskLocalState;
    }

    public OperatorSubtaskState getJobManagerOwnedState() {
        return this.jobManagerOwnedState;
    }
}

