/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.util.Collection;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.internal.InternalAggregatingState;
import org.apache.flink.runtime.state.metrics.AbstractMetricsTrackState;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateConfig;
import org.apache.flink.runtime.state.metrics.SizeTrackingStateConfig;
import org.apache.flink.runtime.state.metrics.StateMetricBase;

class MetricsTrackingAggregatingState<K, N, IN, ACC, OUT>
extends AbstractMetricsTrackState<K, N, ACC, InternalAggregatingState<K, N, IN, ACC, OUT>, AggregatingStateMetrics>
implements InternalAggregatingState<K, N, IN, ACC, OUT> {
    MetricsTrackingAggregatingState(String stateName, InternalAggregatingState<K, N, IN, ACC, OUT> original, KeyedStateBackend<K> keyedStateBackend, LatencyTrackingStateConfig latencyTrackingStateConfig, SizeTrackingStateConfig sizeTrackingStateConfig) {
        super(original, keyedStateBackend, latencyTrackingStateConfig.isEnabled() ? new AggregatingStateMetrics(stateName, latencyTrackingStateConfig.getMetricGroup(), latencyTrackingStateConfig.getSampleInterval(), latencyTrackingStateConfig.getHistorySize(), latencyTrackingStateConfig.isStateNameAsVariable()) : null, sizeTrackingStateConfig.isEnabled() ? new AggregatingStateMetrics(stateName, sizeTrackingStateConfig.getMetricGroup(), sizeTrackingStateConfig.getSampleInterval(), sizeTrackingStateConfig.getHistorySize(), sizeTrackingStateConfig.isStateNameAsVariable()) : null);
    }

    @Override
    public OUT get() throws Exception {
        if (this.sizeTrackingStateMetric != null && ((AggregatingStateMetrics)this.sizeTrackingStateMetric).trackMetricsOnGet()) {
            ((AggregatingStateMetrics)this.sizeTrackingStateMetric).updateMetrics("aggregatingStateGetKeySize", super.sizeOfKey());
        }
        if (this.latencyTrackingStateMetric != null && ((AggregatingStateMetrics)this.latencyTrackingStateMetric).trackMetricsOnGet()) {
            return (OUT)this.trackLatencyWithException(() -> ((InternalAggregatingState)this.original).get(), "aggregatingStateGetLatency");
        }
        return ((InternalAggregatingState)this.original).get();
    }

    @Override
    public void add(IN value) throws Exception {
        if (this.sizeTrackingStateMetric != null && ((AggregatingStateMetrics)this.sizeTrackingStateMetric).trackMetricsOnAdd()) {
            ((AggregatingStateMetrics)this.sizeTrackingStateMetric).updateMetrics("aggregatingStateAddKeySize", super.sizeOfKey());
        }
        if (this.latencyTrackingStateMetric != null && ((AggregatingStateMetrics)this.latencyTrackingStateMetric).trackMetricsOnAdd()) {
            this.trackLatencyWithException(() -> ((InternalAggregatingState)this.original).add(value), "aggregatingStateAddLatency");
        } else {
            ((InternalAggregatingState)this.original).add(value);
        }
    }

    @Override
    public ACC getInternal() throws Exception {
        return (ACC)((InternalAggregatingState)this.original).getInternal();
    }

    @Override
    public void updateInternal(ACC valueToStore) throws Exception {
        ((InternalAggregatingState)this.original).updateInternal(valueToStore);
    }

    @Override
    public void mergeNamespaces(N target, Collection<N> sources) throws Exception {
        if (this.latencyTrackingStateMetric != null && ((AggregatingStateMetrics)this.latencyTrackingStateMetric).trackMetricsOnMergeNamespace()) {
            this.trackLatencyWithException(() -> ((InternalAggregatingState)this.original).mergeNamespaces(target, sources), "aggregatingStateMergeNamespacesLatency");
        } else {
            ((InternalAggregatingState)this.original).mergeNamespaces(target, sources);
        }
    }

    static class AggregatingStateMetrics
    extends StateMetricBase {
        private static final String AGGREGATING_STATE_GET_LATENCY = "aggregatingStateGetLatency";
        private static final String AGGREGATING_STATE_ADD_LATENCY = "aggregatingStateAddLatency";
        private static final String AGGREGATING_STATE_MERGE_NAMESPACES_LATENCY = "aggregatingStateMergeNamespacesLatency";
        private static final String AGGREGATING_STATE_GET_KEY_SIZE = "aggregatingStateGetKeySize";
        private static final String AGGREGATING_STATE_ADD_KEY_SIZE = "aggregatingStateAddKeySize";
        private int getCount = 0;
        private int addCount = 0;
        private int mergeNamespaceCount = 0;

        private AggregatingStateMetrics(String stateName, MetricGroup metricGroup, int sampleInterval, int historySize, boolean stateNameAsVariable) {
            super(stateName, metricGroup, sampleInterval, historySize, stateNameAsVariable);
        }

        int getGetCount() {
            return this.getCount;
        }

        int getAddCount() {
            return this.addCount;
        }

        int getMergeNamespaceCount() {
            return this.mergeNamespaceCount;
        }

        private boolean trackMetricsOnGet() {
            this.getCount = this.loopUpdateCounter(this.getCount);
            return this.getCount == 1;
        }

        private boolean trackMetricsOnAdd() {
            this.addCount = this.loopUpdateCounter(this.addCount);
            return this.addCount == 1;
        }

        private boolean trackMetricsOnMergeNamespace() {
            this.mergeNamespaceCount = this.loopUpdateCounter(this.mergeNamespaceCount);
            return this.mergeNamespaceCount == 1;
        }
    }
}

