/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.source.coordinator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;

public class SourceCoordinatorSerdeUtils {
    public static final int VERSION_0 = 0;
    public static final int VERSION_1 = 1;
    private static final int CURRENT_VERSION = 1;

    private SourceCoordinatorSerdeUtils() {
    }

    static void writeCoordinatorSerdeVersion(DataOutputStream out) throws IOException {
        out.writeInt(1);
    }

    static int readAndVerifyCoordinatorSerdeVersion(DataInputStream in) throws IOException {
        int version = in.readInt();
        if (version > 1) {
            throw new IOException("Unsupported source coordinator serde version " + version);
        }
        return version;
    }

    static byte[] readBytes(DataInputStream in, int size) throws IOException {
        byte[] bytes = new byte[size];
        in.readFully(bytes);
        return bytes;
    }

    static <SplitT> byte[] serializeAssignments(Map<Integer, LinkedHashSet<SplitT>> assignments, SimpleVersionedSerializer<SplitT> splitSerializer) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Object object;
            try (DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper(baos);){
                out.writeInt(splitSerializer.getVersion());
                int numSubtasks = assignments.size();
                out.writeInt(numSubtasks);
                for (Map.Entry<Integer, LinkedHashSet<SplitT>> assignment : assignments.entrySet()) {
                    int subtaskId = assignment.getKey();
                    out.writeInt(subtaskId);
                    int numAssignedSplits = assignment.getValue().size();
                    out.writeInt(numAssignedSplits);
                    for (Object split : assignment.getValue()) {
                        byte[] serializedSplit = splitSerializer.serialize(split);
                        out.writeInt(serializedSplit.length);
                        out.write(serializedSplit);
                    }
                }
                out.flush();
                object = baos.toByteArray();
            }
            return object;
        }
    }

    static <SplitT> Map<Integer, LinkedHashSet<SplitT>> deserializeAssignments(byte[] assignmentData, SimpleVersionedSerializer<SplitT> splitSerializer) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(assignmentData);){
            HashMap<Integer, LinkedHashSet<SplitT>> hashMap;
            try (DataInputViewStreamWrapper in = new DataInputViewStreamWrapper(bais);){
                int splitSerializerVersion = in.readInt();
                int numSubtasks = in.readInt();
                HashMap<Integer, LinkedHashSet<SplitT>> assignments = new HashMap<Integer, LinkedHashSet<SplitT>>();
                for (int j = 0; j < numSubtasks; ++j) {
                    int subtaskId = in.readInt();
                    int numAssignedSplits = in.readInt();
                    LinkedHashSet<SplitT> splits = new LinkedHashSet<SplitT>(numAssignedSplits);
                    assignments.put(subtaskId, splits);
                    for (int k = 0; k < numAssignedSplits; ++k) {
                        int serializedSplitSize = in.readInt();
                        byte[] serializedSplit = SourceCoordinatorSerdeUtils.readBytes(in, serializedSplitSize);
                        SplitT split = splitSerializer.deserialize(splitSerializerVersion, serializedSplit);
                        splits.add(split);
                    }
                }
                hashMap = assignments;
            }
            return hashMap;
        }
    }
}

