/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.stopwithsavepoint;

import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.throwable.ThrowableAnnotation;
import org.apache.flink.runtime.throwable.ThrowableType;
import org.apache.flink.util.FlinkException;

@Experimental
@ThrowableAnnotation(value=ThrowableType.NonRecoverableError)
public class StopWithSavepointStoppingException
extends FlinkException {
    private final String savepointPath;

    public StopWithSavepointStoppingException(String savepointPath, JobID jobID) {
        super(StopWithSavepointStoppingException.formatMessage(savepointPath, jobID));
        this.savepointPath = savepointPath;
    }

    public StopWithSavepointStoppingException(String savepointPath, JobID jobID, Throwable cause) {
        super(StopWithSavepointStoppingException.formatMessage(savepointPath, jobID), cause);
        this.savepointPath = savepointPath;
    }

    private static String formatMessage(String savepointPath, JobID jobID) {
        return String.format("A savepoint has been created at: %s, but the corresponding job %s failed during stopping. The savepoint is consistent, but might have uncommitted transactions. If you want to commit the transaction please restart a job from this savepoint.", savepointPath, jobID);
    }

    public String getSavepointPath() {
        return this.savepointPath;
    }
}

