/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.util.Collection;
import java.util.Collections;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.scheduler.adaptive.allocator.VertexParallelism;

@Internal
public class JobSchedulingPlan {
    private final VertexParallelism vertexParallelism;
    private final Collection<SlotAssignment> slotAssignments;

    public JobSchedulingPlan(VertexParallelism vertexParallelism, Collection<SlotAssignment> slotAssignments) {
        this.vertexParallelism = vertexParallelism;
        this.slotAssignments = slotAssignments;
    }

    public VertexParallelism getVertexParallelism() {
        return this.vertexParallelism;
    }

    public Collection<SlotAssignment> getSlotAssignments() {
        return this.slotAssignments;
    }

    public static JobSchedulingPlan empty() {
        return new JobSchedulingPlan(VertexParallelism.empty(), Collections.emptyList());
    }

    public String toString() {
        return String.format("JobSchedulingPlan: parallelism: %s, assignments: %s", this.vertexParallelism, this.slotAssignments);
    }

    public static class SlotAssignment {
        private final SlotInfo slotInfo;
        private final Object target;

        public SlotAssignment(SlotInfo slotInfo, Object target) {
            this.slotInfo = slotInfo;
            this.target = target;
        }

        public SlotInfo getSlotInfo() {
            return this.slotInfo;
        }

        public Object getTarget() {
            return this.target;
        }

        public <T> T getTargetAs(Class<T> clazz) {
            return (T)this.getTarget();
        }

        public String toString() {
            return String.format("SlotAssignment: %s, target: %s", this.slotInfo.getAllocationId(), this.target);
        }
    }
}

