/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.aggregators.AggregatorWithName;
import org.apache.flink.api.common.aggregators.ConvergenceCriterion;
import org.apache.flink.api.common.distributions.DataDistribution;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.common.typeutils.TypeComparatorFactory;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.operators.Driver;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.chaining.ChainedDriver;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.runtime.operators.util.CorruptConfigurationException;
import org.apache.flink.runtime.operators.util.LocalStrategy;
import org.apache.flink.types.Value;
import org.apache.flink.util.InstantiationUtil;

public class TaskConfig
implements Serializable {
    private static final long serialVersionUID = -2498884325640066272L;
    private static final String TASK_NAME = "taskname";
    private static final String STUB_OBJECT = "udf";
    private static final String STUB_PARAM_PREFIX = "udf.param.";
    private static final String DRIVER_CLASS = "driver.class";
    private static final String DRIVER_STRATEGY = "driver.strategy";
    private static final String DRIVER_COMPARATOR_FACTORY_PREFIX = "driver.comp.";
    private static final String DRIVER_COMPARATOR_PARAMETERS_PREFIX = "driver.comp.params.";
    private static final String DRIVER_PAIR_COMPARATOR_FACTORY = "driver.paircomp";
    private static final String NUM_INPUTS = "in.num";
    private static final String NUM_BROADCAST_INPUTS = "in.bc.num";
    private static final String INPUT_GROUP_SIZE_PREFIX = "in.groupsize.";
    private static final String BROADCAST_INPUT_GROUP_SIZE_PREFIX = "in.bc.groupsize.";
    private static final String INPUT_TYPE_SERIALIZER_FACTORY_PREFIX = "in.serializer.";
    private static final String BROADCAST_INPUT_TYPE_SERIALIZER_FACTORY_PREFIX = "in.bc.serializer.";
    private static final String INPUT_TYPE_SERIALIZER_PARAMETERS_PREFIX = "in.serializer.param.";
    private static final String BROADCAST_INPUT_TYPE_SERIALIZER_PARAMETERS_PREFIX = "in.bc.serializer.param.";
    private static final String INPUT_LOCAL_STRATEGY_PREFIX = "in.strategy.";
    private static final String INPUT_STRATEGY_COMPARATOR_FACTORY_PREFIX = "in.comparator.";
    private static final String INPUT_STRATEGY_COMPARATOR_PARAMETERS_PREFIX = "in.comparator.param.";
    private static final String INPUT_DAM_PREFIX = "in.dam.";
    private static final String INPUT_REPLAYABLE_PREFIX = "in.dam.replay.";
    private static final String INPUT_DAM_MEMORY_PREFIX = "in.dam.mem.";
    private static final String BROADCAST_INPUT_NAME_PREFIX = "in.broadcast.name.";
    private static final String OUTPUTS_NUM = "out.num";
    private static final String OUTPUT_TYPE_SERIALIZER_FACTORY = "out.serializer";
    private static final String OUTPUT_TYPE_SERIALIZER_PARAMETERS_PREFIX = "out.serializer.param.";
    private static final String OUTPUT_SHIP_STRATEGY_PREFIX = "out.shipstrategy.";
    private static final String OUTPUT_TYPE_COMPARATOR_FACTORY_PREFIX = "out.comp.";
    private static final String OUTPUT_TYPE_COMPARATOR_PARAMETERS_PREFIX = "out.comp.param.";
    private static final String OUTPUT_DATA_DISTRIBUTION_CLASS = "out.distribution.class";
    private static final String OUTPUT_DATA_DISTRIBUTION_PREFIX = "out.distribution.";
    private static final String OUTPUT_PARTITIONER = "out.partitioner.";
    private static final String CHAINING_NUM_STUBS = "chaining.num";
    private static final String CHAINING_TASKCONFIG_PREFIX = "chaining.taskconfig.";
    private static final String CHAINING_TASK_PREFIX = "chaining.task.";
    private static final String CHAINING_TASKNAME_PREFIX = "chaining.taskname.";
    private static final String MEMORY_DRIVER = "memory.driver";
    private static final String MEMORY_INPUT_PREFIX = "memory.input.";
    private static final String FILEHANDLES_DRIVER = "filehandles.driver";
    private static final String FILEHANDLES_INPUT_PREFIX = "filehandles.input.";
    private static final String SORT_SPILLING_THRESHOLD_DRIVER = "sort-spill-threshold.driver";
    private static final String SORT_SPILLING_THRESHOLD_INPUT_PREFIX = "sort-spill-threshold.input.";
    private static final String USE_LARGE_RECORD_HANDLER = "sort-spill.large-record-handler";
    private static final boolean USE_LARGE_RECORD_HANDLER_DEFAULT = false;
    private static final String NUMBER_OF_ITERATIONS = "iterative.num-iterations";
    private static final String NUMBER_OF_EOS_EVENTS_PREFIX = "iterative.num-eos-events.";
    private static final String NUMBER_OF_EOS_EVENTS_BROADCAST_PREFIX = "iterative.num-eos-events.bc.";
    private static final String ITERATION_HEAD_ID = "iterative.head.id";
    private static final String ITERATION_WORKSET_MARKER = "iterative.is-workset";
    private static final String ITERATION_HEAD_INDEX_OF_PARTIAL_SOLUTION = "iterative.head.ps-input-index";
    private static final String ITERATION_HEAD_INDEX_OF_SOLUTIONSET = "iterative.head.ss-input-index";
    private static final String ITERATION_HEAD_BACKCHANNEL_MEMORY = "iterative.head.backchannel-memory";
    private static final String ITERATION_HEAD_SOLUTION_SET_MEMORY = "iterative.head.solutionset-memory";
    private static final String ITERATION_HEAD_FINAL_OUT_CONFIG_PREFIX = "iterative.head.out.";
    private static final String ITERATION_HEAD_SYNC_OUT_INDEX = "iterative.head.sync-index.";
    private static final String ITERATION_CONVERGENCE_CRITERION = "iterative.terminationCriterion";
    private static final String ITERATION_CONVERGENCE_CRITERION_AGG_NAME = "iterative.terminationCriterion.agg.name";
    private static final String ITERATION_IMPLICIT_CONVERGENCE_CRITERION = "iterative.implicit.terminationCriterion";
    private static final String ITERATION_IMPLICIT_CONVERGENCE_CRITERION_AGG_NAME = "iterative.implicit.terminationCriterion.agg.name";
    private static final String ITERATION_NUM_AGGREGATORS = "iterative.num-aggs";
    private static final String ITERATION_AGGREGATOR_NAME_PREFIX = "iterative.agg.name.";
    private static final String ITERATION_AGGREGATOR_PREFIX = "iterative.agg.data.";
    private static final String ITERATION_SOLUTION_SET_SERIALIZER = "iterative.ss-serializer";
    private static final String ITERATION_SOLUTION_SET_SERIALIZER_PARAMETERS = "iterative.ss-serializer.params";
    private static final String ITERATION_SOLUTION_SET_COMPARATOR = "iterative.ss-comparator";
    private static final String ITERATION_SOLUTION_SET_COMPARATOR_PARAMETERS = "iterative.ss-comparator.params";
    private static final String ITERATION_SOLUTION_SET_UPDATE = "iterative.ss-update";
    private static final String ITERATION_SOLUTION_SET_UPDATE_SKIP_REPROBE = "iterative.ss-update-fast";
    private static final String ITERATION_SOLUTION_SET_UPDATE_WAIT = "iterative.ss-wait";
    private static final String ITERATION_WORKSET_UPDATE = "iterative.ws-update";
    private static final String SOLUTION_SET_OBJECTS = "itertive.ss.obj";
    private static final char SEPARATOR = '.';
    protected final Configuration config;

    public TaskConfig(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setTaskName(String name) {
        if (name != null) {
            this.config.setString(TASK_NAME, name);
        }
    }

    public String getTaskName() {
        return this.config.getString(TASK_NAME, null);
    }

    public boolean hasStubWrapper() {
        return this.config.containsKey(STUB_OBJECT);
    }

    public void setStubWrapper(UserCodeWrapper<?> wrapper) {
        try {
            InstantiationUtil.writeObjectToConfig(wrapper, this.config, STUB_OBJECT);
        }
        catch (IOException e) {
            throw new CorruptConfigurationException("Could not write the user code wrapper " + String.valueOf(wrapper.getClass()) + " : " + String.valueOf(e), e);
        }
    }

    public <T> UserCodeWrapper<T> getStubWrapper(ClassLoader cl) {
        try {
            return (UserCodeWrapper)InstantiationUtil.readObjectFromConfig(this.config, STUB_OBJECT, cl);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new CorruptConfigurationException("Could not read the user code wrapper: " + e.getMessage(), e);
        }
    }

    public void setStubParameters(Configuration parameters) {
        this.config.addAll(parameters, STUB_PARAM_PREFIX);
    }

    public Configuration getStubParameters() {
        return new DelegatingConfiguration(this.config, STUB_PARAM_PREFIX);
    }

    public void setStubParameter(String key, String value) {
        this.config.setString(STUB_PARAM_PREFIX + key, value);
    }

    public String getStubParameter(String key, String defaultValue) {
        return this.config.getString(STUB_PARAM_PREFIX + key, defaultValue);
    }

    public void setDriver(Class<? extends Driver> driver) {
        this.config.setString(DRIVER_CLASS, driver.getName());
    }

    public <S extends Function, OT> Class<? extends Driver<S, OT>> getDriver() {
        String className = this.config.getString(DRIVER_CLASS, null);
        if (className == null) {
            throw new CorruptConfigurationException("The pact driver class is missing.");
        }
        try {
            Class<Driver> pdClazz = Driver.class;
            return Class.forName(className).asSubclass(pdClazz);
        }
        catch (ClassNotFoundException cnfex) {
            throw new CorruptConfigurationException("The given driver class cannot be found.");
        }
        catch (ClassCastException ccex) {
            throw new CorruptConfigurationException("The given driver class does not implement the pact driver interface.");
        }
    }

    public void setDriverStrategy(DriverStrategy strategy) {
        this.config.set((ConfigOption)ConfigurationUtils.getIntConfigOption(DRIVER_STRATEGY), (Object)strategy.ordinal());
    }

    public DriverStrategy getDriverStrategy() {
        int ls = this.config.get(ConfigurationUtils.getIntConfigOption(DRIVER_STRATEGY), -1);
        if (ls == -1) {
            return DriverStrategy.NONE;
        }
        if (ls < 0 || ls >= DriverStrategy.values().length) {
            throw new CorruptConfigurationException("Illegal driver strategy in configuration: " + ls);
        }
        return DriverStrategy.values()[ls];
    }

    public void setDriverComparator(TypeComparatorFactory<?> factory, int inputNum) {
        this.setTypeComparatorFactory(factory, DRIVER_COMPARATOR_FACTORY_PREFIX + inputNum, DRIVER_COMPARATOR_PARAMETERS_PREFIX + inputNum + ".");
    }

    public <T> TypeComparatorFactory<T> getDriverComparator(int inputNum, ClassLoader cl) {
        return this.getTypeComparatorFactory(DRIVER_COMPARATOR_FACTORY_PREFIX + inputNum, DRIVER_COMPARATOR_PARAMETERS_PREFIX + inputNum + ".", cl);
    }

    public void setDriverPairComparator(TypePairComparatorFactory<?, ?> factory) {
        Class<?> clazz = factory.getClass();
        InstantiationUtil.checkForInstantiation(clazz);
        this.config.setString(DRIVER_PAIR_COMPARATOR_FACTORY, clazz.getName());
    }

    public <T1, T2> TypePairComparatorFactory<T1, T2> getPairComparatorFactory(ClassLoader cl) {
        String className = this.config.getString(DRIVER_PAIR_COMPARATOR_FACTORY, null);
        if (className == null) {
            return null;
        }
        Class<TypePairComparatorFactory> superClass = TypePairComparatorFactory.class;
        try {
            Class<TypePairComparatorFactory> clazz = Class.forName(className, true, cl).asSubclass(superClass);
            return InstantiationUtil.instantiate(clazz, superClass);
        }
        catch (ClassNotFoundException cnfex) {
            throw new RuntimeException("The class '" + className + "', noted in the configuration as pair comparator factory, could not be found. It is not part of the user code's class loader resources.");
        }
        catch (ClassCastException ccex) {
            throw new CorruptConfigurationException("The class noted in the configuration as the pair comparator factory is no subclass of TypePairComparatorFactory.");
        }
    }

    public void setInputLocalStrategy(int inputNum, LocalStrategy strategy) {
        this.config.set((ConfigOption)ConfigurationUtils.getIntConfigOption(INPUT_LOCAL_STRATEGY_PREFIX + inputNum), (Object)strategy.ordinal());
    }

    public LocalStrategy getInputLocalStrategy(int inputNum) {
        int ls = this.config.get(ConfigurationUtils.getIntConfigOption(INPUT_LOCAL_STRATEGY_PREFIX + inputNum), -1);
        if (ls == -1) {
            return LocalStrategy.NONE;
        }
        if (ls < 0 || ls >= LocalStrategy.values().length) {
            throw new CorruptConfigurationException("Illegal local strategy in configuration: " + ls);
        }
        return LocalStrategy.values()[ls];
    }

    public void setInputSerializer(TypeSerializerFactory<?> factory, int inputNum) {
        this.setTypeSerializerFactory(factory, INPUT_TYPE_SERIALIZER_FACTORY_PREFIX + inputNum, INPUT_TYPE_SERIALIZER_PARAMETERS_PREFIX + inputNum + ".");
    }

    public void setBroadcastInputSerializer(TypeSerializerFactory<?> factory, int inputNum) {
        this.setTypeSerializerFactory(factory, BROADCAST_INPUT_TYPE_SERIALIZER_FACTORY_PREFIX + inputNum, BROADCAST_INPUT_TYPE_SERIALIZER_PARAMETERS_PREFIX + inputNum + ".");
    }

    public <T> TypeSerializerFactory<T> getInputSerializer(int inputNum, ClassLoader cl) {
        return this.getTypeSerializerFactory(INPUT_TYPE_SERIALIZER_FACTORY_PREFIX + inputNum, INPUT_TYPE_SERIALIZER_PARAMETERS_PREFIX + inputNum + ".", cl);
    }

    public <T> TypeSerializerFactory<T> getBroadcastInputSerializer(int inputNum, ClassLoader cl) {
        return this.getTypeSerializerFactory(BROADCAST_INPUT_TYPE_SERIALIZER_FACTORY_PREFIX + inputNum, BROADCAST_INPUT_TYPE_SERIALIZER_PARAMETERS_PREFIX + inputNum + ".", cl);
    }

    public void setInputComparator(TypeComparatorFactory<?> factory, int inputNum) {
        this.setTypeComparatorFactory(factory, INPUT_STRATEGY_COMPARATOR_FACTORY_PREFIX + inputNum, INPUT_STRATEGY_COMPARATOR_PARAMETERS_PREFIX + inputNum + ".");
    }

    public <T> TypeComparatorFactory<T> getInputComparator(int inputNum, ClassLoader cl) {
        return this.getTypeComparatorFactory(INPUT_STRATEGY_COMPARATOR_FACTORY_PREFIX + inputNum, INPUT_STRATEGY_COMPARATOR_PARAMETERS_PREFIX + inputNum + ".", cl);
    }

    public int getNumInputs() {
        return this.config.get(ConfigurationUtils.getIntConfigOption(NUM_INPUTS), 0);
    }

    public int getNumBroadcastInputs() {
        return this.config.get(ConfigurationUtils.getIntConfigOption(NUM_BROADCAST_INPUTS), 0);
    }

    public int getGroupSize(int groupIndex) {
        return this.config.get(ConfigurationUtils.getIntConfigOption(INPUT_GROUP_SIZE_PREFIX + groupIndex), -1);
    }

    public int getBroadcastGroupSize(int groupIndex) {
        return this.config.get(ConfigurationUtils.getIntConfigOption(BROADCAST_INPUT_GROUP_SIZE_PREFIX + groupIndex), -1);
    }

    public void addInputToGroup(int groupIndex) {
        String grp = INPUT_GROUP_SIZE_PREFIX + groupIndex;
        this.config.set((ConfigOption)ConfigurationUtils.getIntConfigOption(grp), (Object)(this.config.get(ConfigurationUtils.getIntConfigOption(grp), 0) + 1));
        this.config.set((ConfigOption)ConfigurationUtils.getIntConfigOption(NUM_INPUTS), (Object)(this.config.get(ConfigurationUtils.getIntConfigOption(NUM_INPUTS), 0) + 1));
    }

    public void addBroadcastInputToGroup(int groupIndex) {
        String grp = BROADCAST_INPUT_GROUP_SIZE_PREFIX + groupIndex;
        if (!this.config.containsKey(grp)) {
            this.config.set((ConfigOption)ConfigurationUtils.getIntConfigOption(NUM_BROADCAST_INPUTS), (Object)(this.config.get(ConfigurationUtils.getIntConfigOption(NUM_BROADCAST_INPUTS), 0) + 1));
        }
        this.config.set((ConfigOption)ConfigurationUtils.getIntConfigOption(grp), (Object)(this.config.get(ConfigurationUtils.getIntConfigOption(grp), 0) + 1));
    }

    public void setInputAsynchronouslyMaterialized(int inputNum, boolean temp) {
        this.config.set((ConfigOption)ConfigurationUtils.getBooleanConfigOption(INPUT_DAM_PREFIX + inputNum), (Object)temp);
    }

    public boolean isInputAsynchronouslyMaterialized(int inputNum) {
        return this.config.get(ConfigurationUtils.getBooleanConfigOption(INPUT_DAM_PREFIX + inputNum), false);
    }

    public void setInputCached(int inputNum, boolean persistent) {
        this.config.set((ConfigOption)ConfigurationUtils.getBooleanConfigOption(INPUT_REPLAYABLE_PREFIX + inputNum), (Object)persistent);
    }

    public boolean isInputCached(int inputNum) {
        return this.config.get(ConfigurationUtils.getBooleanConfigOption(INPUT_REPLAYABLE_PREFIX + inputNum), false);
    }

    public void setRelativeInputMaterializationMemory(int inputNum, double relativeMemory) {
        this.config.set((ConfigOption)ConfigurationUtils.getDoubleConfigOption(INPUT_DAM_MEMORY_PREFIX + inputNum), (Object)relativeMemory);
    }

    public double getRelativeInputMaterializationMemory(int inputNum) {
        return this.config.get(ConfigurationUtils.getDoubleConfigOption(INPUT_DAM_MEMORY_PREFIX + inputNum), 0.0);
    }

    public void setBroadcastInputName(String name, int groupIndex) {
        this.config.setString(BROADCAST_INPUT_NAME_PREFIX + groupIndex, name);
    }

    public String getBroadcastInputName(int groupIndex) {
        return this.config.getString(BROADCAST_INPUT_NAME_PREFIX + groupIndex, String.format("broadcastVar%04d", groupIndex));
    }

    public void addOutputShipStrategy(ShipStrategyType strategy) {
        int outputCnt = this.config.get(ConfigurationUtils.getIntConfigOption(OUTPUTS_NUM), 0);
        this.config.set((ConfigOption)ConfigurationUtils.getIntConfigOption(OUTPUT_SHIP_STRATEGY_PREFIX + outputCnt), (Object)strategy.ordinal());
        this.config.set((ConfigOption)ConfigurationUtils.getIntConfigOption(OUTPUTS_NUM), (Object)(outputCnt + 1));
    }

    public int getNumOutputs() {
        return this.config.get(ConfigurationUtils.getIntConfigOption(OUTPUTS_NUM), 0);
    }

    public ShipStrategyType getOutputShipStrategy(int outputNum) {
        int outputCnt = this.config.get(ConfigurationUtils.getIntConfigOption(OUTPUTS_NUM), -1);
        if (outputCnt < 1) {
            throw new CorruptConfigurationException("No output ship strategies are specified in the configuration.");
        }
        if (outputNum < 0 || outputNum >= outputCnt) {
            throw new IllegalArgumentException("Invalid index for output shipping strategy.");
        }
        int strategy = this.config.get(ConfigurationUtils.getIntConfigOption(OUTPUT_SHIP_STRATEGY_PREFIX + outputNum), -1);
        if (strategy == -1) {
            throw new CorruptConfigurationException("No output shipping strategy in configuration for output " + outputNum);
        }
        if (strategy < 0 || strategy >= ShipStrategyType.values().length) {
            throw new CorruptConfigurationException("Illegal output shipping strategy in configuration for output " + outputNum + ": " + strategy);
        }
        return ShipStrategyType.values()[strategy];
    }

    public void setOutputSerializer(TypeSerializerFactory<?> factory) {
        this.setTypeSerializerFactory(factory, OUTPUT_TYPE_SERIALIZER_FACTORY, OUTPUT_TYPE_SERIALIZER_PARAMETERS_PREFIX);
    }

    public <T> TypeSerializerFactory<T> getOutputSerializer(ClassLoader cl) {
        return this.getTypeSerializerFactory(OUTPUT_TYPE_SERIALIZER_FACTORY, OUTPUT_TYPE_SERIALIZER_PARAMETERS_PREFIX, cl);
    }

    public void setOutputComparator(TypeComparatorFactory<?> factory, int outputNum) {
        this.setTypeComparatorFactory(factory, OUTPUT_TYPE_COMPARATOR_FACTORY_PREFIX + outputNum, OUTPUT_TYPE_COMPARATOR_PARAMETERS_PREFIX + outputNum + ".");
    }

    public <T> TypeComparatorFactory<T> getOutputComparator(int outputNum, ClassLoader cl) {
        return this.getTypeComparatorFactory(OUTPUT_TYPE_COMPARATOR_FACTORY_PREFIX + outputNum, OUTPUT_TYPE_COMPARATOR_PARAMETERS_PREFIX + outputNum + ".", cl);
    }

    public void setOutputDataDistribution(DataDistribution distribution, int outputNum) {
        this.config.setString(OUTPUT_DATA_DISTRIBUTION_CLASS, distribution.getClass().getName());
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper(baos);){
            distribution.write(out);
            this.config.setBytes(OUTPUT_DATA_DISTRIBUTION_PREFIX + outputNum, baos.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("Error serializing the DataDistribution: " + e.getMessage(), e);
        }
    }

    public DataDistribution getOutputDataDistribution(int outputNum, ClassLoader cl) throws ClassNotFoundException {
        Class<DataDistribution> clazz;
        String className = this.config.getString(OUTPUT_DATA_DISTRIBUTION_CLASS, null);
        if (className == null) {
            return null;
        }
        try {
            clazz = Class.forName(className, true, cl).asSubclass(DataDistribution.class);
        }
        catch (ClassCastException ccex) {
            throw new CorruptConfigurationException("The class noted in the configuration as the data distribution is no subclass of DataDistribution.");
        }
        DataDistribution distribution = InstantiationUtil.instantiate(clazz, DataDistribution.class);
        byte[] stateEncoded = this.config.getBytes(OUTPUT_DATA_DISTRIBUTION_PREFIX + outputNum, null);
        if (stateEncoded == null) {
            throw new CorruptConfigurationException("The configuration contained the data distribution type, but no serialized state.");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(stateEncoded);
        DataInputViewStreamWrapper in = new DataInputViewStreamWrapper(bais);
        try {
            distribution.read(in);
            return distribution;
        }
        catch (Exception ex) {
            throw new RuntimeException("The deserialization of the encoded data distribution state caused an error" + (String)(ex.getMessage() == null ? "." : ": " + ex.getMessage()), ex);
        }
    }

    public void setOutputPartitioner(Partitioner<?> partitioner, int outputNum) {
        try {
            InstantiationUtil.writeObjectToConfig(partitioner, this.config, OUTPUT_PARTITIONER + outputNum);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not serialize custom partitioner.", t);
        }
    }

    public Partitioner<?> getOutputPartitioner(int outputNum, ClassLoader cl) throws ClassNotFoundException {
        try {
            return (Partitioner)InstantiationUtil.readObjectFromConfig(this.config, OUTPUT_PARTITIONER + outputNum, cl);
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not deserialize custom partitioner.", t);
        }
    }

    public void setRelativeMemoryDriver(double relativeMemorySize) {
        this.config.set((ConfigOption)ConfigurationUtils.getDoubleConfigOption(MEMORY_DRIVER), (Object)relativeMemorySize);
    }

    public double getRelativeMemoryDriver() {
        return this.config.get(ConfigurationUtils.getDoubleConfigOption(MEMORY_DRIVER), 0.0);
    }

    public void setRelativeMemoryInput(int inputNum, double relativeMemorySize) {
        this.config.set((ConfigOption)ConfigurationUtils.getDoubleConfigOption(MEMORY_INPUT_PREFIX + inputNum), (Object)relativeMemorySize);
    }

    public double getRelativeMemoryInput(int inputNum) {
        return this.config.get(ConfigurationUtils.getDoubleConfigOption(MEMORY_INPUT_PREFIX + inputNum), 0.0);
    }

    public void setFilehandlesDriver(int filehandles) {
        if (filehandles < 2) {
            throw new IllegalArgumentException();
        }
        this.config.set((ConfigOption)ConfigurationUtils.getIntConfigOption(FILEHANDLES_DRIVER), (Object)filehandles);
    }

    public int getFilehandlesDriver() {
        return this.config.get(ConfigurationUtils.getIntConfigOption(FILEHANDLES_DRIVER), -1);
    }

    public void setFilehandlesInput(int inputNum, int filehandles) {
        if (filehandles < 2) {
            throw new IllegalArgumentException();
        }
        this.config.set((ConfigOption)ConfigurationUtils.getIntConfigOption(FILEHANDLES_INPUT_PREFIX + inputNum), (Object)filehandles);
    }

    public int getFilehandlesInput(int inputNum) {
        return this.config.get(ConfigurationUtils.getIntConfigOption(FILEHANDLES_INPUT_PREFIX + inputNum), -1);
    }

    public void setSpillingThresholdDriver(float threshold) {
        if (threshold < 0.0f || threshold > 1.0f) {
            throw new IllegalArgumentException();
        }
        this.config.set((ConfigOption)ConfigurationUtils.getFloatConfigOption(SORT_SPILLING_THRESHOLD_DRIVER), Float.valueOf(threshold));
    }

    public float getSpillingThresholdDriver() {
        return this.config.get(ConfigurationUtils.getFloatConfigOption(SORT_SPILLING_THRESHOLD_DRIVER), Float.valueOf(0.7f)).floatValue();
    }

    public void setSpillingThresholdInput(int inputNum, float threshold) {
        if (threshold < 0.0f || threshold > 1.0f) {
            throw new IllegalArgumentException();
        }
        this.config.set((ConfigOption)ConfigurationUtils.getFloatConfigOption(SORT_SPILLING_THRESHOLD_INPUT_PREFIX + inputNum), Float.valueOf(threshold));
    }

    public float getSpillingThresholdInput(int inputNum) {
        return this.config.get(ConfigurationUtils.getFloatConfigOption(SORT_SPILLING_THRESHOLD_INPUT_PREFIX + inputNum), Float.valueOf(0.7f)).floatValue();
    }

    public void setUseLargeRecordHandler(boolean useLargeRecordHandler) {
        this.config.set((ConfigOption)ConfigurationUtils.getBooleanConfigOption(USE_LARGE_RECORD_HANDLER), (Object)useLargeRecordHandler);
    }

    public boolean getUseLargeRecordHandler() {
        return this.config.get(ConfigurationUtils.getBooleanConfigOption(USE_LARGE_RECORD_HANDLER), false);
    }

    public int getNumberOfChainedStubs() {
        return this.config.get(ConfigurationUtils.getIntConfigOption(CHAINING_NUM_STUBS), 0);
    }

    public void addChainedTask(Class<? extends ChainedDriver> chainedTaskClass, TaskConfig conf, String taskName) {
        int numChainedYet = this.config.get(ConfigurationUtils.getIntConfigOption(CHAINING_NUM_STUBS), 0);
        this.config.setString(CHAINING_TASK_PREFIX + numChainedYet, chainedTaskClass.getName());
        this.config.addAll(conf.config, CHAINING_TASKCONFIG_PREFIX + numChainedYet + ".");
        this.config.setString(CHAINING_TASKNAME_PREFIX + numChainedYet, taskName);
        this.config.set((ConfigOption)ConfigurationUtils.getIntConfigOption(CHAINING_NUM_STUBS), (Object)(++numChainedYet));
    }

    public TaskConfig getChainedStubConfig(int chainPos) {
        return new TaskConfig(new DelegatingConfiguration(this.config, CHAINING_TASKCONFIG_PREFIX + chainPos + "."));
    }

    public Class<? extends ChainedDriver<?, ?>> getChainedTask(int chainPos) {
        String className = this.config.getString(CHAINING_TASK_PREFIX + chainPos, null);
        if (className == null) {
            throw new IllegalStateException("Chained Task Class missing");
        }
        Class<ChainedDriver> clazz = ChainedDriver.class;
        try {
            return Class.forName(className).asSubclass(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String getChainedTaskName(int chainPos) {
        return this.config.getString(CHAINING_TASKNAME_PREFIX + chainPos, null);
    }

    public void setNumberOfIterations(int numberOfIterations) {
        if (numberOfIterations <= 0) {
            throw new IllegalArgumentException();
        }
        this.config.set((ConfigOption)ConfigurationUtils.getIntConfigOption(NUMBER_OF_ITERATIONS), (Object)numberOfIterations);
    }

    public int getNumberOfIterations() {
        int numberOfIterations = this.config.get(ConfigurationUtils.getIntConfigOption(NUMBER_OF_ITERATIONS), 0);
        if (numberOfIterations <= 0) {
            throw new IllegalArgumentException();
        }
        return numberOfIterations;
    }

    public void setIterationHeadPartialSolutionOrWorksetInputIndex(int inputIndex) {
        if (inputIndex < 0) {
            throw new IllegalArgumentException();
        }
        this.config.set((ConfigOption)ConfigurationUtils.getIntConfigOption(ITERATION_HEAD_INDEX_OF_PARTIAL_SOLUTION), (Object)inputIndex);
    }

    public int getIterationHeadPartialSolutionOrWorksetInputIndex() {
        int index = this.config.get(ConfigurationUtils.getIntConfigOption(ITERATION_HEAD_INDEX_OF_PARTIAL_SOLUTION), -1);
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        return index;
    }

    public void setIterationHeadSolutionSetInputIndex(int inputIndex) {
        if (inputIndex < 0) {
            throw new IllegalArgumentException();
        }
        this.config.set((ConfigOption)ConfigurationUtils.getIntConfigOption(ITERATION_HEAD_INDEX_OF_SOLUTIONSET), (Object)inputIndex);
    }

    public int getIterationHeadSolutionSetInputIndex() {
        int index = this.config.get(ConfigurationUtils.getIntConfigOption(ITERATION_HEAD_INDEX_OF_SOLUTIONSET), -1);
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        return index;
    }

    public void setRelativeBackChannelMemory(double relativeMemory) {
        if (relativeMemory < 0.0) {
            throw new IllegalArgumentException();
        }
        this.config.set((ConfigOption)ConfigurationUtils.getDoubleConfigOption(ITERATION_HEAD_BACKCHANNEL_MEMORY), (Object)relativeMemory);
    }

    public double getRelativeBackChannelMemory() {
        double relativeBackChannelMemory = this.config.get(ConfigurationUtils.getDoubleConfigOption(ITERATION_HEAD_BACKCHANNEL_MEMORY), 0.0);
        if (relativeBackChannelMemory <= 0.0) {
            throw new IllegalArgumentException();
        }
        return relativeBackChannelMemory;
    }

    public void setRelativeSolutionSetMemory(double relativeMemory) {
        if (relativeMemory < 0.0) {
            throw new IllegalArgumentException();
        }
        this.config.set((ConfigOption)ConfigurationUtils.getDoubleConfigOption(ITERATION_HEAD_SOLUTION_SET_MEMORY), (Object)relativeMemory);
    }

    public double getRelativeSolutionSetMemory() {
        double backChannelMemory = this.config.get(ConfigurationUtils.getDoubleConfigOption(ITERATION_HEAD_SOLUTION_SET_MEMORY), 0.0);
        if (backChannelMemory <= 0.0) {
            throw new IllegalArgumentException();
        }
        return backChannelMemory;
    }

    public boolean isIterativeInputGate(int inputGateIndex) {
        return this.getNumberOfEventsUntilInterruptInIterativeGate(inputGateIndex) > 0;
    }

    public void setGateIterativeWithNumberOfEventsUntilInterrupt(int inputGateIndex, int numEvents) {
        if (inputGateIndex < 0) {
            throw new IllegalArgumentException();
        }
        if (numEvents <= 0) {
            throw new IllegalArgumentException();
        }
        this.config.set((ConfigOption)ConfigurationUtils.getIntConfigOption(NUMBER_OF_EOS_EVENTS_PREFIX + inputGateIndex), (Object)numEvents);
    }

    public int getNumberOfEventsUntilInterruptInIterativeGate(int inputGateIndex) {
        if (inputGateIndex < 0) {
            throw new IllegalArgumentException();
        }
        return this.config.get(ConfigurationUtils.getIntConfigOption(NUMBER_OF_EOS_EVENTS_PREFIX + inputGateIndex), 0);
    }

    public void setBroadcastGateIterativeWithNumberOfEventsUntilInterrupt(int bcGateIndex, int numEvents) {
        if (bcGateIndex < 0) {
            throw new IllegalArgumentException();
        }
        if (numEvents <= 0) {
            throw new IllegalArgumentException();
        }
        this.config.set((ConfigOption)ConfigurationUtils.getIntConfigOption(NUMBER_OF_EOS_EVENTS_BROADCAST_PREFIX + bcGateIndex), (Object)numEvents);
    }

    public int getNumberOfEventsUntilInterruptInIterativeBroadcastGate(int bcGateIndex) {
        if (bcGateIndex < 0) {
            throw new IllegalArgumentException();
        }
        return this.config.get(ConfigurationUtils.getIntConfigOption(NUMBER_OF_EOS_EVENTS_BROADCAST_PREFIX + bcGateIndex), 0);
    }

    public void setIterationId(int id) {
        if (id < 0) {
            throw new IllegalArgumentException();
        }
        this.config.set((ConfigOption)ConfigurationUtils.getIntConfigOption(ITERATION_HEAD_ID), (Object)id);
    }

    public int getIterationId() {
        int id = this.config.get(ConfigurationUtils.getIntConfigOption(ITERATION_HEAD_ID), -1);
        if (id == -1) {
            throw new CorruptConfigurationException("Iteration head ID is missing.");
        }
        return id;
    }

    public void setIsWorksetIteration() {
        this.config.set((ConfigOption)ConfigurationUtils.getBooleanConfigOption(ITERATION_WORKSET_MARKER), (Object)true);
    }

    public boolean getIsWorksetIteration() {
        return this.config.get(ConfigurationUtils.getBooleanConfigOption(ITERATION_WORKSET_MARKER), false);
    }

    public void setIterationHeadIndexOfSyncOutput(int outputIndex) {
        if (outputIndex < 0) {
            throw new IllegalArgumentException();
        }
        this.config.set((ConfigOption)ConfigurationUtils.getIntConfigOption(ITERATION_HEAD_SYNC_OUT_INDEX), (Object)outputIndex);
    }

    public int getIterationHeadIndexOfSyncOutput() {
        int outputIndex = this.config.get(ConfigurationUtils.getIntConfigOption(ITERATION_HEAD_SYNC_OUT_INDEX), -1);
        if (outputIndex < 0) {
            throw new IllegalArgumentException();
        }
        return outputIndex;
    }

    public void setIterationHeadFinalOutputConfig(TaskConfig conf) {
        this.config.addAll(conf.config, ITERATION_HEAD_FINAL_OUT_CONFIG_PREFIX);
    }

    public TaskConfig getIterationHeadFinalOutputConfig() {
        return new TaskConfig(new DelegatingConfiguration(this.config, ITERATION_HEAD_FINAL_OUT_CONFIG_PREFIX));
    }

    public void setSolutionSetSerializer(TypeSerializerFactory<?> factory) {
        this.setTypeSerializerFactory(factory, ITERATION_SOLUTION_SET_SERIALIZER, ITERATION_SOLUTION_SET_SERIALIZER_PARAMETERS);
    }

    public <T> TypeSerializerFactory<T> getSolutionSetSerializer(ClassLoader cl) {
        return this.getTypeSerializerFactory(ITERATION_SOLUTION_SET_SERIALIZER, ITERATION_SOLUTION_SET_SERIALIZER_PARAMETERS, cl);
    }

    public void setSolutionSetComparator(TypeComparatorFactory<?> factory) {
        this.setTypeComparatorFactory(factory, ITERATION_SOLUTION_SET_COMPARATOR, ITERATION_SOLUTION_SET_COMPARATOR_PARAMETERS);
    }

    public <T> TypeComparatorFactory<T> getSolutionSetComparator(ClassLoader cl) {
        return this.getTypeComparatorFactory(ITERATION_SOLUTION_SET_COMPARATOR, ITERATION_SOLUTION_SET_COMPARATOR_PARAMETERS, cl);
    }

    public void addIterationAggregator(String name, Aggregator<?> aggregator) {
        int num = this.config.get(ConfigurationUtils.getIntConfigOption(ITERATION_NUM_AGGREGATORS), 0);
        this.config.setString(ITERATION_AGGREGATOR_NAME_PREFIX + num, name);
        try {
            InstantiationUtil.writeObjectToConfig(aggregator, this.config, ITERATION_AGGREGATOR_PREFIX + num);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while writing the aggregator object to the task configuration.");
        }
        this.config.set((ConfigOption)ConfigurationUtils.getIntConfigOption(ITERATION_NUM_AGGREGATORS), (Object)(num + 1));
    }

    public void addIterationAggregators(Collection<AggregatorWithName<?>> aggregators) {
        int num = this.config.get(ConfigurationUtils.getIntConfigOption(ITERATION_NUM_AGGREGATORS), 0);
        for (AggregatorWithName<?> awn : aggregators) {
            this.config.setString(ITERATION_AGGREGATOR_NAME_PREFIX + num, awn.getName());
            try {
                InstantiationUtil.writeObjectToConfig(awn.getAggregator(), this.config, ITERATION_AGGREGATOR_PREFIX + num);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while writing the aggregator object to the task configuration.");
            }
            ++num;
        }
        this.config.set((ConfigOption)ConfigurationUtils.getIntConfigOption(ITERATION_NUM_AGGREGATORS), (Object)num);
    }

    public Collection<AggregatorWithName<?>> getIterationAggregators(ClassLoader cl) {
        int numAggs = this.config.get(ConfigurationUtils.getIntConfigOption(ITERATION_NUM_AGGREGATORS), 0);
        if (numAggs == 0) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(numAggs);
        for (int i = 0; i < numAggs; ++i) {
            Aggregator aggObj;
            try {
                aggObj = (Aggregator)InstantiationUtil.readObjectFromConfig(this.config, ITERATION_AGGREGATOR_PREFIX + i, cl);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while reading the aggregator object from the task configuration.");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Error while reading the aggregator object from the task configuration. Aggregator class not found.");
            }
            if (aggObj == null) {
                throw new RuntimeException("Missing config entry for aggregator.");
            }
            String name = this.config.getString(ITERATION_AGGREGATOR_NAME_PREFIX + i, null);
            if (name == null) {
                throw new RuntimeException("Missing config entry for aggregator.");
            }
            list.add(new AggregatorWithName(name, aggObj));
        }
        return list;
    }

    public void setConvergenceCriterion(String aggregatorName, ConvergenceCriterion<?> convCriterion) {
        try {
            InstantiationUtil.writeObjectToConfig(convCriterion, this.config, ITERATION_CONVERGENCE_CRITERION);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while writing the convergence criterion object to the task configuration.");
        }
        this.config.setString(ITERATION_CONVERGENCE_CRITERION_AGG_NAME, aggregatorName);
    }

    public void setImplicitConvergenceCriterion(String aggregatorName, ConvergenceCriterion<?> convCriterion) {
        try {
            InstantiationUtil.writeObjectToConfig(convCriterion, this.config, ITERATION_IMPLICIT_CONVERGENCE_CRITERION);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while writing the implicit convergence criterion object to the task configuration.");
        }
        this.config.setString(ITERATION_IMPLICIT_CONVERGENCE_CRITERION_AGG_NAME, aggregatorName);
    }

    public <T extends Value> ConvergenceCriterion<T> getConvergenceCriterion(ClassLoader cl) {
        ConvergenceCriterion convCriterionObj;
        try {
            convCriterionObj = (ConvergenceCriterion)InstantiationUtil.readObjectFromConfig(this.config, ITERATION_CONVERGENCE_CRITERION, cl);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading the convergence criterion object from the task configuration.");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Error while reading the convergence criterion object from the task configuration. ConvergenceCriterion class not found.");
        }
        if (convCriterionObj == null) {
            throw new NullPointerException();
        }
        return convCriterionObj;
    }

    public boolean usesConvergenceCriterion() {
        return this.config.getBytes(ITERATION_CONVERGENCE_CRITERION, null) != null;
    }

    public String getConvergenceCriterionAggregatorName() {
        return this.config.getString(ITERATION_CONVERGENCE_CRITERION_AGG_NAME, null);
    }

    public <T extends Value> ConvergenceCriterion<T> getImplicitConvergenceCriterion(ClassLoader cl) {
        ConvergenceCriterion convCriterionObj;
        try {
            convCriterionObj = (ConvergenceCriterion)InstantiationUtil.readObjectFromConfig(this.config, ITERATION_IMPLICIT_CONVERGENCE_CRITERION, cl);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading the default convergence criterion object from the task configuration.");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Error while reading the default convergence criterion object from the task configuration. ConvergenceCriterion class not found.");
        }
        if (convCriterionObj == null) {
            throw new NullPointerException();
        }
        return convCriterionObj;
    }

    public boolean usesImplicitConvergenceCriterion() {
        return this.config.getBytes(ITERATION_IMPLICIT_CONVERGENCE_CRITERION, null) != null;
    }

    public String getImplicitConvergenceCriterionAggregatorName() {
        return this.config.getString(ITERATION_IMPLICIT_CONVERGENCE_CRITERION_AGG_NAME, null);
    }

    public void setIsSolutionSetUpdate() {
        this.config.set((ConfigOption)ConfigurationUtils.getBooleanConfigOption(ITERATION_SOLUTION_SET_UPDATE), (Object)true);
    }

    public boolean getIsSolutionSetUpdate() {
        return this.config.get(ConfigurationUtils.getBooleanConfigOption(ITERATION_SOLUTION_SET_UPDATE), false);
    }

    public void setIsSolutionSetUpdateWithoutReprobe() {
        this.config.set((ConfigOption)ConfigurationUtils.getBooleanConfigOption(ITERATION_SOLUTION_SET_UPDATE_SKIP_REPROBE), (Object)true);
    }

    public void setWaitForSolutionSetUpdate() {
        this.config.set((ConfigOption)ConfigurationUtils.getBooleanConfigOption(ITERATION_SOLUTION_SET_UPDATE_WAIT), (Object)true);
    }

    public boolean getWaitForSolutionSetUpdate() {
        return this.config.get(ConfigurationUtils.getBooleanConfigOption(ITERATION_SOLUTION_SET_UPDATE_WAIT), false);
    }

    public void setIsWorksetUpdate() {
        this.config.set((ConfigOption)ConfigurationUtils.getBooleanConfigOption(ITERATION_WORKSET_UPDATE), (Object)true);
    }

    public boolean getIsWorksetUpdate() {
        return this.config.get(ConfigurationUtils.getBooleanConfigOption(ITERATION_WORKSET_UPDATE), false);
    }

    private void setTypeSerializerFactory(TypeSerializerFactory<?> factory, String classNameKey, String parametersPrefix) {
        InstantiationUtil.checkForInstantiation(factory.getClass());
        this.config.setString(classNameKey, factory.getClass().getName());
        DelegatingConfiguration parameters = new DelegatingConfiguration(this.config, parametersPrefix);
        factory.writeParametersToConfig(parameters);
    }

    private <T> TypeSerializerFactory<T> getTypeSerializerFactory(String classNameKey, String parametersPrefix, ClassLoader cl) {
        TypeSerializerFactory factory;
        String className = this.config.getString(classNameKey, null);
        if (className == null) {
            return null;
        }
        Class<TypeSerializerFactory> superClass = TypeSerializerFactory.class;
        try {
            Class<TypeSerializerFactory> clazz = Class.forName(className, true, cl).asSubclass(superClass);
            factory = InstantiationUtil.instantiate(clazz, superClass);
        }
        catch (ClassNotFoundException cnfex) {
            throw new RuntimeException("The class '" + className + "', noted in the configuration as serializer factory, could not be found. It is not part of the user code's class loader resources.");
        }
        catch (ClassCastException ccex) {
            throw new CorruptConfigurationException("The class noted in the configuration as the serializer factory is no subclass of TypeSerializerFactory.");
        }
        DelegatingConfiguration parameters = new DelegatingConfiguration(this.config, parametersPrefix);
        try {
            factory.readParametersFromConfig(parameters, cl);
        }
        catch (ClassNotFoundException cnfex) {
            throw new RuntimeException("The type serializer factory could not load its parameters from the configuration due to missing classes.", cnfex);
        }
        return factory;
    }

    private void setTypeComparatorFactory(TypeComparatorFactory<?> factory, String classNameKey, String parametersPrefix) {
        InstantiationUtil.checkForInstantiation(factory.getClass());
        this.config.setString(classNameKey, factory.getClass().getName());
        DelegatingConfiguration parameters = new DelegatingConfiguration(this.config, parametersPrefix);
        factory.writeParametersToConfig(parameters);
    }

    private <T> TypeComparatorFactory<T> getTypeComparatorFactory(String classNameKey, String parametersPrefix, ClassLoader cl) {
        TypeComparatorFactory factory;
        String className = this.config.getString(classNameKey, null);
        if (className == null) {
            return null;
        }
        Class<TypeComparatorFactory> superClass = TypeComparatorFactory.class;
        try {
            Class<TypeComparatorFactory> clazz = Class.forName(className, true, cl).asSubclass(superClass);
            factory = InstantiationUtil.instantiate(clazz, superClass);
        }
        catch (ClassNotFoundException cnfex) {
            throw new RuntimeException("The class '" + className + "', noted in the configuration as comparator factory, could not be found. It is not part of the user code's class loader resources.");
        }
        catch (ClassCastException ccex) {
            throw new CorruptConfigurationException("The class noted in the configuration as the comparator factory is no subclass of TypeComparatorFactory.");
        }
        DelegatingConfiguration parameters = new DelegatingConfiguration(this.config, parametersPrefix);
        try {
            factory.readParametersFromConfig(parameters, cl);
        }
        catch (ClassNotFoundException cnfex) {
            throw new RuntimeException("The type serializer factory could not load its parameters from the configuration due to missing classes.", cnfex);
        }
        return factory;
    }

    public void setSolutionSetUnmanaged(boolean unmanaged) {
        this.config.set((ConfigOption)ConfigurationUtils.getBooleanConfigOption(SOLUTION_SET_OBJECTS), (Object)unmanaged);
    }

    public boolean isSolutionSetUnmanaged() {
        return this.config.get(ConfigurationUtils.getBooleanConfigOption(SOLUTION_SET_OBJECTS), false);
    }
}

