/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import javax.annotation.Nonnull;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.PendingRequest;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.scheduler.loading.LoadingWeight;
import org.apache.flink.runtime.scheduler.loading.WeightLoadable;

public class PhysicalSlotRequest
implements WeightLoadable {
    private final SlotRequestId slotRequestId;
    private final SlotProfile slotProfile;
    private final LoadingWeight loadingWeight;
    private final boolean slotWillBeOccupiedIndefinitely;

    public PhysicalSlotRequest(SlotRequestId slotRequestId, SlotProfile slotProfile, LoadingWeight loadingWeight, boolean slotWillBeOccupiedIndefinitely) {
        this.slotRequestId = slotRequestId;
        this.slotProfile = slotProfile;
        this.loadingWeight = loadingWeight;
        this.slotWillBeOccupiedIndefinitely = slotWillBeOccupiedIndefinitely;
    }

    public SlotRequestId getSlotRequestId() {
        return this.slotRequestId;
    }

    public SlotProfile getSlotProfile() {
        return this.slotProfile;
    }

    public ResourceProfile getPhysicalSlotResourceProfile() {
        return this.slotProfile.getPhysicalSlotResourceProfile();
    }

    public boolean willSlotBeOccupiedIndefinitely() {
        return this.slotWillBeOccupiedIndefinitely;
    }

    PendingRequest toPendingRequest() {
        return this.slotWillBeOccupiedIndefinitely ? PendingRequest.createNormalRequest(this.slotRequestId, this.slotProfile.getPhysicalSlotResourceProfile(), this.loadingWeight, this.slotProfile.getPreferredAllocations()) : PendingRequest.createBatchRequest(this.slotRequestId, this.slotProfile.getPhysicalSlotResourceProfile(), this.loadingWeight, this.slotProfile.getPreferredAllocations());
    }

    @Override
    @Nonnull
    public LoadingWeight getLoading() {
        return this.loadingWeight;
    }

    public static class Result {
        private final SlotRequestId slotRequestId;
        private final PhysicalSlot physicalSlot;

        public Result(SlotRequestId slotRequestId, PhysicalSlot physicalSlot) {
            this.slotRequestId = slotRequestId;
            this.physicalSlot = physicalSlot;
        }

        public SlotRequestId getSlotRequestId() {
            return this.slotRequestId;
        }

        public PhysicalSlot getPhysicalSlot() {
            return this.physicalSlot;
        }
    }
}

