/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.StateRecoveryOptions;
import org.apache.flink.core.execution.RecoveryClaimMode;
import org.apache.flink.util.Preconditions;

public class SavepointRestoreSettings
implements Serializable {
    private static final long serialVersionUID = 87377506900849777L;
    private static final SavepointRestoreSettings NONE = new SavepointRestoreSettings(null, false, RecoveryClaimMode.NO_CLAIM);
    private final String restorePath;
    private final boolean allowNonRestoredState;
    @Nonnull
    private final RecoveryClaimMode recoveryClaimMode;

    private SavepointRestoreSettings(String restorePath, boolean allowNonRestoredState, @Nonnull RecoveryClaimMode recoveryClaimMode) {
        this.restorePath = restorePath;
        this.allowNonRestoredState = allowNonRestoredState;
        this.recoveryClaimMode = recoveryClaimMode;
    }

    public boolean restoreSavepoint() {
        return this.restorePath != null;
    }

    public String getRestorePath() {
        return this.restorePath;
    }

    public boolean allowNonRestoredState() {
        return this.allowNonRestoredState;
    }

    @Nonnull
    public RecoveryClaimMode getRecoveryClaimMode() {
        return this.recoveryClaimMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SavepointRestoreSettings that = (SavepointRestoreSettings)o;
        return this.allowNonRestoredState == that.allowNonRestoredState && Objects.equals(this.restorePath, that.restorePath) && Objects.equals(this.recoveryClaimMode, that.recoveryClaimMode);
    }

    public int hashCode() {
        int result = this.restorePath != null ? this.restorePath.hashCode() : 0;
        result = 31 * result + this.recoveryClaimMode.hashCode();
        result = 31 * result + (this.allowNonRestoredState ? 1 : 0);
        return result;
    }

    public String toString() {
        if (this.restoreSavepoint()) {
            return "SavepointRestoreSettings.forPath(restorePath='" + this.restorePath + "', allowNonRestoredState=" + this.allowNonRestoredState + ", recoveryClaimMode=" + String.valueOf(this.recoveryClaimMode) + ")";
        }
        return "SavepointRestoreSettings.none()";
    }

    public static SavepointRestoreSettings none() {
        return NONE;
    }

    public static SavepointRestoreSettings forPath(String savepointPath) {
        return SavepointRestoreSettings.forPath(savepointPath, StateRecoveryOptions.SAVEPOINT_IGNORE_UNCLAIMED_STATE.defaultValue());
    }

    public static SavepointRestoreSettings forPath(String savepointPath, boolean allowNonRestoredState) {
        Preconditions.checkNotNull(savepointPath, "Savepoint restore path.");
        return new SavepointRestoreSettings(savepointPath, allowNonRestoredState, StateRecoveryOptions.RESTORE_MODE.defaultValue());
    }

    public static SavepointRestoreSettings forPath(String savepointPath, boolean allowNonRestoredState, @Nonnull RecoveryClaimMode recoveryClaimMode) {
        Preconditions.checkNotNull(savepointPath, "Savepoint restore path.");
        return new SavepointRestoreSettings(savepointPath, allowNonRestoredState, recoveryClaimMode);
    }

    public static void toConfiguration(SavepointRestoreSettings savepointRestoreSettings, Configuration configuration) {
        configuration.set((ConfigOption)StateRecoveryOptions.SAVEPOINT_IGNORE_UNCLAIMED_STATE, (Object)savepointRestoreSettings.allowNonRestoredState());
        configuration.set((ConfigOption)StateRecoveryOptions.RESTORE_MODE, savepointRestoreSettings.getRecoveryClaimMode());
        String savepointPath = savepointRestoreSettings.getRestorePath();
        if (savepointPath != null) {
            configuration.set((ConfigOption)StateRecoveryOptions.SAVEPOINT_PATH, savepointPath);
        }
    }

    public static SavepointRestoreSettings fromConfiguration(ReadableConfig configuration) {
        String savepointPath = configuration.get(StateRecoveryOptions.SAVEPOINT_PATH);
        boolean allowNonRestored = configuration.get(StateRecoveryOptions.SAVEPOINT_IGNORE_UNCLAIMED_STATE);
        RecoveryClaimMode recoveryClaimMode = configuration.get(StateRecoveryOptions.RESTORE_MODE);
        return savepointPath == null ? SavepointRestoreSettings.none() : SavepointRestoreSettings.forPath(savepointPath, allowNonRestored, recoveryClaimMode);
    }
}

