/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.file;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageIdMappingUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.SegmentPartitionFileReader;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.SegmentPartitionFileWriter;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentPartitionFile {
    private static final Logger LOG = LoggerFactory.getLogger(SegmentPartitionFile.class);
    static final String TIERED_STORAGE_DIR = "tiered-storage";
    static final String SEGMENT_FILE_PREFIX = "seg-";
    @VisibleForTesting
    public static final String SEGMENT_FINISH_DIR_NAME = "FINISH";

    public static SegmentPartitionFileWriter createPartitionFileWriter(String dataFilePath, int numSubpartitions) {
        return new SegmentPartitionFileWriter(dataFilePath, numSubpartitions);
    }

    public static SegmentPartitionFileReader createPartitionFileReader(String dataFilePath) {
        return new SegmentPartitionFileReader(dataFilePath);
    }

    public static String getTieredStoragePath(String basePath) {
        return String.format("%s/%s", basePath, TIERED_STORAGE_DIR);
    }

    public static String getPartitionPath(TieredStoragePartitionId partitionId, String basePath) {
        if (basePath == null) {
            return null;
        }
        while (basePath.endsWith("/") && basePath.length() > 1) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        return String.format("%s/%s", basePath, TieredStorageIdMappingUtils.convertId(partitionId));
    }

    public static String getSubpartitionPath(String basePath, TieredStoragePartitionId partitionId, int subpartitionId) {
        while (basePath.endsWith("/") && basePath.length() > 1) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        return String.format("%s/%s/%s", basePath, TieredStorageIdMappingUtils.convertId(partitionId), subpartitionId);
    }

    public static Path getSegmentPath(String basePath, TieredStoragePartitionId partitionId, int subpartitionId, long segmentId) {
        String subpartitionPath = SegmentPartitionFile.getSubpartitionPath(basePath, partitionId, subpartitionId);
        return new Path(subpartitionPath, SEGMENT_FILE_PREFIX + segmentId);
    }

    public static Path getSegmentFinishDirPath(String basePath, TieredStoragePartitionId partitionId, int subpartitionId) {
        String subpartitionPath = SegmentPartitionFile.getSubpartitionPath(basePath, partitionId, subpartitionId);
        return new Path(subpartitionPath, SEGMENT_FINISH_DIR_NAME);
    }

    public static void writeBuffers(WritableByteChannel writeChannel, long expectedBytes, ByteBuffer[] bufferWithHeaders) throws IOException {
        int writeSize = 0;
        for (ByteBuffer bufferWithHeader : bufferWithHeaders) {
            writeSize += writeChannel.write(bufferWithHeader);
        }
        Preconditions.checkState((long)writeSize == expectedBytes, "Wong number of written bytes.");
    }

    public static void writeSegmentFinishFile(String basePath, TieredStoragePartitionId partitionId, int subpartitionId, int segmentId) throws IOException {
        Path segmentFinishDir = SegmentPartitionFile.getSegmentFinishDirPath(basePath, partitionId, subpartitionId);
        FileSystem fs = segmentFinishDir.getFileSystem();
        Path segmentFinishFile = new Path(segmentFinishDir, String.valueOf(segmentId));
        if (!fs.exists(segmentFinishDir)) {
            fs.mkdirs(segmentFinishDir);
            FSDataOutputStream outputStream = fs.create(segmentFinishFile, FileSystem.WriteMode.OVERWRITE);
            ((OutputStream)outputStream).close();
            return;
        }
        FileStatus[] files = fs.listStatus(segmentFinishDir);
        if (files.length == 0) {
            FSDataOutputStream outputStream = fs.create(segmentFinishFile, FileSystem.WriteMode.OVERWRITE);
            ((OutputStream)outputStream).close();
        } else {
            Preconditions.checkState(files.length == 1, "Wong number of segment-finish files.");
            fs.rename(files[0].getPath(), segmentFinishFile);
        }
    }

    public static void deletePathQuietly(String toDelete) {
        try {
            Path toRemovePath = new Path(toDelete);
            FileSystem fs = toRemovePath.getFileSystem();
            if (fs.exists(toRemovePath)) {
                fs.delete(toRemovePath, true);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to delete files for {} ", (Object)toDelete, (Object)e);
        }
    }
}

