/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.flink.runtime.executiongraph.VertexGroupComputeUtil;
import org.apache.flink.runtime.topology.Result;
import org.apache.flink.runtime.topology.Vertex;

public final class PipelinedRegionComputeUtil {
    static <V extends Vertex<?, ?, V, R>, R extends Result<?, ?, V, R>> Map<V, Set<V>> buildRawRegions(Iterable<? extends V> topologicallySortedVertices, Function<V, Iterable<R>> getMustBePipelinedConsumedResults) {
        IdentityHashMap vertexToRegion = new IdentityHashMap();
        for (Vertex vertex : topologicallySortedVertices) {
            Set currentRegion = new HashSet<Vertex>();
            currentRegion.add(vertex);
            vertexToRegion.put(vertex, currentRegion);
            for (Result consumedResult : getMustBePipelinedConsumedResults.apply(vertex)) {
                Object producerVertex = consumedResult.getProducer();
                Set producerRegion = (Set)vertexToRegion.get(producerVertex);
                if (producerRegion == null) {
                    throw new IllegalStateException("Producer task " + String.valueOf(producerVertex.getId()) + " failover region is null while calculating failover region for the consumer task " + String.valueOf(vertex.getId()) + ". This should be a failover region building bug.");
                }
                if (currentRegion == producerRegion) continue;
                currentRegion = VertexGroupComputeUtil.mergeVertexGroups(currentRegion, producerRegion, vertexToRegion);
            }
        }
        return vertexToRegion;
    }

    private PipelinedRegionComputeUtil() {
    }
}

