/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.util.Preconditions;

public class CheckpointMetrics
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long UNSET = -1L;
    private final long bytesProcessedDuringAlignment;
    private final long bytesPersistedDuringAlignment;
    private final long alignmentDurationNanos;
    private final long syncDurationMillis;
    private final long asyncDurationMillis;
    private final long checkpointStartDelayNanos;
    private final boolean unalignedCheckpoint;
    private final long bytesPersistedOfThisCheckpoint;
    private final long totalBytesPersisted;

    @VisibleForTesting
    public CheckpointMetrics() {
        this(-1L, -1L, -1L, -1L, -1L, -1L, false, 0L, 0L);
    }

    public CheckpointMetrics(long bytesProcessedDuringAlignment, long bytesPersistedDuringAlignment, long alignmentDurationNanos, long syncDurationMillis, long asyncDurationMillis, long checkpointStartDelayNanos, boolean unalignedCheckpoint, long bytesPersistedOfThisCheckpoint, long totalBytesPersisted) {
        Preconditions.checkArgument(bytesProcessedDuringAlignment >= -1L);
        Preconditions.checkArgument(bytesPersistedDuringAlignment >= -1L);
        Preconditions.checkArgument(syncDurationMillis >= -1L);
        Preconditions.checkArgument(asyncDurationMillis >= -1L);
        Preconditions.checkArgument(alignmentDurationNanos >= -1L);
        Preconditions.checkArgument(checkpointStartDelayNanos >= -1L);
        Preconditions.checkArgument(bytesPersistedOfThisCheckpoint >= 0L);
        Preconditions.checkArgument(totalBytesPersisted >= 0L);
        this.bytesProcessedDuringAlignment = bytesProcessedDuringAlignment;
        this.bytesPersistedDuringAlignment = bytesPersistedDuringAlignment;
        this.alignmentDurationNanos = alignmentDurationNanos;
        this.syncDurationMillis = syncDurationMillis;
        this.asyncDurationMillis = asyncDurationMillis;
        this.checkpointStartDelayNanos = checkpointStartDelayNanos;
        this.unalignedCheckpoint = unalignedCheckpoint;
        this.bytesPersistedOfThisCheckpoint = bytesPersistedOfThisCheckpoint;
        this.totalBytesPersisted = totalBytesPersisted;
    }

    public long getBytesProcessedDuringAlignment() {
        return this.bytesProcessedDuringAlignment;
    }

    public long getBytesPersistedDuringAlignment() {
        return this.bytesPersistedDuringAlignment;
    }

    public long getAlignmentDurationNanos() {
        return this.alignmentDurationNanos;
    }

    public long getSyncDurationMillis() {
        return this.syncDurationMillis;
    }

    public long getAsyncDurationMillis() {
        return this.asyncDurationMillis;
    }

    public long getCheckpointStartDelayNanos() {
        return this.checkpointStartDelayNanos;
    }

    public boolean getUnalignedCheckpoint() {
        return this.unalignedCheckpoint;
    }

    public long getBytesPersistedOfThisCheckpoint() {
        return this.bytesPersistedOfThisCheckpoint;
    }

    public long getTotalBytesPersisted() {
        return this.totalBytesPersisted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointMetrics that = (CheckpointMetrics)o;
        return this.bytesProcessedDuringAlignment == that.bytesProcessedDuringAlignment && this.bytesPersistedDuringAlignment == that.bytesPersistedDuringAlignment && this.alignmentDurationNanos == that.alignmentDurationNanos && this.syncDurationMillis == that.syncDurationMillis && this.asyncDurationMillis == that.asyncDurationMillis && this.checkpointStartDelayNanos == that.checkpointStartDelayNanos && this.unalignedCheckpoint == that.unalignedCheckpoint && this.bytesPersistedOfThisCheckpoint == that.bytesPersistedOfThisCheckpoint && this.totalBytesPersisted == that.totalBytesPersisted;
    }

    public int hashCode() {
        return Objects.hash(this.bytesProcessedDuringAlignment, this.bytesPersistedDuringAlignment, this.alignmentDurationNanos, this.syncDurationMillis, this.asyncDurationMillis, this.checkpointStartDelayNanos, this.unalignedCheckpoint, this.totalBytesPersisted, this.bytesPersistedOfThisCheckpoint);
    }

    public String toString() {
        return "CheckpointMetrics{bytesProcessedDuringAlignment=" + this.bytesProcessedDuringAlignment + ", bytesPersistedDuringAlignment=" + this.bytesPersistedDuringAlignment + ", alignmentDurationNanos=" + this.alignmentDurationNanos + ", syncDurationMillis=" + this.syncDurationMillis + ", asyncDurationMillis=" + this.asyncDurationMillis + ", checkpointStartDelayNanos=" + this.checkpointStartDelayNanos + ", unalignedCheckpoint=" + this.unalignedCheckpoint + ", bytesPersistedOfThisCheckpoint=" + this.bytesPersistedOfThisCheckpoint + ", totalBytesPersisted=" + this.totalBytesPersisted + "}";
    }
}

