/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.IOException;
import java.util.List;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.core.fs.ICloseableRegistry;
import org.apache.flink.core.fs.IFileSystem;
import org.apache.flink.core.fs.Path;

@Experimental
public interface PathsCopyingFileSystem
extends IFileSystem {
    public void copyFiles(List<CopyRequest> var1, ICloseableRegistry var2) throws IOException;

    @Override
    default public boolean canCopyPaths(Path source, Path destination) throws IOException {
        return true;
    }

    public static interface CopyRequest {
        public Path getSource();

        public Path getDestination();

        public long getSize();

        public static CopyRequest of(final Path source, final Path destination, final long size) {
            return new CopyRequest(){

                @Override
                public Path getSource() {
                    return source;
                }

                @Override
                public Path getDestination() {
                    return destination;
                }

                @Override
                public long getSize() {
                    return size;
                }

                public String toString() {
                    return "CopyRequest{source=" + String.valueOf(source) + ", destination=" + String.valueOf(destination) + "}";
                }
            };
        }
    }
}

