/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.guava33.com.google.common.collect.Lists;
import org.apache.flink.util.AbstractAutoCloseableRegistry;
import org.apache.flink.util.IOUtils;

@Internal
@ThreadSafe
public class AutoCloseableRegistry
extends AbstractAutoCloseableRegistry<AutoCloseable, AutoCloseable, Object, Exception> {
    private static final Object DUMMY = new Object();
    private final boolean reverse;

    public AutoCloseableRegistry() {
        this(true);
    }

    public AutoCloseableRegistry(boolean reverse) {
        super(new LinkedHashMap());
        this.reverse = reverse;
    }

    @Override
    protected void doRegister(@Nonnull AutoCloseable closeable, @Nonnull Map<AutoCloseable, Object> closeableMap) {
        closeableMap.put(closeable, DUMMY);
    }

    @Override
    protected boolean doUnRegister(@Nonnull AutoCloseable closeable, @Nonnull Map<AutoCloseable, Object> closeableMap) {
        return closeableMap.remove(closeable) != null;
    }

    @Override
    protected void doClose(List<AutoCloseable> toClose) throws Exception {
        IOUtils.closeAll(this.reverse ? Lists.reverse(toClose) : toClose, Throwable.class);
    }
}

