/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.runtime.FieldSerializer;
import org.apache.flink.api.java.typeutils.runtime.JavaRecordBuilderFactory;
import org.apache.flink.api.java.typeutils.runtime.PojoSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;

@Internal
public final class PojoSerializer<T>
extends TypeSerializer<T> {
    private static final byte IS_NULL = 1;
    private static final byte NO_SUBCLASS = 2;
    private static final byte IS_SUBCLASS = 4;
    private static final byte IS_TAGGED_SUBCLASS = 8;
    private static final long serialVersionUID = 1L;
    private final Class<T> clazz;
    private transient Constructor<T> constructor;
    private transient Field[] fields;
    private final TypeSerializer<Object>[] fieldSerializers;
    private final int numFields;
    private final LinkedHashMap<Class<?>, Integer> registeredClasses;
    private final TypeSerializer<?>[] registeredSerializers;
    private transient Map<String, Class<?>> subclassCache;
    private transient Map<Class<?>, TypeSerializer<?>> subclassSerializerCache;
    private final SerializerConfig serializerConfig;
    private transient ClassLoader cl;
    @Nullable
    private transient JavaRecordBuilderFactory<T> recordFactory;

    public PojoSerializer(Class<T> clazz, TypeSerializer<?>[] fieldSerializers, Field[] fields, SerializerConfig serializerConfig) {
        this.clazz = Preconditions.checkNotNull(clazz);
        this.fieldSerializers = Preconditions.checkNotNull(fieldSerializers);
        this.fields = Preconditions.checkNotNull(fields);
        this.numFields = fieldSerializers.length;
        this.serializerConfig = Preconditions.checkNotNull(serializerConfig);
        for (int i = 0; i < this.numFields; ++i) {
            this.fields[i].setAccessible(true);
        }
        this.cl = Thread.currentThread().getContextClassLoader();
        LinkedHashSet<Class<?>> registeredSubclasses = PojoSerializer.getRegisteredSubclassesFromSerializerConfig(clazz, serializerConfig);
        this.registeredClasses = PojoSerializer.createRegisteredSubclassTags(registeredSubclasses);
        this.registeredSerializers = PojoSerializer.createRegisteredSubclassSerializers(registeredSubclasses, serializerConfig);
        this.subclassCache = new HashMap();
        this.subclassSerializerCache = new HashMap();
        if (TypeExtractor.isRecord(clazz)) {
            this.recordFactory = JavaRecordBuilderFactory.create(clazz, fields);
        }
    }

    PojoSerializer(Class<T> clazz, Field[] fields, TypeSerializer<Object>[] fieldSerializers, LinkedHashMap<Class<?>, Integer> registeredClasses, TypeSerializer<?>[] registeredSerializers, Map<Class<?>, TypeSerializer<?>> subclassSerializerCache, SerializerConfig serializerConfig) {
        this.clazz = Preconditions.checkNotNull(clazz);
        this.fields = Preconditions.checkNotNull(fields);
        this.numFields = fields.length;
        this.fieldSerializers = Preconditions.checkNotNull(fieldSerializers);
        this.registeredClasses = Preconditions.checkNotNull(registeredClasses);
        this.registeredSerializers = Preconditions.checkNotNull(registeredSerializers);
        this.subclassCache = new HashMap();
        this.subclassSerializerCache = Preconditions.checkNotNull(subclassSerializerCache);
        this.serializerConfig = Preconditions.checkNotNull(serializerConfig);
        this.cl = Thread.currentThread().getContextClassLoader();
        if (TypeExtractor.isRecord(clazz)) {
            this.recordFactory = JavaRecordBuilderFactory.create(clazz, fields);
        }
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    private boolean isRecord() {
        return this.recordFactory != null;
    }

    @Override
    public PojoSerializer<T> duplicate() {
        TypeSerializer<Object>[] duplicateFieldSerializers = this.duplicateSerializers(this.fieldSerializers);
        TypeSerializer<Object>[] duplicateRegisteredSerializers = this.duplicateSerializers(this.registeredSerializers);
        return new PojoSerializer<T>(this.clazz, this.fields, duplicateFieldSerializers, new LinkedHashMap(this.registeredClasses), duplicateRegisteredSerializers, this.subclassSerializerCache.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((TypeSerializer)e.getValue()).duplicate())), this.serializerConfig);
    }

    private TypeSerializer<Object>[] duplicateSerializers(TypeSerializer<?>[] serializers) {
        boolean stateful = false;
        TypeSerializer[] duplicateSerializers = new TypeSerializer[serializers.length];
        for (int i = 0; i < serializers.length; ++i) {
            duplicateSerializers[i] = serializers[i].duplicate();
            if (duplicateSerializers[i] == serializers[i]) continue;
            stateful = true;
        }
        if (!stateful) {
            duplicateSerializers = serializers;
        }
        return duplicateSerializers;
    }

    @Override
    public T createInstance() {
        if (this.clazz.isInterface() || Modifier.isAbstract(this.clazz.getModifiers()) || this.isRecord()) {
            return null;
        }
        try {
            T t = this.instantiateRaw();
            this.initializeFields(t);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate class.", e);
        }
    }

    private T instantiateRaw() {
        try {
            if (this.constructor == null) {
                this.constructor = this.clazz.getDeclaredConstructor(new Class[0]);
                this.constructor.setAccessible(true);
            }
            return this.constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate class.", e);
        }
    }

    protected void initializeFields(T t) {
        for (int i = 0; i < this.numFields; ++i) {
            if (this.fields[i] == null) continue;
            try {
                this.fields[i].set(t, this.fieldSerializers[i].createInstance());
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Cannot initialize fields.", e);
            }
        }
    }

    @Override
    public T copy(T from) {
        if (from == null) {
            return null;
        }
        Class<?> actualType = from.getClass();
        if (this.isRecord()) {
            try {
                JavaRecordBuilderFactory.JavaRecordBuilder builder = this.recordFactory.newBuilder();
                for (int i = 0; i < this.numFields; ++i) {
                    if (this.fields[i] == null) continue;
                    builder.setField(i, this.copyField(i, from));
                }
                return builder.build();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error during POJO copy, this should not happen since we check the fields before.");
            }
        }
        if (actualType == this.clazz) {
            T target;
            try {
                target = this.instantiateRaw();
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot instantiate class.", t);
            }
            try {
                for (int i = 0; i < this.numFields; ++i) {
                    if (this.fields[i] == null) continue;
                    this.fields[i].set(target, this.copyField(i, from));
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error during POJO copy, this should not happen since we check the fields before.");
            }
            return target;
        }
        TypeSerializer<?> subclassSerializer = this.getSubclassSerializer(actualType);
        return (T)subclassSerializer.copy(from);
    }

    @Override
    public T copy(T from, T reuse) {
        if (from == null) {
            return null;
        }
        Class<?> actualType = from.getClass();
        if (reuse == null || actualType != reuse.getClass()) {
            return this.copy(from);
        }
        if (this.isRecord()) {
            try {
                JavaRecordBuilderFactory.JavaRecordBuilder builder = this.recordFactory.newBuilder();
                for (int i = 0; i < this.numFields; ++i) {
                    if (this.fields[i] == null) continue;
                    builder.setField(i, this.copyField(reuse, i, from));
                }
                return builder.build();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error during POJO copy, this should not happen since we check the fields before.");
            }
        }
        if (actualType == this.clazz) {
            try {
                for (int i = 0; i < this.numFields; ++i) {
                    if (this.fields[i] == null) continue;
                    this.fields[i].set(reuse, this.copyField(reuse, i, from));
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error during POJO copy, this should not happen since we check the fields before.", e);
            }
        } else {
            TypeSerializer<?> subclassSerializer = this.getSubclassSerializer(actualType);
            reuse = subclassSerializer.copy(from, reuse);
        }
        return reuse;
    }

    private Object copyField(int i, Object from) throws IllegalAccessException {
        Object value = this.fields[i].get(from);
        if (value != null) {
            return this.fieldSerializers[i].copy(value);
        }
        return null;
    }

    private Object copyField(T reuse, int i, Object from) throws IllegalAccessException {
        Object value = this.fields[i].get(from);
        if (value != null) {
            Object reuseValue = this.fields[i].get(reuse);
            if (reuseValue != null) {
                return this.fieldSerializers[i].copy(value, reuseValue);
            }
            return this.fieldSerializers[i].copy(value);
        }
        return null;
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(T value, DataOutputView target) throws IOException {
        int flags = 0;
        if (value == null) {
            target.writeByte(flags |= 1);
            return;
        }
        Integer subclassTag = -1;
        Class<?> actualClass = value.getClass();
        TypeSerializer<?> subclassSerializer = null;
        if (this.clazz != actualClass) {
            subclassTag = this.registeredClasses.get(actualClass);
            if (subclassTag != null) {
                flags |= 8;
                subclassSerializer = this.registeredSerializers[subclassTag];
            } else {
                flags |= 4;
                subclassSerializer = this.getSubclassSerializer(actualClass);
            }
        } else {
            flags |= 2;
        }
        target.writeByte(flags);
        if ((flags & 4) != 0) {
            target.writeUTF(actualClass.getName());
        } else if ((flags & 8) != 0) {
            target.writeByte(subclassTag);
        }
        if ((flags & 2) != 0) {
            try {
                for (int i = 0; i < this.numFields; ++i) {
                    Object o;
                    Object object = o = this.fields[i] != null ? this.fields[i].get(value) : null;
                    if (o == null) {
                        target.writeBoolean(true);
                        continue;
                    }
                    target.writeBoolean(false);
                    this.fieldSerializers[i].serialize(o, target);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error during POJO copy, this should not happen since we check the fields before.", e);
            }
        } else if (subclassSerializer != null) {
            subclassSerializer.serialize(value, target);
        }
    }

    @Override
    public T deserialize(DataInputView source) throws IOException {
        Object target;
        byte flags = source.readByte();
        if ((flags & 1) != 0) {
            return null;
        }
        Class<?> actualSubclass = null;
        TypeSerializer<?> subclassSerializer = null;
        if ((flags & 4) != 0) {
            String subclassName = source.readUTF();
            actualSubclass = this.getSubclassByName(subclassName);
            subclassSerializer = this.getSubclassSerializer(actualSubclass);
            target = subclassSerializer.createInstance();
            this.initializeFields(target);
        } else if ((flags & 8) != 0) {
            byte subclassTag = source.readByte();
            subclassSerializer = this.registeredSerializers[subclassTag];
            target = subclassSerializer.createInstance();
            this.initializeFields(target);
        } else {
            target = this.createInstance();
        }
        if (this.isRecord()) {
            JavaRecordBuilderFactory.JavaRecordBuilder builder = this.recordFactory.newBuilder();
            for (int i = 0; i < this.numFields; ++i) {
                Object fieldValue;
                boolean isNull = source.readBoolean();
                Object object = fieldValue = isNull ? null : this.fieldSerializers[i].deserialize(source);
                if (this.fields[i] == null) continue;
                builder.setField(i, fieldValue);
            }
            target = builder.build();
        } else if ((flags & 2) != 0) {
            try {
                for (int i = 0; i < this.numFields; ++i) {
                    Object fieldValue;
                    boolean isNull = source.readBoolean();
                    Object object = fieldValue = isNull ? null : this.fieldSerializers[i].deserialize(source);
                    if (this.fields[i] == null) continue;
                    this.fields[i].set(target, fieldValue);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error during POJO copy, this should not happen since we check the fields before.", e);
            }
        } else if (subclassSerializer != null) {
            target = subclassSerializer.deserialize(target, source);
        }
        return target;
    }

    @Override
    public T deserialize(T reuse, DataInputView source) throws IOException {
        byte flags = source.readByte();
        if ((flags & 1) != 0) {
            return null;
        }
        Class<?> subclass = null;
        TypeSerializer<?> subclassSerializer = null;
        if ((flags & 4) != 0) {
            String subclassName = source.readUTF();
            subclass = this.getSubclassByName(subclassName);
            subclassSerializer = this.getSubclassSerializer(subclass);
            if (reuse == null || subclass != reuse.getClass()) {
                reuse = subclassSerializer.createInstance();
                this.initializeFields(reuse);
            }
        } else if ((flags & 8) != 0) {
            byte subclassTag = source.readByte();
            subclassSerializer = this.registeredSerializers[subclassTag];
            if (reuse == null || ((PojoSerializer)subclassSerializer).clazz != reuse.getClass()) {
                reuse = subclassSerializer.createInstance();
                this.initializeFields(reuse);
            }
        } else if (reuse == null || this.clazz != reuse.getClass()) {
            reuse = this.createInstance();
        }
        if (this.isRecord()) {
            try {
                JavaRecordBuilderFactory.JavaRecordBuilder builder = this.recordFactory.newBuilder();
                for (int i = 0; i < this.numFields; ++i) {
                    boolean isNull = source.readBoolean();
                    if (this.fields[i] != null) {
                        if (isNull) {
                            builder.setField(i, null);
                            continue;
                        }
                        Object reuseField = reuse == null ? null : this.fields[i].get(reuse);
                        builder.setField(i, this.deserializeField(reuseField, i, source));
                        continue;
                    }
                    if (isNull) continue;
                    this.fieldSerializers[i].deserialize(source);
                }
                reuse = builder.build();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error during POJO copy, this should not happen since we check the fields before.", e);
            }
        } else if ((flags & 2) != 0) {
            try {
                for (int i = 0; i < this.numFields; ++i) {
                    boolean isNull = source.readBoolean();
                    if (this.fields[i] != null) {
                        if (isNull) {
                            this.fields[i].set(reuse, null);
                            continue;
                        }
                        this.fields[i].set(reuse, this.deserializeField(this.fields[i].get(reuse), i, source));
                        continue;
                    }
                    if (isNull) continue;
                    this.fieldSerializers[i].deserialize(source);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error during POJO copy, this should not happen since we check the fields before.", e);
            }
        } else if (subclassSerializer != null) {
            reuse = subclassSerializer.deserialize(reuse, source);
        }
        return reuse;
    }

    private Object deserializeField(Object reuseField, int i, DataInputView source) throws IllegalAccessException, IOException {
        if (reuseField != null) {
            return this.fieldSerializers[i].deserialize(reuseField, source);
        }
        return this.fieldSerializers[i].deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        byte flags = source.readByte();
        target.writeByte(flags);
        if ((flags & 1) != 0) {
            return;
        }
        TypeSerializer<?> subclassSerializer = null;
        if ((flags & 4) != 0) {
            String className = source.readUTF();
            target.writeUTF(className);
            Class<?> subclass = this.getSubclassByName(className);
            subclassSerializer = this.getSubclassSerializer(subclass);
        } else if ((flags & 8) != 0) {
            byte subclassTag = source.readByte();
            target.writeByte(subclassTag);
            subclassSerializer = this.registeredSerializers[subclassTag];
        }
        if ((flags & 2) != 0) {
            for (int i = 0; i < this.numFields; ++i) {
                boolean isNull = source.readBoolean();
                target.writeBoolean(isNull);
                if (isNull) continue;
                this.fieldSerializers[i].copy(source, target);
            }
        } else if (subclassSerializer != null) {
            subclassSerializer.copy(source, target);
        }
    }

    @Override
    public int hashCode() {
        return 31 * (31 * Arrays.hashCode(this.fieldSerializers) + Arrays.hashCode(this.registeredSerializers)) + Objects.hash(this.clazz, this.numFields, this.registeredClasses);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PojoSerializer) {
            PojoSerializer other = (PojoSerializer)obj;
            return this.clazz == other.clazz && Arrays.equals(this.fieldSerializers, other.fieldSerializers) && Arrays.equals(this.registeredSerializers, other.registeredSerializers) && this.numFields == other.numFields && this.registeredClasses.equals(other.registeredClasses);
        }
        return false;
    }

    @Override
    public PojoSerializerSnapshot<T> snapshotConfiguration() {
        return PojoSerializer.buildSnapshot(this.clazz, this.registeredClasses, this.registeredSerializers, this.fields, this.fieldSerializers, this.subclassSerializerCache, this.serializerConfig);
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        out.defaultWriteObject();
        out.writeInt(this.fields.length);
        for (Field field : this.fields) {
            FieldSerializer.serializeField(field, out);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int numFields = in.readInt();
        this.fields = new Field[numFields];
        for (int i = 0; i < numFields; ++i) {
            this.fields[i] = FieldSerializer.deserializeField(in);
        }
        this.cl = Thread.currentThread().getContextClassLoader();
        this.subclassCache = new HashMap();
        this.subclassSerializerCache = new HashMap();
        if (TypeExtractor.isRecord(this.clazz)) {
            this.recordFactory = JavaRecordBuilderFactory.create(this.clazz, this.fields);
        }
    }

    Class<T> getPojoClass() {
        return this.clazz;
    }

    Field[] getFields() {
        return this.fields;
    }

    TypeSerializer<?>[] getFieldSerializers() {
        return this.fieldSerializers;
    }

    TypeSerializer<?> getFieldSerializer(Field targetField) {
        int fieldIndex = this.findField(targetField.getName());
        if (fieldIndex == -1) {
            return null;
        }
        return this.fieldSerializers[fieldIndex];
    }

    SerializerConfig getSerializerConfig() {
        return this.serializerConfig;
    }

    LinkedHashMap<Class<?>, Integer> getRegisteredClasses() {
        return this.registeredClasses;
    }

    TypeSerializer<?>[] getRegisteredSerializers() {
        return this.registeredSerializers;
    }

    LinkedHashMap<Class<?>, TypeSerializer<?>> getBundledSubclassSerializerRegistry() {
        LinkedHashMap<Class<?>, TypeSerializer<?>> result = CollectionUtil.newLinkedHashMapWithExpectedSize(this.registeredClasses.size());
        this.registeredClasses.forEach((registeredClass, id) -> result.put((Class<?>)registeredClass, this.registeredSerializers[id]));
        return result;
    }

    Map<Class<?>, TypeSerializer<?>> getSubclassSerializerCache() {
        return this.subclassSerializerCache;
    }

    private static LinkedHashSet<Class<?>> getRegisteredSubclassesFromSerializerConfig(Class<?> basePojoClass, SerializerConfig serializerConfig) {
        LinkedHashSet<Class<?>> subclassesInRegistrationOrder = CollectionUtil.newLinkedHashSetWithExpectedSize(serializerConfig.getRegisteredPojoTypes().size());
        for (Class clazz : serializerConfig.getRegisteredPojoTypes()) {
            if (clazz.equals(basePojoClass) || !basePojoClass.isAssignableFrom(clazz)) continue;
            subclassesInRegistrationOrder.add(clazz);
        }
        return subclassesInRegistrationOrder;
    }

    private static LinkedHashMap<Class<?>, Integer> createRegisteredSubclassTags(LinkedHashSet<Class<?>> registeredSubclasses) {
        LinkedHashMap classToTag = new LinkedHashMap();
        int id = 0;
        for (Class clazz : registeredSubclasses) {
            classToTag.put(clazz, id);
            ++id;
        }
        return classToTag;
    }

    private static TypeSerializer<?>[] createRegisteredSubclassSerializers(LinkedHashSet<Class<?>> registeredSubclasses, SerializerConfig serializerConfig) {
        TypeSerializer[] subclassSerializers = new TypeSerializer[registeredSubclasses.size()];
        int i = 0;
        for (Class clazz : registeredSubclasses) {
            subclassSerializers[i] = TypeExtractor.createTypeInfo(clazz).createSerializer(serializerConfig);
            ++i;
        }
        return subclassSerializers;
    }

    private Class<?> getSubclassByName(String subclassName) {
        Class<?> subclass = this.subclassCache.get(subclassName);
        if (subclass == null) {
            try {
                subclass = Class.forName(subclassName, true, this.cl);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Cannot instantiate class.", e);
            }
            this.subclassCache.put(subclassName, subclass);
        }
        return subclass;
    }

    TypeSerializer<?> getSubclassSerializer(Class<?> subclass) {
        TypeSerializer<?> result = this.subclassSerializerCache.get(subclass);
        if (result == null) {
            result = this.createSubclassSerializer(subclass);
            this.subclassSerializerCache.put(subclass, result);
        }
        return result;
    }

    private TypeSerializer<?> createSubclassSerializer(Class<?> subclass) {
        TypeSerializer<?> serializer = TypeExtractor.createTypeInfo(subclass).createSerializer(this.serializerConfig);
        if (serializer instanceof PojoSerializer) {
            PojoSerializer subclassSerializer = (PojoSerializer)serializer;
            subclassSerializer.copyBaseFieldOrder(this);
        }
        return serializer;
    }

    private int findField(String fieldName) {
        int foundIndex = 0;
        for (Field field : this.fields) {
            if (field != null && fieldName.equals(field.getName())) {
                return foundIndex;
            }
            ++foundIndex;
        }
        return -1;
    }

    private void copyBaseFieldOrder(PojoSerializer<?> baseSerializer) {
    }

    private static <T> PojoSerializerSnapshot<T> buildSnapshot(Class<T> pojoType, LinkedHashMap<Class<?>, Integer> registeredSubclassesToTags, TypeSerializer<?>[] registeredSubclassSerializers, Field[] fields, TypeSerializer<?>[] fieldSerializers, Map<Class<?>, TypeSerializer<?>> nonRegisteredSubclassSerializerCache, SerializerConfig serializerConfig) {
        LinkedHashMap<Class<?>, TypeSerializer<?>> subclassRegistry = CollectionUtil.newLinkedHashMapWithExpectedSize(registeredSubclassesToTags.size());
        for (Map.Entry<Class<?>, Integer> entry : registeredSubclassesToTags.entrySet()) {
            subclassRegistry.put(entry.getKey(), registeredSubclassSerializers[entry.getValue()]);
        }
        return new PojoSerializerSnapshot<T>(pojoType, fields, fieldSerializers, subclassRegistry, nonRegisteredSubclassSerializerCache, serializerConfig);
    }
}

