/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.connector.source.util.ratelimit;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.api.connector.source.util.ratelimit.RateLimiter;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;

@Internal
public class GuavaRateLimiter<Split extends SourceSplit>
implements RateLimiter<Split> {
    private final Executor limiter = Executors.newSingleThreadExecutor(new ExecutorThreadFactory("flink-rate-limiter"));
    private final org.apache.flink.shaded.guava33.com.google.common.util.concurrent.RateLimiter rateLimiter;

    public GuavaRateLimiter(double maxPerSecond) {
        this.rateLimiter = org.apache.flink.shaded.guava33.com.google.common.util.concurrent.RateLimiter.create(maxPerSecond);
    }

    @Override
    public CompletionStage<Void> acquire(int numberOfEvents) {
        return CompletableFuture.runAsync(() -> this.rateLimiter.acquire(numberOfEvents), this.limiter);
    }
}

