/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.legacy.utils.TypeStringUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;

@Internal
public final class LegacyTypeInformationType<T>
extends LogicalType {
    private static final long serialVersionUID = 1L;
    private static final String FORMAT = "LEGACY('%s', '%s')";
    private final TypeInformation<T> typeInfo;

    public LegacyTypeInformationType(LogicalTypeRoot logicalTypeRoot, TypeInformation<T> typeInfo) {
        super(true, logicalTypeRoot);
        this.typeInfo = Preconditions.checkNotNull(typeInfo, "Type information must not be null.");
    }

    public TypeInformation<T> getTypeInformation() {
        return this.typeInfo;
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new LegacyTypeInformationType<T>(this.getTypeRoot(), this.typeInfo);
    }

    @Override
    public String asSerializableString() {
        return this.withNullability(FORMAT, new Object[]{this.getTypeRoot(), EncodingUtils.escapeSingleQuotes(TypeStringUtils.writeTypeInfo(this.typeInfo))});
    }

    @Override
    public String asSummaryString() {
        return this.asSerializableString();
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        return this.typeInfo.getTypeClass().isAssignableFrom(clazz) || clazz == LogicalTypeUtils.toInternalConversionClass(this);
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        return clazz.isAssignableFrom(this.typeInfo.getTypeClass()) || clazz == LogicalTypeUtils.toInternalConversionClass(this);
    }

    @Override
    public Class<?> getDefaultConversion() {
        return this.typeInfo.getTypeClass();
    }

    @Override
    public List<LogicalType> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LegacyTypeInformationType that = (LegacyTypeInformationType)o;
        return this.typeInfo.equals(that.typeInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.typeInfo);
    }
}

