/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.annotation.StateHint;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.inference.StateTypeStrategy;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.util.TimeUtils;

@Internal
interface FunctionResultTemplate {
    public static FunctionOutputTemplate ofOutput(DataType dataType) {
        return new FunctionOutputTemplate(dataType);
    }

    public static FunctionStateTemplate ofState(LinkedHashMap<String, FunctionStateTemplate.StateInfoTemplate> state) {
        return new FunctionStateTemplate(state);
    }

    @Internal
    public static class FunctionStateTemplate
    implements FunctionResultTemplate {
        private final LinkedHashMap<String, StateInfoTemplate> stateInfos;

        private FunctionStateTemplate(LinkedHashMap<String, StateInfoTemplate> stateInfos) {
            this.stateInfos = stateInfos;
        }

        List<Class<?>> toClassList() {
            return this.stateInfos.values().stream().map(info -> info.dataType).map(DataType::getConversionClass).collect(Collectors.toList());
        }

        LinkedHashMap<String, StateTypeStrategy> toStateTypeStrategies() {
            return this.stateInfos.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> FunctionStateTemplate.createStateTypeStrategy((StateInfoTemplate)e.getValue()), (o, n) -> o, LinkedHashMap::new));
        }

        String toAccumulatorStateName() {
            this.checkSingleStateEntry();
            return this.stateInfos.keySet().iterator().next();
        }

        TypeStrategy toAccumulatorTypeStrategy() {
            this.checkSingleStateEntry();
            StateInfoTemplate stateInfo = this.stateInfos.values().iterator().next();
            return FunctionStateTemplate.createTypeStrategy(stateInfo.dataType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FunctionStateTemplate that = (FunctionStateTemplate)o;
            return Objects.equals(this.stateInfos, that.stateInfos);
        }

        public int hashCode() {
            return Objects.hash(this.stateInfos);
        }

        private void checkSingleStateEntry() {
            if (this.stateInfos.size() != 1) {
                throw ExtractionUtils.extractionError("Aggregating functions support only one state entry.", new Object[0]);
            }
        }

        private static StateTypeStrategy createStateTypeStrategy(StateInfoTemplate stateInfo) {
            return StateTypeStrategy.of(TypeStrategies.explicit(stateInfo.dataType), stateInfo.ttl);
        }

        private static TypeStrategy createTypeStrategy(DataType dataType) {
            return TypeStrategies.explicit(dataType);
        }

        @Nullable
        private static Duration createStateTimeToLive(@Nullable StateHint stateHint) {
            if (stateHint == null) {
                return null;
            }
            String ttl = stateHint.ttl();
            try {
                if (ttl.isEmpty()) {
                    return null;
                }
                return TimeUtils.parseDuration(ttl);
            }
            catch (Exception e) {
                throw ExtractionUtils.extractionError("Invalid TTL duration: %s", ttl);
            }
        }

        @Internal
        static class StateInfoTemplate {
            final DataType dataType;
            @Nullable
            final Duration ttl;

            private StateInfoTemplate(DataType dataType, @Nullable Duration ttl) {
                this.dataType = dataType;
                this.ttl = ttl;
            }

            static StateInfoTemplate of(DataType dataType, @Nullable StateHint stateHint) {
                if (stateHint != null) {
                    ExtractionUtils.checkStateDataType(dataType);
                }
                return new StateInfoTemplate(dataType, FunctionStateTemplate.createStateTimeToLive(stateHint));
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                StateInfoTemplate that = (StateInfoTemplate)o;
                return Objects.equals(this.dataType, that.dataType) && Objects.equals(this.ttl, that.ttl);
            }

            public int hashCode() {
                return Objects.hash(this.dataType, this.ttl);
            }
        }
    }

    @Internal
    public static class FunctionOutputTemplate
    implements FunctionResultTemplate {
        private final DataType dataType;

        private FunctionOutputTemplate(DataType dataType) {
            this.dataType = dataType;
        }

        TypeStrategy toTypeStrategy() {
            return TypeStrategies.explicit(this.dataType);
        }

        Class<?> toClass() {
            return this.dataType.getConversionClass();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FunctionOutputTemplate template = (FunctionOutputTemplate)o;
            return Objects.equals(this.dataType, template.dataType);
        }

        public int hashCode() {
            return Objects.hash(this.dataType);
        }
    }
}

