/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.api.internal.TableResultUtils;
import org.apache.flink.table.catalog.CatalogDescriptor;
import org.apache.flink.table.catalog.CommonCatalogOptions;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.types.DataType;

@Internal
public class DescribeCatalogOperation
implements Operation,
ExecutableOperation {
    private final String catalogName;
    private final boolean isExtended;

    public DescribeCatalogOperation(String catalogName, boolean isExtended) {
        this.catalogName = catalogName;
        this.isExtended = isExtended;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("identifier", this.catalogName);
        params.put("isExtended", this.isExtended);
        return OperationUtils.formatWithChildren("DESCRIBE CATALOG", params, Collections.emptyList(), Operation::asSummaryString);
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        CatalogDescriptor catalogDescriptor = ctx.getCatalogManager().getCatalogDescriptor(this.catalogName).orElseThrow(() -> new ValidationException(String.format("Cannot obtain metadata information from Catalog %s.", this.catalogName)));
        Map<String, String> properties = catalogDescriptor.getConfiguration().toMap();
        ArrayList<List> rows = new ArrayList<List>(Arrays.asList(Arrays.asList("name", this.catalogName), Arrays.asList("type", properties.getOrDefault(CommonCatalogOptions.CATALOG_TYPE.key(), "")), Arrays.asList("comment", catalogDescriptor.getComment().orElse(null))));
        if (this.isExtended) {
            properties.entrySet().stream().filter(entry -> !CommonCatalogOptions.CATALOG_TYPE.key().equals(entry.getKey())).sorted(Map.Entry.comparingByKey()).forEach(entry -> rows.add(Arrays.asList(String.format("option:%s", entry.getKey()), entry.getValue())));
        }
        return TableResultUtils.buildTableResult(new String[]{"info name", "info value"}, new DataType[]{DataTypes.STRING(), DataTypes.STRING()}, (Object[][])rows.stream().map(List::toArray).toArray(x$0 -> new Object[x$0][]));
    }
}

