/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.handler.session;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.table.gateway.api.SqlGatewayService;
import org.apache.flink.table.gateway.api.session.SessionEnvironment;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.rest.handler.AbstractSqlGatewayRestHandler;
import org.apache.flink.table.gateway.rest.message.session.OpenSessionRequestBody;
import org.apache.flink.table.gateway.rest.message.session.OpenSessionResponseBody;
import org.apache.flink.table.gateway.rest.util.SqlGatewayRestAPIVersion;

public class OpenSessionHandler
extends AbstractSqlGatewayRestHandler<OpenSessionRequestBody, OpenSessionResponseBody, EmptyMessageParameters> {
    public OpenSessionHandler(SqlGatewayService service, Map<String, String> responseHeaders, MessageHeaders<OpenSessionRequestBody, OpenSessionResponseBody, EmptyMessageParameters> messageHeaders) {
        super(service, responseHeaders, messageHeaders);
    }

    @Override
    protected CompletableFuture<OpenSessionResponseBody> handleRequest(SqlGatewayRestAPIVersion version, @Nonnull HandlerRequest<OpenSessionRequestBody> request) {
        String sessionName = request.getRequestBody().getSessionName();
        Map<String, String> properties = request.getRequestBody().getProperties();
        SessionHandle sessionHandle = this.service.openSession(SessionEnvironment.newBuilder().setSessionEndpointVersion(version).setSessionName(sessionName).addSessionConfig(properties).build());
        return CompletableFuture.completedFuture(new OpenSessionResponseBody(sessionHandle.getIdentifier().toString()));
    }
}

