/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.WorkflowSchedulerFactory;
import org.apache.flink.table.workflow.WorkflowScheduler;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class WorkflowSchedulerFactoryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowSchedulerFactoryUtil.class);
    public static final String WORKFLOW_SCHEDULER_PREFIX = "workflow-scheduler";

    private WorkflowSchedulerFactoryUtil() {
    }

    @Nullable
    public static WorkflowScheduler<?> createWorkflowScheduler(Configuration configuration, ClassLoader classLoader) {
        String identifier = configuration.get(FactoryUtil.WORKFLOW_SCHEDULER_TYPE);
        if (StringUtils.isNullOrWhitespaceOnly(identifier)) {
            LOG.warn("Workflow scheduler options do not contain an option key '{}' for discovering an workflow scheduler.", (Object)FactoryUtil.WORKFLOW_SCHEDULER_TYPE.key());
            return null;
        }
        try {
            WorkflowSchedulerFactory factory = FactoryUtil.discoverFactory(classLoader, WorkflowSchedulerFactory.class, identifier);
            return factory.createWorkflowScheduler(new DefaultWorkflowSchedulerContext(configuration, WorkflowSchedulerFactoryUtil.getWorkflowSchedulerConfig(configuration, identifier)));
        }
        catch (Throwable t) {
            throw new ValidationException(String.format("Error creating workflow scheduler '%s' in option space '%s'.", identifier, configuration.toMap().entrySet().stream().map(optionEntry -> FactoryUtil.stringifyOption((String)optionEntry.getKey(), (String)optionEntry.getValue())).sorted().collect(Collectors.joining("\n"))), t);
        }
    }

    private static Map<String, String> getWorkflowSchedulerConfig(Configuration flinkConf, String identifier) {
        return new DelegatingConfiguration(flinkConf, WorkflowSchedulerFactoryUtil.getWorkflowSchedulerOptionPrefix(identifier)).toMap();
    }

    private static String getWorkflowSchedulerOptionPrefix(String identifier) {
        return String.format("%s.%s.", WORKFLOW_SCHEDULER_PREFIX, identifier);
    }

    public static WorkflowSchedulerFactoryHelper createWorkflowSchedulerFactoryHelper(WorkflowSchedulerFactory workflowSchedulerFactory, WorkflowSchedulerFactory.Context context) {
        return new WorkflowSchedulerFactoryHelper(workflowSchedulerFactory, context.getWorkflowSchedulerOptions());
    }

    @Internal
    public static class DefaultWorkflowSchedulerContext
    implements WorkflowSchedulerFactory.Context {
        private final ReadableConfig configuration;
        private final Map<String, String> workflowSchedulerConfig;

        public DefaultWorkflowSchedulerContext(ReadableConfig configuration, Map<String, String> workflowSchedulerConfig) {
            this.configuration = configuration;
            this.workflowSchedulerConfig = workflowSchedulerConfig;
        }

        @Override
        public ReadableConfig getConfiguration() {
            return this.configuration;
        }

        @Override
        public Map<String, String> getWorkflowSchedulerOptions() {
            return this.workflowSchedulerConfig;
        }
    }

    @PublicEvolving
    public static class WorkflowSchedulerFactoryHelper
    extends FactoryUtil.FactoryHelper<WorkflowSchedulerFactory> {
        public WorkflowSchedulerFactoryHelper(WorkflowSchedulerFactory workflowSchedulerFactory, Map<String, String> configOptions) {
            super(workflowSchedulerFactory, configOptions, FactoryUtil.PROPERTY_VERSION);
        }
    }
}

