/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli.parser;

import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.sql.parser.impl.FlinkSqlParserImplConstants;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.client.cli.parser.SqlClientParserState;
import org.apache.flink.table.client.cli.parser.SyntaxHighlightStyle;
import org.apache.flink.table.client.config.SqlClientOptions;
import org.apache.flink.table.client.gateway.Executor;
import org.jline.reader.LineReader;
import org.jline.reader.impl.DefaultHighlighter;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlClientSyntaxHighlighter
extends DefaultHighlighter {
    private static final Logger LOG = LoggerFactory.getLogger(SqlClientSyntaxHighlighter.class);
    private static final Set<String> KEYWORDS = Collections.unmodifiableSet(Arrays.stream(FlinkSqlParserImplConstants.tokenImage).map(t -> t.replaceAll("\"", "")).collect(Collectors.toSet()));
    private final Executor executor;

    public SqlClientSyntaxHighlighter(Executor executor) {
        this.executor = executor;
    }

    @Override
    public AttributedString highlight(LineReader reader, String buffer) {
        ReadableConfig configuration = this.executor.getSessionConfig();
        SyntaxHighlightStyle.BuiltInStyle style = SyntaxHighlightStyle.BuiltInStyle.fromString(configuration.get(SqlClientOptions.DISPLAY_DEFAULT_COLOR_SCHEMA));
        if (style == SyntaxHighlightStyle.BuiltInStyle.DEFAULT) {
            return super.highlight(reader, buffer);
        }
        String dialectName = configuration.get(TableConfigOptions.TABLE_SQL_DIALECT);
        SqlDialect dialect = SqlDialect.HIVE.name().equalsIgnoreCase(dialectName) ? SqlDialect.HIVE : SqlDialect.DEFAULT;
        return SqlClientSyntaxHighlighter.getHighlightedOutput(buffer, style.getHighlightStyle(), dialect);
    }

    static AttributedString getHighlightedOutput(String buffer, SyntaxHighlightStyle style, SqlDialect dialect) {
        AttributedStringBuilder highlightedOutput = new AttributedStringBuilder();
        SqlClientParserState prevParseState = SqlClientParserState.DEFAULT;
        SqlClientParserState currentParseState = SqlClientParserState.DEFAULT;
        StringBuilder word = new StringBuilder();
        for (int i = 0; i < buffer.length(); ++i) {
            char currentChar = buffer.charAt(i);
            if (prevParseState == SqlClientParserState.DEFAULT) {
                currentParseState = SqlClientParserState.computeStateAt(buffer, i, dialect);
                if (currentParseState == SqlClientParserState.DEFAULT) {
                    if (SqlClientSyntaxHighlighter.isPartOfWord(currentChar)) {
                        word.append(currentChar);
                    } else {
                        SqlClientSyntaxHighlighter.handleWord(word, highlightedOutput, currentParseState, style);
                        highlightedOutput.append(currentChar);
                        word.setLength(0);
                    }
                } else {
                    SqlClientSyntaxHighlighter.handleWord(word, highlightedOutput, SqlClientParserState.DEFAULT, style);
                    currentParseState.getStyleSetter().accept(highlightedOutput, style);
                    highlightedOutput.append(currentParseState.getStart());
                    i += currentParseState.getStart().length() - 1;
                }
            } else if (currentParseState.isEndMarkerOfState(buffer, i)) {
                highlightedOutput.append(word).append(currentParseState.getEnd()).style(style.getDefaultStyle());
                word.setLength(0);
                i += currentParseState.getEnd().length() - 1;
                currentParseState = SqlClientParserState.DEFAULT;
            } else {
                word.append(currentChar);
            }
            prevParseState = currentParseState;
        }
        SqlClientSyntaxHighlighter.handleWord(word, highlightedOutput, currentParseState, style);
        return highlightedOutput.toAttributedString();
    }

    private static boolean isPartOfWord(char c) {
        return Character.isLetterOrDigit(c) || c == '_' || c == '$';
    }

    private static void handleWord(StringBuilder word, AttributedStringBuilder highlightedOutput, SqlClientParserState currentState, SyntaxHighlightStyle style) {
        String wordStr = word.toString();
        if (currentState == SqlClientParserState.DEFAULT) {
            if (KEYWORDS.contains(wordStr.toUpperCase(Locale.ROOT))) {
                highlightedOutput.style(style.getKeywordStyle());
            } else {
                highlightedOutput.style(style.getDefaultStyle());
            }
        }
        highlightedOutput.append(wordStr).style(style.getDefaultStyle());
        word.setLength(0);
    }
}

