/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.source;

import java.time.Duration;
import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.eventtime.TimestampAssigner;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.connector.source.ReaderOutput;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.streaming.api.operators.source.NoOpTimestampsAndWatermarks;
import org.apache.flink.streaming.api.operators.source.ProgressiveTimestampsAndWatermarks;
import org.apache.flink.streaming.api.operators.source.TimestampsAndWatermarksContext;
import org.apache.flink.streaming.runtime.io.PushingAsyncDataInput;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.RelativeClock;

@Internal
public interface TimestampsAndWatermarks<T> {
    public ReaderOutput<T> createMainOutput(PushingAsyncDataInput.DataOutput<T> var1, WatermarkUpdateListener var2);

    public void startPeriodicWatermarkEmits();

    public void stopPeriodicWatermarkEmits();

    public void emitImmediateWatermark(long var1);

    public void pauseOrResumeSplits(Collection<String> var1, Collection<String> var2);

    public static <E> TimestampsAndWatermarks<E> createProgressiveEventTimeLogic(WatermarkStrategy<E> watermarkStrategy, MetricGroup metrics, ProcessingTimeService timeService, long periodicWatermarkIntervalMillis, RelativeClock mainInputActivityClock, Clock clock, TaskIOMetricGroup taskIOMetricGroup) {
        TimestampsAndWatermarksContextProvider contextProvider = new TimestampsAndWatermarksContextProvider(metrics);
        TimestampAssigner<E> timestampAssigner = watermarkStrategy.createTimestampAssigner(contextProvider.create(mainInputActivityClock));
        return new ProgressiveTimestampsAndWatermarks<E>(timestampAssigner, watermarkStrategy, contextProvider, timeService, Duration.ofMillis(periodicWatermarkIntervalMillis), mainInputActivityClock, clock, taskIOMetricGroup);
    }

    public static <E> TimestampsAndWatermarks<E> createNoOpEventTimeLogic(WatermarkStrategy<E> watermarkStrategy, MetricGroup metrics, RelativeClock inputActivityClock) {
        TimestampsAndWatermarksContext context = new TimestampsAndWatermarksContext(metrics, inputActivityClock);
        TimestampAssigner<E> timestampAssigner = watermarkStrategy.createTimestampAssigner(context);
        return new NoOpTimestampsAndWatermarks<E>(timestampAssigner);
    }

    @Internal
    public static class TimestampsAndWatermarksContextProvider {
        private final MetricGroup metrics;

        public TimestampsAndWatermarksContextProvider(MetricGroup metrics) {
            this.metrics = metrics;
        }

        public TimestampsAndWatermarksContext create(RelativeClock inputActivityClock) {
            return new TimestampsAndWatermarksContext(this.metrics, inputActivityClock);
        }
    }

    @Internal
    public static interface WatermarkUpdateListener {
        public void updateIdle(boolean var1);

        public void updateCurrentEffectiveWatermark(long var1);

        public void updateCurrentSplitWatermark(String var1, long var2);

        public void updateCurrentSplitIdle(String var1, boolean var2);

        public void splitFinished(String var1);
    }
}

