/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamGraphHasher;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.util.StringUtils;

public class StreamGraphUserHashHasher
implements StreamGraphHasher {
    @Override
    public Map<Integer, byte[]> traverseStreamGraphAndGenerateHashes(StreamGraph streamGraph) {
        HashMap<Integer, byte[]> hashResult = new HashMap<Integer, byte[]>();
        for (StreamNode streamNode : streamGraph.getStreamNodes()) {
            this.generateHashesByStreamNodeId(streamNode.getId(), streamGraph, hashResult);
        }
        return hashResult;
    }

    @Override
    public boolean generateHashesByStreamNodeId(int streamNodeId, StreamGraph streamGraph, Map<Integer, byte[]> hashes) {
        StreamNode streamNode = streamGraph.getStreamNode(streamNodeId);
        String userHash = streamNode.getUserHash();
        if (null != userHash) {
            hashes.put(streamNode.getId(), StringUtils.hexStringToByte(userHash));
        }
        return true;
    }
}

