/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple10;
import org.apache.flink.api.java.tuple.Tuple11;
import org.apache.flink.api.java.tuple.Tuple12;
import org.apache.flink.api.java.tuple.Tuple13;
import org.apache.flink.api.java.tuple.Tuple14;
import org.apache.flink.api.java.tuple.Tuple15;
import org.apache.flink.api.java.tuple.Tuple16;
import org.apache.flink.api.java.tuple.Tuple17;
import org.apache.flink.api.java.tuple.Tuple18;
import org.apache.flink.api.java.tuple.Tuple19;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple20;
import org.apache.flink.api.java.tuple.Tuple21;
import org.apache.flink.api.java.tuple.Tuple22;
import org.apache.flink.api.java.tuple.Tuple23;
import org.apache.flink.api.java.tuple.Tuple24;
import org.apache.flink.api.java.tuple.Tuple25;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.tuple.Tuple6;
import org.apache.flink.api.java.tuple.Tuple7;
import org.apache.flink.api.java.tuple.Tuple8;
import org.apache.flink.api.java.tuple.Tuple9;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamProject;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class StreamProjection<IN> {
    private DataStream<IN> dataStream;
    private int[] fieldIndexes;

    protected StreamProjection(DataStream<IN> dataStream, int[] fieldIndexes) {
        if (!dataStream.getType().isTupleType()) {
            throw new RuntimeException("Only Tuple DataStreams can be projected");
        }
        if (fieldIndexes.length == 0) {
            throw new IllegalArgumentException("project() needs to select at least one (1) field.");
        }
        if (fieldIndexes.length > 24) {
            throw new IllegalArgumentException("project() may select only up to (24) fields.");
        }
        int maxFieldIndex = dataStream.getType().getArity();
        for (int i = 0; i < fieldIndexes.length; ++i) {
            Preconditions.checkElementIndex(fieldIndexes[i], maxFieldIndex);
        }
        this.dataStream = dataStream;
        this.fieldIndexes = fieldIndexes;
    }

    public <OUT extends Tuple> SingleOutputStreamOperator<OUT> projectTupleX() {
        SingleOutputStreamOperator<Tuple> projOperator = null;
        switch (this.fieldIndexes.length) {
            case 1: {
                projOperator = this.projectTuple1();
                break;
            }
            case 2: {
                projOperator = this.projectTuple2();
                break;
            }
            case 3: {
                projOperator = this.projectTuple3();
                break;
            }
            case 4: {
                projOperator = this.projectTuple4();
                break;
            }
            case 5: {
                projOperator = this.projectTuple5();
                break;
            }
            case 6: {
                projOperator = this.projectTuple6();
                break;
            }
            case 7: {
                projOperator = this.projectTuple7();
                break;
            }
            case 8: {
                projOperator = this.projectTuple8();
                break;
            }
            case 9: {
                projOperator = this.projectTuple9();
                break;
            }
            case 10: {
                projOperator = this.projectTuple10();
                break;
            }
            case 11: {
                projOperator = this.projectTuple11();
                break;
            }
            case 12: {
                projOperator = this.projectTuple12();
                break;
            }
            case 13: {
                projOperator = this.projectTuple13();
                break;
            }
            case 14: {
                projOperator = this.projectTuple14();
                break;
            }
            case 15: {
                projOperator = this.projectTuple15();
                break;
            }
            case 16: {
                projOperator = this.projectTuple16();
                break;
            }
            case 17: {
                projOperator = this.projectTuple17();
                break;
            }
            case 18: {
                projOperator = this.projectTuple18();
                break;
            }
            case 19: {
                projOperator = this.projectTuple19();
                break;
            }
            case 20: {
                projOperator = this.projectTuple20();
                break;
            }
            case 21: {
                projOperator = this.projectTuple21();
                break;
            }
            case 22: {
                projOperator = this.projectTuple22();
                break;
            }
            case 23: {
                projOperator = this.projectTuple23();
                break;
            }
            case 24: {
                projOperator = this.projectTuple24();
                break;
            }
            case 25: {
                projOperator = this.projectTuple25();
                break;
            }
            default: {
                throw new IllegalStateException("Excessive arity in tuple.");
            }
        }
        return projOperator;
    }

    public <T0> SingleOutputStreamOperator<Tuple1<T0>> projectTuple1() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public <T0, T1> SingleOutputStreamOperator<Tuple2<T0, T1>> projectTuple2() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public <T0, T1, T2> SingleOutputStreamOperator<Tuple3<T0, T1, T2>> projectTuple3() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public <T0, T1, T2, T3> SingleOutputStreamOperator<Tuple4<T0, T1, T2, T3>> projectTuple4() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public <T0, T1, T2, T3, T4> SingleOutputStreamOperator<Tuple5<T0, T1, T2, T3, T4>> projectTuple5() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public <T0, T1, T2, T3, T4, T5> SingleOutputStreamOperator<Tuple6<T0, T1, T2, T3, T4, T5>> projectTuple6() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public <T0, T1, T2, T3, T4, T5, T6> SingleOutputStreamOperator<Tuple7<T0, T1, T2, T3, T4, T5, T6>> projectTuple7() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7> SingleOutputStreamOperator<Tuple8<T0, T1, T2, T3, T4, T5, T6, T7>> projectTuple8() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8> SingleOutputStreamOperator<Tuple9<T0, T1, T2, T3, T4, T5, T6, T7, T8>> projectTuple9() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9> SingleOutputStreamOperator<Tuple10<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9>> projectTuple10() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> SingleOutputStreamOperator<Tuple11<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>> projectTuple11() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> SingleOutputStreamOperator<Tuple12<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>> projectTuple12() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> SingleOutputStreamOperator<Tuple13<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>> projectTuple13() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> SingleOutputStreamOperator<Tuple14<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>> projectTuple14() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> SingleOutputStreamOperator<Tuple15<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>> projectTuple15() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> SingleOutputStreamOperator<Tuple16<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>> projectTuple16() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> SingleOutputStreamOperator<Tuple17<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>> projectTuple17() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17> SingleOutputStreamOperator<Tuple18<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17>> projectTuple18() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18> SingleOutputStreamOperator<Tuple19<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18>> projectTuple19() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19> SingleOutputStreamOperator<Tuple20<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19>> projectTuple20() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20> SingleOutputStreamOperator<Tuple21<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20>> projectTuple21() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21> SingleOutputStreamOperator<Tuple22<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21>> projectTuple22() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22> SingleOutputStreamOperator<Tuple23<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22>> projectTuple23() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23> SingleOutputStreamOperator<Tuple24<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23>> projectTuple24() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24> SingleOutputStreamOperator<Tuple25<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24>> projectTuple25() {
        TypeInformation<IN>[] fTypes = StreamProjection.extractFieldTypes(this.fieldIndexes, this.dataStream.getType());
        TupleTypeInfo tType = new TupleTypeInfo(fTypes);
        return this.dataStream.transform("Projection", tType, new StreamProject(this.fieldIndexes, tType.createSerializer(this.dataStream.getExecutionConfig().getSerializerConfig())));
    }

    public static TypeInformation<?>[] extractFieldTypes(int[] fields, TypeInformation<?> inType) {
        TupleTypeInfo inTupleType = (TupleTypeInfo)inType;
        TypeInformation[] fieldTypes = new TypeInformation[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldTypes[i] = inTupleType.getTypeAt(fields[i]);
        }
        return fieldTypes;
    }
}

