/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.throughput;

import org.apache.flink.util.Preconditions;

public class BufferSizeEMA {
    private final int maxBufferSize;
    private final int minBufferSize;
    private final double alpha;
    private double lastBufferSize;

    public BufferSizeEMA(int maxBufferSize, int minBufferSize, long numberOfSamples) {
        this(maxBufferSize, maxBufferSize, minBufferSize, numberOfSamples);
    }

    public BufferSizeEMA(int startingBufferSize, int maxBufferSize, int minBufferSize, long numberOfSamples) {
        this.maxBufferSize = maxBufferSize;
        this.minBufferSize = minBufferSize;
        this.alpha = 2.0 / (double)(numberOfSamples + 1L);
        this.lastBufferSize = startingBufferSize;
    }

    public int calculateBufferSize(long totalBufferSizeInBytes, int totalBuffers) {
        Preconditions.checkArgument(totalBufferSizeInBytes >= 0L, "Size of buffer should be non negative");
        Preconditions.checkArgument(totalBuffers > 0, "Number of buffers should be positive");
        double desirableBufferSize = Math.min((double)totalBufferSizeInBytes / (double)totalBuffers, 2.0 * this.lastBufferSize);
        this.lastBufferSize += this.alpha * (desirableBufferSize - this.lastBufferSize);
        this.lastBufferSize = Math.max((double)this.minBufferSize, Math.min(this.lastBufferSize, (double)this.maxBufferSize));
        return (int)Math.round(this.lastBufferSize);
    }
}

