/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2.adaptor;

import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.api.common.state.v2.StateIterator;
import org.apache.flink.core.state.StateFutureUtils;
import org.apache.flink.runtime.state.v2.adaptor.CompleteStateIterator;
import org.apache.flink.runtime.state.v2.adaptor.StateAdaptor;
import org.apache.flink.runtime.state.v2.internal.InternalMapState;

public class MapStateAdaptor<K, N, UK, UV>
extends StateAdaptor<K, N, org.apache.flink.runtime.state.internal.InternalMapState<K, N, UK, UV>>
implements InternalMapState<K, N, UK, UV> {
    public MapStateAdaptor(org.apache.flink.runtime.state.internal.InternalMapState<K, N, UK, UV> mapState) {
        super(mapState);
    }

    @Override
    public StateFuture<UV> asyncGet(UK key) {
        try {
            return StateFutureUtils.completedFuture(((org.apache.flink.runtime.state.internal.InternalMapState)this.delegatedState).get(key));
        }
        catch (Exception e) {
            throw new RuntimeException("Error while get value from raw MapState", e);
        }
    }

    @Override
    public UV get(UK key) {
        try {
            return ((org.apache.flink.runtime.state.internal.InternalMapState)this.delegatedState).get(key);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while get value from raw MapState", e);
        }
    }

    @Override
    public StateFuture<Void> asyncPut(UK key, UV value) {
        try {
            ((org.apache.flink.runtime.state.internal.InternalMapState)this.delegatedState).put(key, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while updating value to raw MapState", e);
        }
        return StateFutureUtils.completedVoidFuture();
    }

    @Override
    public void put(UK key, UV value) {
        try {
            ((org.apache.flink.runtime.state.internal.InternalMapState)this.delegatedState).put(key, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while updating value to raw MapState", e);
        }
    }

    @Override
    public StateFuture<Void> asyncPutAll(Map<UK, UV> map) {
        try {
            ((org.apache.flink.runtime.state.internal.InternalMapState)this.delegatedState).putAll(map);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while updating values to raw MapState", e);
        }
        return StateFutureUtils.completedVoidFuture();
    }

    @Override
    public void putAll(Map<UK, UV> map) {
        try {
            ((org.apache.flink.runtime.state.internal.InternalMapState)this.delegatedState).putAll(map);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while updating values to raw MapState", e);
        }
    }

    @Override
    public StateFuture<Void> asyncRemove(UK key) {
        try {
            ((org.apache.flink.runtime.state.internal.InternalMapState)this.delegatedState).remove(key);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while updating values to raw MapState", e);
        }
        return StateFutureUtils.completedVoidFuture();
    }

    @Override
    public void remove(UK key) {
        try {
            ((org.apache.flink.runtime.state.internal.InternalMapState)this.delegatedState).remove(key);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while updating values to raw MapState", e);
        }
    }

    @Override
    public StateFuture<Boolean> asyncContains(UK key) {
        try {
            return StateFutureUtils.completedFuture(((org.apache.flink.runtime.state.internal.InternalMapState)this.delegatedState).contains(key));
        }
        catch (Exception e) {
            throw new RuntimeException("Error while checking key from raw MapState", e);
        }
    }

    @Override
    public boolean contains(UK key) {
        try {
            return ((org.apache.flink.runtime.state.internal.InternalMapState)this.delegatedState).contains(key);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while checking key from raw MapState", e);
        }
    }

    @Override
    public StateFuture<StateIterator<Map.Entry<UK, UV>>> asyncEntries() {
        try {
            return StateFutureUtils.completedFuture(new CompleteStateIterator(((org.apache.flink.runtime.state.internal.InternalMapState)this.delegatedState).entries()));
        }
        catch (Exception e) {
            throw new RuntimeException("Error while get entries from raw MapState", e);
        }
    }

    @Override
    public Iterable<Map.Entry<UK, UV>> entries() {
        try {
            return ((org.apache.flink.runtime.state.internal.InternalMapState)this.delegatedState).entries();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while get entries from raw MapState", e);
        }
    }

    @Override
    public StateFuture<StateIterator<UK>> asyncKeys() {
        try {
            return StateFutureUtils.completedFuture(new CompleteStateIterator(((org.apache.flink.runtime.state.internal.InternalMapState)this.delegatedState).keys()));
        }
        catch (Exception e) {
            throw new RuntimeException("Error while get keys from raw MapState", e);
        }
    }

    @Override
    public Iterable<UK> keys() {
        try {
            return ((org.apache.flink.runtime.state.internal.InternalMapState)this.delegatedState).keys();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while get keys from raw MapState", e);
        }
    }

    @Override
    public StateFuture<StateIterator<UV>> asyncValues() {
        try {
            return StateFutureUtils.completedFuture(new CompleteStateIterator(((org.apache.flink.runtime.state.internal.InternalMapState)this.delegatedState).values()));
        }
        catch (Exception e) {
            throw new RuntimeException("Error while get values from raw MapState", e);
        }
    }

    @Override
    public Iterable<UV> values() {
        try {
            return ((org.apache.flink.runtime.state.internal.InternalMapState)this.delegatedState).values();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while get values from raw MapState", e);
        }
    }

    @Override
    public StateFuture<Boolean> asyncIsEmpty() {
        try {
            return StateFutureUtils.completedFuture(((org.apache.flink.runtime.state.internal.InternalMapState)this.delegatedState).isEmpty());
        }
        catch (Exception e) {
            throw new RuntimeException("Error while checking existence from raw MapState", e);
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            return ((org.apache.flink.runtime.state.internal.InternalMapState)this.delegatedState).isEmpty();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while checking existence from raw MapState", e);
        }
    }

    @Override
    public Iterator<Map.Entry<UK, UV>> iterator() {
        try {
            return ((org.apache.flink.runtime.state.internal.InternalMapState)this.delegatedState).iterator();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while get entries from raw MapState", e);
        }
    }
}

