/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.runtime.state.ttl.AbstractTtlDecorator;
import org.apache.flink.runtime.state.ttl.TtlStateContext;
import org.apache.flink.runtime.state.ttl.TtlValue;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.function.SupplierWithException;
import org.apache.flink.util.function.ThrowingConsumer;

abstract class AbstractTtlState<K, N, SV, TTLSV, S extends InternalKvState<K, N, TTLSV>>
extends AbstractTtlDecorator<S>
implements InternalKvState<K, N, SV> {
    private final TypeSerializer<SV> valueSerializer;
    final Runnable accessCallback;

    AbstractTtlState(TtlStateContext<S, SV> ttlStateContext) {
        super((InternalKvState)ttlStateContext.original, ttlStateContext.config, ttlStateContext.timeProvider);
        this.valueSerializer = ttlStateContext.valueSerializer;
        this.accessCallback = ttlStateContext.accessCallback;
    }

    <SE extends Throwable, CE extends Throwable, T> T getWithTtlCheckAndUpdate(SupplierWithException<TtlValue<T>, SE> getter, ThrowingConsumer<TtlValue<T>, CE> updater) throws SE, CE {
        return this.getWithTtlCheckAndUpdate(getter, updater, ((InternalKvState)this.original)::clear);
    }

    @Override
    public TypeSerializer<K> getKeySerializer() {
        return ((InternalKvState)this.original).getKeySerializer();
    }

    @Override
    public TypeSerializer<N> getNamespaceSerializer() {
        return ((InternalKvState)this.original).getNamespaceSerializer();
    }

    @Override
    public TypeSerializer<SV> getValueSerializer() {
        return this.valueSerializer;
    }

    @Override
    public void setCurrentNamespace(N namespace) {
        ((InternalKvState)this.original).setCurrentNamespace(namespace);
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<N> safeNamespaceSerializer, TypeSerializer<SV> safeValueSerializer) {
        throw new FlinkRuntimeException("Queryable state is not currently supported with TTL.");
    }

    @Override
    public void clear() {
        ((InternalKvState)this.original).clear();
        this.accessCallback.run();
    }

    @Nullable
    public abstract TTLSV getUnexpiredOrNull(@Nonnull TTLSV var1);

    @Override
    public InternalKvState.StateIncrementalVisitor<K, N, SV> getStateIncrementalVisitor(int recommendedMaxNumberOfReturnedRecords) {
        throw new UnsupportedOperationException();
    }
}

