/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.v2.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.runtime.state.StateSerializerProvider;
import org.apache.flink.runtime.state.StateSnapshotTransformer;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.runtime.state.v2.RegisteredKeyAndUserKeyValueStateBackendMetaInfo;
import org.apache.flink.runtime.state.v2.RegisteredKeyValueStateBackendMetaInfo;
import org.apache.flink.util.Preconditions;

public class RegisteredStateMetaInfoUtils {
    private RegisteredStateMetaInfoUtils() {
    }

    public static RegisteredKeyValueStateBackendMetaInfo createMetaInfoV2FromV1Snapshot(StateMetaInfoSnapshot stateMeta) {
        StateDescriptor.Type newStateType;
        Preconditions.checkArgument(stateMeta.getBackendStateType().equals((Object)StateMetaInfoSnapshot.BackendStateType.KEY_VALUE));
        TypeSerializerSnapshot<?> oldValueSerializerSnapshot = stateMeta.getTypeSerializerSnapshot(StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER);
        TypeSerializerSnapshot newUserKeySerializerSnapshot = null;
        TypeSerializerSnapshot<Object> newStateSerializerSnapshot = oldValueSerializerSnapshot;
        switch (StateDescriptor.Type.valueOf(stateMeta.getOption(StateMetaInfoSnapshot.CommonOptionsKeys.KEYED_STATE_TYPE))) {
            case VALUE: {
                newStateType = StateDescriptor.Type.VALUE;
                break;
            }
            case REDUCING: {
                newStateType = StateDescriptor.Type.REDUCING;
                break;
            }
            case AGGREGATING: {
                newStateType = StateDescriptor.Type.AGGREGATING;
                break;
            }
            case LIST: {
                newStateType = StateDescriptor.Type.LIST;
                newStateSerializerSnapshot = ((ListSerializer)oldValueSerializerSnapshot.restoreSerializer()).getElementSerializer().snapshotConfiguration();
                break;
            }
            case MAP: {
                newStateType = StateDescriptor.Type.MAP;
                newStateSerializerSnapshot = ((MapSerializer)oldValueSerializerSnapshot.restoreSerializer()).getValueSerializer().snapshotConfiguration();
                newUserKeySerializerSnapshot = ((MapSerializer)oldValueSerializerSnapshot.restoreSerializer()).getKeySerializer().snapshotConfiguration();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported state type to transform from org.apache.flink.runtime.state.RegisteredKeyValueStateBackendMetaInfo to org.apache.flink.runtime.state.v2.RegisteredKeyValueStateBackendMetaInfo");
            }
        }
        if (!newStateType.equals((Object)StateDescriptor.Type.MAP)) {
            return new RegisteredKeyValueStateBackendMetaInfo(stateMeta.getName(), newStateType, StateSerializerProvider.fromPreviousSerializerSnapshot(stateMeta.getTypeSerializerSnapshot(StateMetaInfoSnapshot.CommonSerializerKeys.NAMESPACE_SERIALIZER)), StateSerializerProvider.fromPreviousSerializerSnapshot(newStateSerializerSnapshot), StateSnapshotTransformer.StateSnapshotTransformFactory.noTransform());
        }
        return new RegisteredKeyAndUserKeyValueStateBackendMetaInfo(stateMeta.getName(), newStateType, StateSerializerProvider.fromPreviousSerializerSnapshot(stateMeta.getTypeSerializerSnapshot(StateMetaInfoSnapshot.CommonSerializerKeys.NAMESPACE_SERIALIZER)), StateSerializerProvider.fromPreviousSerializerSnapshot(newStateSerializerSnapshot), StateSerializerProvider.fromPreviousSerializerSnapshot(newUserKeySerializerSnapshot), StateSnapshotTransformer.StateSnapshotTransformFactory.noTransform());
    }

    public static org.apache.flink.runtime.state.RegisteredKeyValueStateBackendMetaInfo createMetaInfoV1FromV2Snapshot(StateMetaInfoSnapshot stateMeta) {
        StateDescriptor.Type newStateType;
        Preconditions.checkArgument(stateMeta.getBackendStateType().equals((Object)StateMetaInfoSnapshot.BackendStateType.KEY_VALUE_V2));
        TypeSerializerSnapshot<?> oldValueSerializerSnapshot = stateMeta.getTypeSerializerSnapshot(StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER);
        TypeSerializerSnapshot<?> oldUserKeySerializerSnapshot = stateMeta.getTypeSerializerSnapshot(StateMetaInfoSnapshot.CommonSerializerKeys.USER_KEY_SERIALIZER);
        TypeSerializerSnapshot<Object> newStateSerializerSnapshot = oldValueSerializerSnapshot;
        switch (StateDescriptor.Type.valueOf(stateMeta.getOption(StateMetaInfoSnapshot.CommonOptionsKeys.KEYED_STATE_TYPE))) {
            case VALUE: {
                newStateType = StateDescriptor.Type.VALUE;
                break;
            }
            case REDUCING: {
                newStateType = StateDescriptor.Type.REDUCING;
                break;
            }
            case AGGREGATING: {
                newStateType = StateDescriptor.Type.AGGREGATING;
                break;
            }
            case LIST: {
                newStateType = StateDescriptor.Type.LIST;
                newStateSerializerSnapshot = new ListSerializer(oldValueSerializerSnapshot.restoreSerializer()).snapshotConfiguration();
                break;
            }
            case MAP: {
                newStateType = StateDescriptor.Type.MAP;
                if (oldUserKeySerializerSnapshot == null) {
                    throw new UnsupportedOperationException("RegisteredKeyAndUserKeyValueStateBackendMetaInfo can not transform to org.apache.flink.runtime.state.RegisteredKeyValueStateBackendMetaInfo since oldUserKeySerializerSnapshot is null");
                }
                newStateSerializerSnapshot = new MapSerializer(oldUserKeySerializerSnapshot.restoreSerializer(), oldValueSerializerSnapshot.restoreSerializer()).snapshotConfiguration();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported state type to transform from org.apache.flink.runtime.state.v2.RegisteredKeyValueStateBackendMetaInfo to org.apache.flink.runtime.state.RegisteredKeyValueStateBackendMetaInfo");
            }
        }
        return new org.apache.flink.runtime.state.RegisteredKeyValueStateBackendMetaInfo(newStateType, stateMeta.getName(), StateSerializerProvider.fromPreviousSerializerSnapshot(stateMeta.getTypeSerializerSnapshot(StateMetaInfoSnapshot.CommonSerializerKeys.NAMESPACE_SERIALIZER)), StateSerializerProvider.fromPreviousSerializerSnapshot(newStateSerializerSnapshot), StateSnapshotTransformer.StateSnapshotTransformFactory.noTransform());
    }
}

