/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.functions.SerializerFactory;
import org.apache.flink.api.common.state.KeyedStateStore;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.state.v2.AggregatingState;
import org.apache.flink.api.common.state.v2.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.v2.ListState;
import org.apache.flink.api.common.state.v2.ListStateDescriptor;
import org.apache.flink.api.common.state.v2.MapStateDescriptor;
import org.apache.flink.api.common.state.v2.ReducingState;
import org.apache.flink.runtime.state.AsyncKeyedStateBackend;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.UserFacingListState;
import org.apache.flink.runtime.state.UserFacingMapState;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.util.Preconditions;

public class DefaultKeyedStateStore
implements KeyedStateStore {
    @Nullable
    protected final KeyedStateBackend<?> keyedStateBackend;
    @Nullable
    protected final AsyncKeyedStateBackend<?> asyncKeyedStateBackend;
    protected final SerializerFactory serializerFactory;
    protected SupportKeyedStateApiSet supportKeyedStateApiSet;

    public DefaultKeyedStateStore(KeyedStateBackend<?> keyedStateBackend, SerializerFactory serializerFactory) {
        this(keyedStateBackend, null, serializerFactory);
    }

    public DefaultKeyedStateStore(AsyncKeyedStateBackend<?> asyncKeyedStateBackend, SerializerFactory serializerFactory) {
        this(null, asyncKeyedStateBackend, serializerFactory);
    }

    public DefaultKeyedStateStore(@Nullable KeyedStateBackend<?> keyedStateBackend, @Nullable AsyncKeyedStateBackend<?> asyncKeyedStateBackend, SerializerFactory serializerFactory) {
        this.keyedStateBackend = keyedStateBackend;
        this.asyncKeyedStateBackend = asyncKeyedStateBackend;
        this.serializerFactory = Preconditions.checkNotNull(serializerFactory);
        if (keyedStateBackend != null) {
            this.supportKeyedStateApiSet = SupportKeyedStateApiSet.STATE_V1;
        } else if (asyncKeyedStateBackend != null) {
            this.supportKeyedStateApiSet = SupportKeyedStateApiSet.STATE_V2;
        } else {
            throw new IllegalArgumentException("The state backend must not be null.");
        }
    }

    @Override
    public <T> ValueState<T> getState(ValueStateDescriptor<T> stateProperties) {
        Objects.requireNonNull(stateProperties, "The state properties must not be null");
        try {
            stateProperties.initializeSerializerUnlessSet(this.serializerFactory);
            return (ValueState)this.getPartitionedState(stateProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting state", e);
        }
    }

    @Override
    public <T> org.apache.flink.api.common.state.ListState<T> getListState(org.apache.flink.api.common.state.ListStateDescriptor<T> stateProperties) {
        Objects.requireNonNull(stateProperties, "The state properties must not be null");
        try {
            stateProperties.initializeSerializerUnlessSet(this.serializerFactory);
            org.apache.flink.api.common.state.ListState originalState = (org.apache.flink.api.common.state.ListState)this.getPartitionedState(stateProperties);
            return new UserFacingListState(originalState);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting state", e);
        }
    }

    @Override
    public <T> org.apache.flink.api.common.state.ReducingState<T> getReducingState(ReducingStateDescriptor<T> stateProperties) {
        Objects.requireNonNull(stateProperties, "The state properties must not be null");
        try {
            stateProperties.initializeSerializerUnlessSet(this.serializerFactory);
            return (org.apache.flink.api.common.state.ReducingState)this.getPartitionedState(stateProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting state", e);
        }
    }

    @Override
    public <IN, ACC, OUT> org.apache.flink.api.common.state.AggregatingState<IN, OUT> getAggregatingState(org.apache.flink.api.common.state.AggregatingStateDescriptor<IN, ACC, OUT> stateProperties) {
        Objects.requireNonNull(stateProperties, "The state properties must not be null");
        try {
            stateProperties.initializeSerializerUnlessSet(this.serializerFactory);
            return (org.apache.flink.api.common.state.AggregatingState)this.getPartitionedState(stateProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting state", e);
        }
    }

    @Override
    public <UK, UV> MapState<UK, UV> getMapState(org.apache.flink.api.common.state.MapStateDescriptor<UK, UV> stateProperties) {
        Objects.requireNonNull(stateProperties, "The state properties must not be null");
        try {
            stateProperties.initializeSerializerUnlessSet(this.serializerFactory);
            MapState originalState = (MapState)this.getPartitionedState(stateProperties);
            return new UserFacingMapState(originalState);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting state", e);
        }
    }

    protected <S extends State> S getPartitionedState(StateDescriptor<S, ?> stateDescriptor) throws Exception {
        Preconditions.checkState(this.keyedStateBackend != null && this.supportKeyedStateApiSet == SupportKeyedStateApiSet.STATE_V1, "Current operator does not integrate the async processing logic, thus only supports state v1 APIs. Please use StateDescriptor under 'org.apache.flink.runtime.state'.");
        return this.keyedStateBackend.getPartitionedState(VoidNamespace.INSTANCE, VoidNamespaceSerializer.INSTANCE, stateDescriptor);
    }

    @Override
    public <T> org.apache.flink.api.common.state.v2.ValueState<T> getValueState(@Nonnull org.apache.flink.api.common.state.v2.ValueStateDescriptor<T> stateProperties) {
        Objects.requireNonNull(stateProperties, "The state properties must not be null");
        try {
            stateProperties.initializeSerializerUnlessSet(this.serializerFactory);
            return (org.apache.flink.api.common.state.v2.ValueState)this.getPartitionedState(stateProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting state", e);
        }
    }

    @Override
    public <T> ListState<T> getListState(@Nonnull ListStateDescriptor<T> stateProperties) {
        Objects.requireNonNull(stateProperties, "The state properties must not be null");
        try {
            stateProperties.initializeSerializerUnlessSet(this.serializerFactory);
            return (ListState)this.getPartitionedState(stateProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting state", e);
        }
    }

    @Override
    public <UK, UV> org.apache.flink.api.common.state.v2.MapState<UK, UV> getMapState(@Nonnull MapStateDescriptor<UK, UV> stateProperties) {
        Objects.requireNonNull(stateProperties, "The state properties must not be null");
        try {
            stateProperties.initializeSerializerUnlessSet(this.serializerFactory);
            return (org.apache.flink.api.common.state.v2.MapState)this.getPartitionedState(stateProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting state", e);
        }
    }

    @Override
    public <T> ReducingState<T> getReducingState(@Nonnull org.apache.flink.api.common.state.v2.ReducingStateDescriptor<T> stateProperties) {
        Objects.requireNonNull(stateProperties, "The state properties must not be null");
        try {
            stateProperties.initializeSerializerUnlessSet(this.serializerFactory);
            return (ReducingState)this.getPartitionedState(stateProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting state", e);
        }
    }

    @Override
    public <IN, ACC, OUT> AggregatingState<IN, OUT> getAggregatingState(@Nonnull AggregatingStateDescriptor<IN, ACC, OUT> stateProperties) {
        Objects.requireNonNull(stateProperties, "The state properties must not be null");
        try {
            stateProperties.initializeSerializerUnlessSet(this.serializerFactory);
            return (AggregatingState)this.getPartitionedState(stateProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting state", e);
        }
    }

    protected <S extends org.apache.flink.api.common.state.v2.State, SV> S getPartitionedState(org.apache.flink.api.common.state.v2.StateDescriptor<SV> stateDescriptor) throws Exception {
        Preconditions.checkState(this.asyncKeyedStateBackend != null && this.supportKeyedStateApiSet == SupportKeyedStateApiSet.STATE_V2, "Current operator integrates the async processing logic, thus only supports state v2 APIs. Please use StateDescriptor under 'org.apache.flink.runtime.state.v2'.");
        return this.asyncKeyedStateBackend.getOrCreateKeyedState(VoidNamespace.INSTANCE, VoidNamespaceSerializer.INSTANCE, stateDescriptor);
    }

    public void setSupportKeyedStateApiSetV2() {
        Objects.requireNonNull(this.asyncKeyedStateBackend, "Current operator integrates the logic of async processing, thus only support state v2 APIs. Please use StateDescriptor under 'org.apache.flink.runtime.state.v2'.");
        this.supportKeyedStateApiSet = SupportKeyedStateApiSet.STATE_V2;
    }

    private static enum SupportKeyedStateApiSet {
        STATE_V1,
        STATE_V2;

    }
}

