/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.shuffle;

import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.shuffle.JobShuffleContext;
import org.apache.flink.runtime.shuffle.PartitionWithMetrics;
import org.apache.flink.util.Preconditions;

public class JobShuffleContextImpl
implements JobShuffleContext {
    private final JobID jobId;
    private final JobMasterGateway jobMasterGateway;

    public JobShuffleContextImpl(JobID jobId, JobMasterGateway jobMasterGateway) {
        this.jobId = Preconditions.checkNotNull(jobId);
        this.jobMasterGateway = Preconditions.checkNotNull(jobMasterGateway);
    }

    @Override
    public JobID getJobId() {
        return this.jobId;
    }

    @Override
    public CompletableFuture<?> stopTrackingAndReleasePartitions(Collection<ResultPartitionID> partitionIds) {
        return this.jobMasterGateway.stopTrackingAndReleasePartitions(partitionIds);
    }

    @Override
    public CompletableFuture<Collection<PartitionWithMetrics>> getPartitionWithMetrics(Duration timeout, Set<ResultPartitionID> expectedPartitions) {
        return this.jobMasterGateway.getPartitionWithMetrics(timeout, expectedPartitions);
    }

    @Override
    public void notifyPartitionRecoveryStarted() {
        this.jobMasterGateway.startFetchAndRetainPartitionWithMetricsOnTaskManager();
    }
}

