/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptivebatch;

import java.util.concurrent.Executor;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.scheduler.adaptivebatch.AdaptiveExecutionHandler;
import org.apache.flink.runtime.scheduler.adaptivebatch.DefaultAdaptiveExecutionHandler;
import org.apache.flink.runtime.scheduler.adaptivebatch.NonAdaptiveExecutionHandler;
import org.apache.flink.streaming.api.graph.ExecutionPlan;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.util.DynamicCodeLoadingException;
import org.apache.flink.util.Preconditions;

public class AdaptiveExecutionHandlerFactory {
    public static AdaptiveExecutionHandler create(ExecutionPlan executionPlan, boolean enableBatchJobRecovery, ClassLoader userClassLoader, Executor serializationExecutor) throws DynamicCodeLoadingException {
        if (executionPlan instanceof JobGraph) {
            return new NonAdaptiveExecutionHandler((JobGraph)executionPlan);
        }
        Preconditions.checkState(executionPlan instanceof StreamGraph, "Unsupported execution plan.");
        if (enableBatchJobRecovery) {
            StreamGraph streamGraph = (StreamGraph)executionPlan;
            return new NonAdaptiveExecutionHandler(streamGraph.getJobGraph(userClassLoader));
        }
        return new DefaultAdaptiveExecutionHandler(userClassLoader, (StreamGraph)executionPlan, serializationExecutor);
    }
}

