/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.ConfigurationInfo;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.job.JobManagerJobConfigurationHeaders;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.Preconditions;

public class JobManagerJobConfigurationHandler
extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, ConfigurationInfo, JobMessageParameters>
implements JsonArchivist {
    private final ConfigurationInfo jobConfig;

    public JobManagerJobConfigurationHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Duration timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, ConfigurationInfo, JobMessageParameters> messageHeaders, Configuration configuration) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders);
        Preconditions.checkNotNull(configuration);
        this.jobConfig = ConfigurationInfo.from(configuration);
    }

    @Override
    protected CompletableFuture<ConfigurationInfo> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        return CompletableFuture.completedFuture(this.jobConfig);
    }

    @Override
    public Collection<ArchivedJson> archiveJsonWithPath(ExecutionGraphInfo executionGraphInfo) throws IOException {
        return Collections.singletonList(new ArchivedJson(JobManagerJobConfigurationHeaders.getInstance().getTargetRestEndpointURL().replace(":jobid", executionGraphInfo.getJobId().toString()), this.jobConfig));
    }
}

