/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.hash;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.typeutils.SameTypePairComparator;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.RandomAccessInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.runtime.operators.hash.AbstractHashTableProber;
import org.apache.flink.runtime.operators.hash.AbstractMutableHashTable;
import org.apache.flink.runtime.operators.hash.InPlaceMutableHashTable;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.MutableObjectIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InPlaceMutableHashTable<T>
extends AbstractMutableHashTable<T> {
    private static final Logger LOG = LoggerFactory.getLogger(InPlaceMutableHashTable.class);
    private static final int MIN_NUM_MEMORY_SEGMENTS = 3;
    private static final long END_OF_LIST = Long.MAX_VALUE;
    private static final long INVALID_PREV_POINTER = 0x7FFFFFFFFFFFFFFEL;
    private static final long RECORD_OFFSET_IN_LINK = 8L;
    private final ArrayList<MemorySegment> freeMemorySegments;
    private final int numAllMemorySegments;
    private final int segmentSize;
    private MemorySegment[] bucketSegments;
    private static final int bucketSize = 8;
    private static final int bucketSizeBits = 3;
    private int numBuckets;
    private int numBucketsMask;
    private final int numBucketsPerSegment;
    private final int numBucketsPerSegmentBits;
    private final int numBucketsPerSegmentMask;
    private final RecordArea recordArea;
    private final ArrayList<MemorySegment> stagingSegments;
    private final RandomAccessInputView stagingSegmentsInView;
    private final StagingOutputView stagingSegmentsOutView;
    private T reuse;
    private final HashTableProber<T> prober;
    private long numElements = 0L;
    private long holes = 0L;
    private boolean enableResize;

    public InPlaceMutableHashTable(TypeSerializer<T> serializer, TypeComparator<T> comparator, List<MemorySegment> memory) {
        super(serializer, comparator);
        this.numAllMemorySegments = memory.size();
        this.freeMemorySegments = new ArrayList<MemorySegment>(memory);
        if (this.freeMemorySegments.size() < 3) {
            throw new IllegalArgumentException("Too few memory segments provided. InPlaceMutableHashTable needs at least 3 memory segments.");
        }
        this.segmentSize = this.freeMemorySegments.get(0).size();
        if ((this.segmentSize & this.segmentSize - 1) != 0) {
            throw new IllegalArgumentException("Hash Table requires buffers whose size is a power of 2.");
        }
        this.numBucketsPerSegment = this.segmentSize / 8;
        this.numBucketsPerSegmentBits = MathUtils.log2strict(this.numBucketsPerSegment);
        this.numBucketsPerSegmentMask = (1 << this.numBucketsPerSegmentBits) - 1;
        this.recordArea = new RecordArea(this.segmentSize);
        this.stagingSegments = new ArrayList();
        this.stagingSegments.add(this.forcedAllocateSegment());
        this.stagingSegmentsInView = new RandomAccessInputView(this.stagingSegments, this.segmentSize);
        this.stagingSegmentsOutView = new StagingOutputView(this.stagingSegments, this.segmentSize);
        this.prober = new HashTableProber(this.buildSideComparator, new SameTypePairComparator(this.buildSideComparator));
        this.enableResize = this.buildSideSerializer.getLength() == -1;
    }

    public long getCapacity() {
        return (long)this.numAllMemorySegments * (long)this.segmentSize;
    }

    public long getOccupancy() {
        return this.numAllMemorySegments * this.segmentSize - this.freeMemorySegments.size() * this.segmentSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open(int numBucketSegments) {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.closed) {
                throw new IllegalStateException("currently not closed.");
            }
            this.closed = false;
        }
        this.allocateBucketSegments(numBucketSegments);
        this.stagingSegments.add(this.forcedAllocateSegment());
        this.reuse = this.buildSideSerializer.createInstance();
    }

    @Override
    public void open() {
        this.open(this.calcInitialNumBucketSegments());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.closed) {
                this.recordArea.giveBackSegments();
                this.freeMemorySegments.addAll(this.stagingSegments);
                this.stagingSegments.clear();
                return;
            }
            this.closed = true;
        }
        LOG.debug("Closing InPlaceMutableHashTable and releasing resources.");
        this.releaseBucketSegments();
        this.recordArea.giveBackSegments();
        this.freeMemorySegments.addAll(this.stagingSegments);
        this.stagingSegments.clear();
        this.numElements = 0L;
        this.holes = 0L;
    }

    @Override
    public void abort() {
        LOG.debug("Aborting InPlaceMutableHashTable.");
        this.close();
    }

    @Override
    public List<MemorySegment> getFreeMemory() {
        if (!this.closed) {
            throw new IllegalStateException("Cannot return memory while InPlaceMutableHashTable is open.");
        }
        return this.freeMemorySegments;
    }

    private int calcInitialNumBucketSegments() {
        int recordLength = this.buildSideSerializer.getLength();
        double fraction = recordLength == -1 ? 0.1 : 8.0 / (double)(16 + recordLength);
        int ret = Math.max(1, MathUtils.roundDownToPowerOf2((int)((double)this.numAllMemorySegments * fraction)));
        if ((long)ret * (long)this.numBucketsPerSegment > Integer.MAX_VALUE) {
            ret = MathUtils.roundDownToPowerOf2(Integer.MAX_VALUE / this.numBucketsPerSegment);
        }
        return ret;
    }

    private void allocateBucketSegments(int numBucketSegments) {
        if (numBucketSegments < 1) {
            throw new RuntimeException("Bug in InPlaceMutableHashTable");
        }
        this.bucketSegments = new MemorySegment[numBucketSegments];
        for (int i = 0; i < this.bucketSegments.length; ++i) {
            this.bucketSegments[i] = this.forcedAllocateSegment();
            for (int j = 0; j < this.numBucketsPerSegment; ++j) {
                this.bucketSegments[i].putLong(j << 3, Long.MAX_VALUE);
            }
        }
        this.numBuckets = numBucketSegments * this.numBucketsPerSegment;
        this.numBucketsMask = (1 << MathUtils.log2strict(this.numBuckets)) - 1;
    }

    private void releaseBucketSegments() {
        this.freeMemorySegments.addAll(Arrays.asList(this.bucketSegments));
        this.bucketSegments = null;
    }

    private MemorySegment allocateSegment() {
        int s = this.freeMemorySegments.size();
        if (s > 0) {
            return this.freeMemorySegments.remove(s - 1);
        }
        return null;
    }

    private MemorySegment forcedAllocateSegment() {
        MemorySegment segment = this.allocateSegment();
        if (segment == null) {
            throw new RuntimeException("Bug in InPlaceMutableHashTable: A free segment should have been available.");
        }
        return segment;
    }

    @Override
    public void insertOrReplaceRecord(T record) throws IOException {
        if (this.closed) {
            return;
        }
        T match = this.prober.getMatchFor(record, this.reuse);
        if (match == null) {
            this.prober.insertAfterNoMatch(record);
        } else {
            this.prober.updateMatch(record);
        }
    }

    @Override
    public void insert(T record) throws IOException {
        if (this.closed) {
            return;
        }
        int hashCode = MathUtils.jenkinsHash(this.buildSideComparator.hash(record));
        int bucket = hashCode & this.numBucketsMask;
        int bucketSegmentIndex = bucket >>> this.numBucketsPerSegmentBits;
        MemorySegment bucketSegment = this.bucketSegments[bucketSegmentIndex];
        int bucketOffset = (bucket & this.numBucketsPerSegmentMask) << 3;
        long firstPointer = bucketSegment.getLong(bucketOffset);
        try {
            long newFirstPointer = this.recordArea.appendPointerAndRecord(firstPointer, record);
            bucketSegment.putLong(bucketOffset, newFirstPointer);
        }
        catch (EOFException ex) {
            this.compactOrThrow();
            this.insert(record);
            return;
        }
        ++this.numElements;
        this.resizeTableIfNecessary();
    }

    private void resizeTableIfNecessary() throws IOException {
        long newNumBucketSegments;
        if (this.enableResize && this.numElements > (long)this.numBuckets && (newNumBucketSegments = 2L * (long)this.bucketSegments.length) * (long)this.numBucketsPerSegment < Integer.MAX_VALUE && newNumBucketSegments - (long)this.bucketSegments.length < (long)this.freeMemorySegments.size() && newNumBucketSegments < (long)(this.numAllMemorySegments / 2)) {
            this.rebuild(newNumBucketSegments);
        }
    }

    public EntryIterator getEntryIterator() {
        return new EntryIterator();
    }

    public <PT> HashTableProber<PT> getProber(TypeComparator<PT> probeTypeComparator, TypePairComparator<PT, T> pairComparator) {
        return new HashTableProber<PT>(probeTypeComparator, pairComparator);
    }

    private void rebuild() throws IOException {
        this.rebuild(this.bucketSegments.length);
    }

    private void rebuild(long newNumBucketSegments) throws IOException {
        this.releaseBucketSegments();
        this.allocateBucketSegments((int)newNumBucketSegments);
        Object record = this.buildSideSerializer.createInstance();
        try {
            EntryIterator iter = this.getEntryIterator();
            this.recordArea.resetAppendPosition();
            this.recordArea.setWritePosition(0L);
            while ((record = iter.next(record)) != null && !this.closed) {
                int hashCode = MathUtils.jenkinsHash(this.buildSideComparator.hash(record));
                int bucket = hashCode & this.numBucketsMask;
                int bucketSegmentIndex = bucket >>> this.numBucketsPerSegmentBits;
                MemorySegment bucketSegment = this.bucketSegments[bucketSegmentIndex];
                int bucketOffset = (bucket & this.numBucketsPerSegmentMask) << 3;
                long firstPointer = bucketSegment.getLong(bucketOffset);
                long ptrToAppended = this.recordArea.noSeekAppendPointerAndRecord(firstPointer, record);
                bucketSegment.putLong(bucketOffset, ptrToAppended);
            }
            this.recordArea.freeSegmentsAfterAppendPosition();
            this.holes = 0L;
        }
        catch (EOFException ex) {
            throw new RuntimeException("Bug in InPlaceMutableHashTable: we shouldn't get out of memory during a rebuild, because we aren't allocating any new memory.");
        }
    }

    private void compactOrThrow() throws IOException {
        if (!((double)this.holes > (double)this.recordArea.getTotalSize() * 0.05)) {
            throw new EOFException("InPlaceMutableHashTable memory ran out. " + this.getMemoryConsumptionString());
        }
        this.rebuild();
    }

    private String getMemoryConsumptionString() {
        return "InPlaceMutableHashTable memory stats:\nTotal memory:     " + this.numAllMemorySegments * this.segmentSize + "\nFree memory:      " + this.freeMemorySegments.size() * this.segmentSize + "\nBucket area:      " + this.numBuckets * 8 + "\nRecord area:      " + this.recordArea.getTotalSize() + "\nStaging area:     " + this.stagingSegments.size() * this.segmentSize + "\nNum of elements:  " + this.numElements + "\nHoles total size: " + this.holes;
    }

    public final class ReduceFacade {
        private final HashTableProber<T> prober;
        private final boolean objectReuseEnabled;
        private final ReduceFunction<T> reducer;
        private final Collector<T> outputCollector;
        private T reuse;

        public ReduceFacade(ReduceFunction<T> reducer, Collector<T> outputCollector, boolean objectReuseEnabled) {
            this.reducer = reducer;
            this.outputCollector = outputCollector;
            this.objectReuseEnabled = objectReuseEnabled;
            this.prober = InPlaceMutableHashTable.this.getProber(InPlaceMutableHashTable.this.buildSideComparator, (TypePairComparator)new SameTypePairComparator(InPlaceMutableHashTable.this.buildSideComparator));
            this.reuse = InPlaceMutableHashTable.this.buildSideSerializer.createInstance();
        }

        public void updateTableEntryWithReduce(T record) throws Exception {
            Object match = this.prober.getMatchFor(record, this.reuse);
            if (match == null) {
                this.prober.insertAfterNoMatch(record);
            } else {
                Object res = this.reducer.reduce(match, record);
                if (!this.objectReuseEnabled) {
                    this.reuse = InPlaceMutableHashTable.this.buildSideSerializer.createInstance();
                }
                this.prober.updateMatch(res);
            }
        }

        public void emit() throws IOException {
            Object record = InPlaceMutableHashTable.this.buildSideSerializer.createInstance();
            EntryIterator iter = InPlaceMutableHashTable.this.getEntryIterator();
            while ((record = iter.next(record)) != null && !InPlaceMutableHashTable.this.closed) {
                this.outputCollector.collect(record);
                if (this.objectReuseEnabled) continue;
                record = InPlaceMutableHashTable.this.buildSideSerializer.createInstance();
            }
        }

        public void emitAndReset() throws IOException {
            int oldNumBucketSegments = InPlaceMutableHashTable.this.bucketSegments.length;
            this.emit();
            InPlaceMutableHashTable.this.close();
            InPlaceMutableHashTable.this.open(oldNumBucketSegments);
        }
    }

    public final class EntryIterator
    implements MutableObjectIterator<T> {
        private final long endPosition;

        public EntryIterator() {
            this.endPosition = InPlaceMutableHashTable.this.recordArea.getAppendPosition();
            if (this.endPosition == 0L) {
                return;
            }
            InPlaceMutableHashTable.this.recordArea.setReadPosition(0L);
        }

        @Override
        public T next(T reuse) throws IOException {
            if (this.endPosition != 0L && InPlaceMutableHashTable.this.recordArea.getReadPosition() < this.endPosition) {
                while (!InPlaceMutableHashTable.this.closed) {
                    boolean isAbandoned;
                    long pointerOrNegatedLength = InPlaceMutableHashTable.this.recordArea.readPointer();
                    boolean bl = isAbandoned = pointerOrNegatedLength < 0L;
                    if (!isAbandoned) {
                        reuse = InPlaceMutableHashTable.this.recordArea.readRecord(reuse);
                        return reuse;
                    }
                    InPlaceMutableHashTable.this.recordArea.skipBytesToRead((int)(-(pointerOrNegatedLength + 1L)));
                }
                return null;
            }
            return null;
        }

        @Override
        public T next() throws IOException {
            return this.next((T)InPlaceMutableHashTable.this.buildSideSerializer.createInstance());
        }
    }

    public final class HashTableProber<PT>
    extends AbstractHashTableProber<PT, T> {
        private int bucketSegmentIndex;
        private int bucketOffset;
        private long curElemPtr;
        private long prevElemPtr;
        private long nextPtr;
        private long recordEnd;

        public HashTableProber(TypeComparator<PT> probeTypeComparator, TypePairComparator<PT, T> pairComparator) {
            super(probeTypeComparator, pairComparator);
        }

        @Override
        public T getMatchFor(PT record, T targetForMatch) {
            if (InPlaceMutableHashTable.this.closed) {
                return null;
            }
            int hashCode = MathUtils.jenkinsHash(this.probeTypeComparator.hash(record));
            int bucket = hashCode & InPlaceMutableHashTable.this.numBucketsMask;
            this.bucketSegmentIndex = bucket >>> InPlaceMutableHashTable.this.numBucketsPerSegmentBits;
            MemorySegment bucketSegment = InPlaceMutableHashTable.this.bucketSegments[this.bucketSegmentIndex];
            this.bucketOffset = (bucket & InPlaceMutableHashTable.this.numBucketsPerSegmentMask) << 3;
            this.curElemPtr = bucketSegment.getLong(this.bucketOffset);
            this.pairComparator.setReference(record);
            Object currentRecordInList = targetForMatch;
            this.prevElemPtr = 0x7FFFFFFFFFFFFFFEL;
            try {
                while (this.curElemPtr != Long.MAX_VALUE && !InPlaceMutableHashTable.this.closed) {
                    InPlaceMutableHashTable.this.recordArea.setReadPosition(this.curElemPtr);
                    this.nextPtr = InPlaceMutableHashTable.this.recordArea.readPointer();
                    currentRecordInList = InPlaceMutableHashTable.this.recordArea.readRecord(currentRecordInList);
                    this.recordEnd = InPlaceMutableHashTable.this.recordArea.getReadPosition();
                    if (this.pairComparator.equalToReference(currentRecordInList)) {
                        return currentRecordInList;
                    }
                    this.prevElemPtr = this.curElemPtr;
                    this.curElemPtr = this.nextPtr;
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Error deserializing record from the hashtable: " + ex.getMessage(), ex);
            }
            return null;
        }

        @Override
        public T getMatchFor(PT probeSideRecord) {
            return this.getMatchFor(probeSideRecord, (T)InPlaceMutableHashTable.this.buildSideSerializer.createInstance());
        }

        @Override
        public void updateMatch(T newRecord) throws IOException {
            if (InPlaceMutableHashTable.this.closed) {
                return;
            }
            if (this.curElemPtr == Long.MAX_VALUE) {
                throw new RuntimeException("updateMatch was called after getMatchFor returned no match");
            }
            try {
                InPlaceMutableHashTable.this.stagingSegmentsOutView.reset();
                InPlaceMutableHashTable.this.buildSideSerializer.serialize(newRecord, InPlaceMutableHashTable.this.stagingSegmentsOutView);
                int newRecordSize = (int)InPlaceMutableHashTable.this.stagingSegmentsOutView.getWritePosition();
                InPlaceMutableHashTable.this.stagingSegmentsInView.setReadPosition(0L);
                int oldRecordSize = (int)(this.recordEnd - (this.curElemPtr + 8L));
                if (newRecordSize == oldRecordSize) {
                    InPlaceMutableHashTable.this.recordArea.overwriteRecordAt(this.curElemPtr + 8L, InPlaceMutableHashTable.this.stagingSegmentsInView, newRecordSize);
                } else {
                    long pointerToAppended = InPlaceMutableHashTable.this.recordArea.appendPointerAndCopyRecord(this.nextPtr, InPlaceMutableHashTable.this.stagingSegmentsInView, newRecordSize);
                    if (this.prevElemPtr == 0x7FFFFFFFFFFFFFFEL) {
                        InPlaceMutableHashTable.this.bucketSegments[this.bucketSegmentIndex].putLong(this.bucketOffset, pointerToAppended);
                    } else {
                        InPlaceMutableHashTable.this.recordArea.overwritePointerAt(this.prevElemPtr, pointerToAppended);
                    }
                    InPlaceMutableHashTable.this.recordArea.overwritePointerAt(this.curElemPtr, -oldRecordSize - 1);
                    InPlaceMutableHashTable.this.holes += (long)oldRecordSize;
                }
            }
            catch (EOFException ex) {
                InPlaceMutableHashTable.this.compactOrThrow();
                InPlaceMutableHashTable.this.insertOrReplaceRecord(newRecord);
            }
        }

        public void insertAfterNoMatch(T record) throws IOException {
            long pointerToAppended;
            if (InPlaceMutableHashTable.this.closed) {
                return;
            }
            try {
                pointerToAppended = InPlaceMutableHashTable.this.recordArea.appendPointerAndRecord(Long.MAX_VALUE, record);
            }
            catch (EOFException ex) {
                InPlaceMutableHashTable.this.compactOrThrow();
                InPlaceMutableHashTable.this.insert(record);
                return;
            }
            if (this.prevElemPtr == 0x7FFFFFFFFFFFFFFEL) {
                InPlaceMutableHashTable.this.bucketSegments[this.bucketSegmentIndex].putLong(this.bucketOffset, pointerToAppended);
            } else {
                InPlaceMutableHashTable.this.recordArea.overwritePointerAt(this.prevElemPtr, pointerToAppended);
            }
            ++InPlaceMutableHashTable.this.numElements;
            InPlaceMutableHashTable.this.resizeTableIfNecessary();
        }
    }

    private final class StagingOutputView
    extends AbstractPagedOutputView {
        private final ArrayList<MemorySegment> segments;
        private final int segmentSizeBits;
        private int currentSegmentIndex;

        public StagingOutputView(ArrayList<MemorySegment> segments, int segmentSize) {
            super(segmentSize, 0);
            this.segmentSizeBits = MathUtils.log2strict(segmentSize);
            this.segments = segments;
        }

        public void reset() {
            this.seekOutput(this.segments.get(0), 0);
            this.currentSegmentIndex = 0;
        }

        @Override
        protected MemorySegment nextSegment(MemorySegment current, int positionInCurrent) throws EOFException {
            ++this.currentSegmentIndex;
            if (this.currentSegmentIndex == this.segments.size()) {
                MemorySegment m = InPlaceMutableHashTable.this.allocateSegment();
                if (m == null) {
                    throw new EOFException();
                }
                this.segments.add(m);
            }
            return this.segments.get(this.currentSegmentIndex);
        }

        public long getWritePosition() {
            return ((long)this.currentSegmentIndex << this.segmentSizeBits) + (long)this.getCurrentPositionInSegment();
        }
    }

    private final class RecordArea {
        private final ArrayList<MemorySegment> segments = new ArrayList();
        private final org.apache.flink.runtime.operators.hash.InPlaceMutableHashTable$RecordArea.RecordAreaOutputView outView;
        private final RandomAccessInputView inView;
        private final int segmentSizeBits;
        private final int segmentSizeMask;
        private long appendPosition = 0L;

        public RecordArea(int segmentSize) {
            int segmentSizeBits = MathUtils.log2strict(segmentSize);
            if ((segmentSize & segmentSize - 1) != 0) {
                throw new IllegalArgumentException("Segment size must be a power of 2!");
            }
            this.segmentSizeBits = segmentSizeBits;
            this.segmentSizeMask = segmentSize - 1;
            this.outView = new RecordAreaOutputView(segmentSize);
            try {
                this.addSegment();
            }
            catch (EOFException ex) {
                throw new RuntimeException("Bug in InPlaceMutableHashTable: we should have caught it earlier that we don't have enough segments.");
            }
            this.inView = new RandomAccessInputView(this.segments, segmentSize);
        }

        private void addSegment() throws EOFException {
            MemorySegment m = InPlaceMutableHashTable.this.allocateSegment();
            if (m == null) {
                throw new EOFException();
            }
            this.segments.add(m);
        }

        public void giveBackSegments() {
            InPlaceMutableHashTable.this.freeMemorySegments.addAll(this.segments);
            this.segments.clear();
            this.resetAppendPosition();
        }

        public long getTotalSize() {
            return (long)this.segments.size() * (long)InPlaceMutableHashTable.this.segmentSize;
        }

        private void setWritePosition(long position) throws EOFException {
            if (position > this.appendPosition) {
                throw new IndexOutOfBoundsException();
            }
            int segmentIndex = (int)(position >>> this.segmentSizeBits);
            int offset = (int)(position & (long)this.segmentSizeMask);
            if (segmentIndex == this.segments.size()) {
                this.addSegment();
            }
            this.outView.currentSegmentIndex = segmentIndex;
            this.outView.seekOutput(this.segments.get(segmentIndex), offset);
        }

        public void resetAppendPosition() {
            this.appendPosition = 0L;
            this.outView.currentSegmentIndex = -1;
            this.outView.seekOutput(null, -1);
        }

        public void freeSegmentsAfterAppendPosition() {
            int appendSegmentIndex = (int)(this.appendPosition >>> this.segmentSizeBits);
            while (this.segments.size() > appendSegmentIndex + 1 && !InPlaceMutableHashTable.this.closed) {
                InPlaceMutableHashTable.this.freeMemorySegments.add(this.segments.get(this.segments.size() - 1));
                this.segments.remove(this.segments.size() - 1);
            }
        }

        public void overwritePointerAt(long pointer, long value) throws IOException {
            this.setWritePosition(pointer);
            this.outView.writeLong(value);
        }

        public void overwriteRecordAt(long pointer, DataInputView input, int size) throws IOException {
            this.setWritePosition(pointer);
            this.outView.write(input, size);
        }

        public long appendPointerAndCopyRecord(long pointer, DataInputView input, int recordSize) throws IOException {
            this.setWritePosition(this.appendPosition);
            long oldLastPosition = this.appendPosition;
            this.outView.writeLong(pointer);
            this.outView.write(input, recordSize);
            this.appendPosition += (long)(8 + recordSize);
            return oldLastPosition;
        }

        public long appendPointerAndRecord(long pointer, T record) throws IOException {
            this.setWritePosition(this.appendPosition);
            return this.noSeekAppendPointerAndRecord(pointer, record);
        }

        public long noSeekAppendPointerAndRecord(long pointer, T record) throws IOException {
            long oldLastPosition = this.appendPosition;
            long oldPositionInSegment = this.outView.getCurrentPositionInSegment();
            long oldSegmentIndex = this.outView.currentSegmentIndex;
            this.outView.writeLong(pointer);
            InPlaceMutableHashTable.this.buildSideSerializer.serialize(record, (DataOutputView)this.outView);
            this.appendPosition += (long)this.outView.getCurrentPositionInSegment() - oldPositionInSegment + (long)this.outView.getSegmentSize() * ((long)this.outView.currentSegmentIndex - oldSegmentIndex);
            return oldLastPosition;
        }

        public long getAppendPosition() {
            return this.appendPosition;
        }

        public void setReadPosition(long position) {
            this.inView.setReadPosition(position);
        }

        public long getReadPosition() {
            return this.inView.getReadPosition();
        }

        public long readPointer() throws IOException {
            return this.inView.readLong();
        }

        public T readRecord(T reuse) throws IOException {
            return InPlaceMutableHashTable.this.buildSideSerializer.deserialize(reuse, this.inView);
        }

        public void skipBytesToRead(int numBytes) throws IOException {
            this.inView.skipBytesToRead(numBytes);
        }

        private final class RecordAreaOutputView
        extends AbstractPagedOutputView {
            public int currentSegmentIndex;

            public RecordAreaOutputView(int segmentSize) {
                super(segmentSize, 0);
            }

            @Override
            protected MemorySegment nextSegment(MemorySegment current, int positionInCurrent) throws EOFException {
                ++this.currentSegmentIndex;
                if (this.currentSegmentIndex == RecordArea.this.segments.size()) {
                    RecordArea.this.addSegment();
                }
                return RecordArea.this.segments.get(this.currentSegmentIndex);
            }

            @Override
            public void seekOutput(MemorySegment seg, int position) {
                super.seekOutput(seg, position);
            }
        }
    }
}

