/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.Collections;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.ComponentMetricGroup;
import org.apache.flink.runtime.metrics.groups.InternalOperatorIOMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.util.Preconditions;

@Internal
public class InternalOperatorMetricGroup
extends ComponentMetricGroup<TaskMetricGroup>
implements OperatorMetricGroup {
    private final String operatorName;
    private final OperatorID operatorID;
    private final InternalOperatorIOMetricGroup ioMetrics;

    InternalOperatorMetricGroup(MetricRegistry registry, TaskMetricGroup parent, OperatorID operatorID, String operatorName) {
        super(registry, registry.getScopeFormats().getOperatorFormat().formatScope(Preconditions.checkNotNull(parent), operatorID, operatorName), parent);
        this.operatorID = operatorID;
        this.operatorName = operatorName;
        this.ioMetrics = new InternalOperatorIOMetricGroup(this);
    }

    public final TaskIOMetricGroup getTaskIOMetricGroup() {
        return ((TaskMetricGroup)this.parent).getIOMetricGroup();
    }

    public final MetricGroup getTaskMetricGroup() {
        return this.parent;
    }

    @Override
    protected QueryScopeInfo.OperatorQueryScopeInfo createQueryServiceMetricInfo(CharacterFilter filter) {
        return new QueryScopeInfo.OperatorQueryScopeInfo(((TaskManagerJobMetricGroup)((TaskMetricGroup)this.parent).parent).jobId.toString(), ((TaskMetricGroup)this.parent).vertexId.toString(), ((TaskMetricGroup)this.parent).subtaskIndex, ((TaskMetricGroup)this.parent).attemptNumber(), filter.filterCharacters(this.operatorName));
    }

    public InternalOperatorIOMetricGroup getIOMetricGroup() {
        return this.ioMetrics;
    }

    @Override
    protected void putVariables(Map<String, String> variables) {
        variables.put(ScopeFormat.SCOPE_OPERATOR_ID, String.valueOf(this.operatorID));
        variables.put(ScopeFormat.SCOPE_OPERATOR_NAME, this.operatorName);
    }

    @Override
    protected Iterable<? extends ComponentMetricGroup<?>> subComponents() {
        return Collections.emptyList();
    }

    @Override
    protected String getGroupName(CharacterFilter filter) {
        return "operator";
    }
}

