/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.slotpool.DefaultLocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.EvenlySpreadOutLocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.FreeSlotTracker;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.CollectionUtil;

public abstract class LocationPreferenceSlotSelectionStrategy
implements SlotSelectionStrategy {
    LocationPreferenceSlotSelectionStrategy() {
    }

    @Override
    public Optional<SlotSelectionStrategy.SlotInfoAndLocality> selectBestSlotForProfile(@Nonnull FreeSlotTracker freeSlotTracker, @Nonnull SlotProfile slotProfile) {
        Collection<TaskManagerLocation> locationPreferences = slotProfile.getPreferredLocations();
        if (freeSlotTracker.getAvailableSlots().isEmpty()) {
            return Optional.empty();
        }
        ResourceProfile resourceProfile = slotProfile.getPhysicalSlotResourceProfile();
        return locationPreferences.isEmpty() ? this.selectWithoutLocationPreference(freeSlotTracker, resourceProfile) : this.selectWithLocationPreference(freeSlotTracker, locationPreferences, resourceProfile);
    }

    @Nonnull
    private Optional<SlotSelectionStrategy.SlotInfoAndLocality> selectWithLocationPreference(@Nonnull FreeSlotTracker freeSlotTracker, @Nonnull Collection<TaskManagerLocation> locationPreferences, @Nonnull ResourceProfile resourceProfile) {
        HashMap<ResourceID, Integer> preferredResourceIDs = CollectionUtil.newHashMapWithExpectedSize(locationPreferences.size());
        HashMap<String, Integer> preferredFQHostNames = CollectionUtil.newHashMapWithExpectedSize(locationPreferences.size());
        for (TaskManagerLocation locationPreference : locationPreferences) {
            preferredResourceIDs.merge(locationPreference.getResourceID(), 1, Integer::sum);
            preferredFQHostNames.merge(locationPreference.getFQDNHostname(), 1, Integer::sum);
        }
        SlotInfo bestCandidate = null;
        Locality bestCandidateLocality = Locality.UNKNOWN;
        double bestCandidateScore = Double.NEGATIVE_INFINITY;
        for (AllocationID allocationId : freeSlotTracker.getAvailableSlots()) {
            int hostLocalWeigh;
            int localWeigh;
            double candidateScore;
            SlotInfo candidate = freeSlotTracker.getSlotInfo(allocationId);
            if (!candidate.getResourceProfile().isMatching(resourceProfile) || !((candidateScore = this.calculateCandidateScore(localWeigh = preferredResourceIDs.getOrDefault(candidate.getTaskManagerLocation().getResourceID(), 0).intValue(), hostLocalWeigh = preferredFQHostNames.getOrDefault(candidate.getTaskManagerLocation().getFQDNHostname(), 0).intValue(), () -> freeSlotTracker.getTaskExecutorUtilization(candidate))) > bestCandidateScore)) continue;
            bestCandidateScore = candidateScore;
            bestCandidate = candidate;
            bestCandidateLocality = localWeigh > 0 ? Locality.LOCAL : (hostLocalWeigh > 0 ? Locality.HOST_LOCAL : Locality.NON_LOCAL);
        }
        return bestCandidate != null ? Optional.of(SlotSelectionStrategy.SlotInfoAndLocality.of(bestCandidate, bestCandidateLocality)) : Optional.empty();
    }

    @Nonnull
    protected abstract Optional<SlotSelectionStrategy.SlotInfoAndLocality> selectWithoutLocationPreference(@Nonnull FreeSlotTracker var1, @Nonnull ResourceProfile var2);

    protected abstract double calculateCandidateScore(int var1, int var2, Supplier<Double> var3);

    public static LocationPreferenceSlotSelectionStrategy createDefault() {
        return new DefaultLocationPreferenceSlotSelectionStrategy();
    }

    public static LocationPreferenceSlotSelectionStrategy createEvenlySpreadOut() {
        return new EvenlySpreadOutLocationPreferenceSlotSelectionStrategy();
    }
}

