/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.Preconditions;

public class JobVertexResourceRequirements
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FIELD_NAME_PARALLELISM = "parallelism";
    @JsonProperty(value="parallelism")
    private final Parallelism parallelism;

    public JobVertexResourceRequirements(@JsonProperty(value="parallelism") Parallelism parallelism) {
        this.parallelism = Preconditions.checkNotNull(parallelism);
    }

    public Parallelism getParallelism() {
        return this.parallelism;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobVertexResourceRequirements that = (JobVertexResourceRequirements)o;
        return this.parallelism.equals(that.parallelism);
    }

    public int hashCode() {
        return Objects.hash(this.parallelism);
    }

    public String toString() {
        return "JobVertexResourceRequirements{parallelism=" + String.valueOf(this.parallelism) + "}";
    }

    public static class Parallelism
    implements Serializable {
        private static final String FIELD_NAME_LOWER_BOUND = "lowerBound";
        private static final String FIELD_NAME_UPPER_BOUND = "upperBound";
        @JsonProperty(value="lowerBound")
        private final int lowerBound;
        @JsonProperty(value="upperBound")
        private final int upperBound;

        @JsonCreator
        public Parallelism(@JsonProperty(value="lowerBound") int lowerBound, @JsonProperty(value="upperBound") int upperBound) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        public int getLowerBound() {
            return this.lowerBound;
        }

        public int getUpperBound() {
            return this.upperBound;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parallelism that = (Parallelism)o;
            return this.lowerBound == that.lowerBound && this.upperBound == that.upperBound;
        }

        public int hashCode() {
            return Objects.hash(this.lowerBound, this.upperBound);
        }

        public String toString() {
            return "Parallelism{lowerBound=" + this.lowerBound + ", upperBound=" + this.upperBound + "}";
        }
    }
}

