/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.deployment.CachedShuffleDescriptors;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptorFactory;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.adaptivebatch.ExecutionPlanSchedulingContext;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.util.Preconditions;

public class IntermediateResult {
    private final IntermediateDataSet intermediateDataSet;
    private final IntermediateDataSetID id;
    private final ExecutionJobVertex producer;
    private final IntermediateResultPartition[] partitions;
    private final HashMap<IntermediateResultPartitionID, Integer> partitionLookupHelper = new HashMap();
    private final int numParallelProducers;
    private final ExecutionPlanSchedulingContext executionPlanSchedulingContext;
    private final boolean singleSubpartitionContainsAllData;
    private int partitionsAssigned;
    private final int connectionIndex;
    private final ResultPartitionType resultType;
    private final Map<ConsumedPartitionGroup, CachedShuffleDescriptors> shuffleDescriptorCache;

    public IntermediateResult(IntermediateDataSet intermediateDataSet, ExecutionJobVertex producer, int numParallelProducers, ResultPartitionType resultType, ExecutionPlanSchedulingContext executionPlanSchedulingContext) {
        this.intermediateDataSet = Preconditions.checkNotNull(intermediateDataSet);
        this.id = Preconditions.checkNotNull(intermediateDataSet.getId());
        this.producer = Preconditions.checkNotNull(producer);
        Preconditions.checkArgument(numParallelProducers >= 1);
        this.numParallelProducers = numParallelProducers;
        this.partitions = new IntermediateResultPartition[numParallelProducers];
        this.connectionIndex = (int)(Math.random() * 2.147483647E9);
        this.resultType = Preconditions.checkNotNull(resultType);
        this.shuffleDescriptorCache = new HashMap<ConsumedPartitionGroup, CachedShuffleDescriptors>();
        this.executionPlanSchedulingContext = Preconditions.checkNotNull(executionPlanSchedulingContext);
        this.singleSubpartitionContainsAllData = intermediateDataSet.isBroadcast();
    }

    public boolean areAllConsumerVerticesCreated() {
        return this.intermediateDataSet.areAllConsumerVerticesCreated();
    }

    public void setPartition(int partitionNumber, IntermediateResultPartition partition) {
        if (partition == null || partitionNumber < 0 || partitionNumber >= this.numParallelProducers) {
            throw new IllegalArgumentException();
        }
        if (this.partitions[partitionNumber] != null) {
            throw new IllegalStateException("Partition #" + partitionNumber + " has already been assigned.");
        }
        this.partitions[partitionNumber] = partition;
        this.partitionLookupHelper.put(partition.getPartitionId(), partitionNumber);
        ++this.partitionsAssigned;
    }

    public IntermediateDataSetID getId() {
        return this.id;
    }

    public ExecutionJobVertex getProducer() {
        return this.producer;
    }

    public IntermediateResultPartition[] getPartitions() {
        return this.partitions;
    }

    public List<JobVertexID> getConsumerVertices() {
        return this.intermediateDataSet.getConsumers().stream().map(jobEdge -> jobEdge.getTarget().getID()).collect(Collectors.toList());
    }

    public IntermediateResultPartition getPartitionById(IntermediateResultPartitionID resultPartitionId) {
        Integer partitionNumber = this.partitionLookupHelper.get(Preconditions.checkNotNull(resultPartitionId, "IntermediateResultPartitionID"));
        if (partitionNumber != null) {
            return this.partitions[partitionNumber];
        }
        throw new IllegalArgumentException("Unknown intermediate result partition ID " + String.valueOf(resultPartitionId));
    }

    public int getNumberOfAssignedPartitions() {
        return this.partitionsAssigned;
    }

    public ResultPartitionType getResultType() {
        return this.resultType;
    }

    int getNumParallelProducers() {
        return this.numParallelProducers;
    }

    int getConsumersParallelism() {
        return this.executionPlanSchedulingContext.getConsumersParallelism(jobVertexId -> this.producer.getGraph().getJobVertex((JobVertexID)jobVertexId).getParallelism(), this.intermediateDataSet);
    }

    int getConsumersMaxParallelism() {
        return this.executionPlanSchedulingContext.getConsumersMaxParallelism(jobVertexId -> this.producer.getGraph().getJobVertex((JobVertexID)jobVertexId).getMaxParallelism(), this.intermediateDataSet);
    }

    public DistributionPattern getConsumingDistributionPattern() {
        return this.intermediateDataSet.getDistributionPattern();
    }

    public boolean isBroadcast() {
        return this.intermediateDataSet.isBroadcast();
    }

    public boolean isForward() {
        return this.intermediateDataSet.isForward();
    }

    public boolean isSingleSubpartitionContainsAllData() {
        return this.singleSubpartitionContainsAllData;
    }

    public int getConnectionIndex() {
        return this.connectionIndex;
    }

    @VisibleForTesting
    void resetForNewExecution() {
        for (IntermediateResultPartition partition : this.partitions) {
            partition.resetForNewExecution();
        }
    }

    public CachedShuffleDescriptors getCachedShuffleDescriptors(ConsumedPartitionGroup consumedPartitionGroup) {
        return this.shuffleDescriptorCache.get(consumedPartitionGroup);
    }

    public CachedShuffleDescriptors cacheShuffleDescriptors(ConsumedPartitionGroup consumedPartitionGroup, TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[] shuffleDescriptors) {
        CachedShuffleDescriptors cachedShuffleDescriptors = new CachedShuffleDescriptors(consumedPartitionGroup, shuffleDescriptors);
        this.shuffleDescriptorCache.put(consumedPartitionGroup, cachedShuffleDescriptors);
        return cachedShuffleDescriptors;
    }

    public void markPartitionFinished(ConsumedPartitionGroup consumedPartitionGroup, IntermediateResultPartition resultPartition) {
        if (!resultPartition.getResultType().isHybridResultPartition()) {
            return;
        }
        if (this.shuffleDescriptorCache.containsKey(consumedPartitionGroup)) {
            CachedShuffleDescriptors cachedShuffleDescriptors = this.shuffleDescriptorCache.get(consumedPartitionGroup);
            cachedShuffleDescriptors.markPartitionFinished(resultPartition);
        }
    }

    public void clearCachedInformationForPartitionGroup(ConsumedPartitionGroup consumedPartitionGroup) {
        CachedShuffleDescriptors cache = this.shuffleDescriptorCache.remove(consumedPartitionGroup);
        if (cache != null) {
            cache.getAllSerializedShuffleDescriptorGroups().forEach(shuffleDescriptors -> {
                if (shuffleDescriptors instanceof TaskDeploymentDescriptor.Offloaded) {
                    PermanentBlobKey blobKey = ((TaskDeploymentDescriptor.Offloaded)shuffleDescriptors).serializedValueKey;
                    this.producer.getGraph().deleteBlobs(Collections.singletonList(blobKey));
                }
            });
        }
    }

    public String toString() {
        return "IntermediateResult " + this.id.toString();
    }
}

