/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.dispatcher.JobManagerRunnerRegistry;
import org.apache.flink.runtime.jobmaster.JobManagerRunner;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;

public class DefaultJobManagerRunnerRegistry
implements JobManagerRunnerRegistry {
    @VisibleForTesting
    final Map<JobID, JobManagerRunner> jobManagerRunners;

    public DefaultJobManagerRunnerRegistry(int initialCapacity) {
        Preconditions.checkArgument(initialCapacity > 0);
        this.jobManagerRunners = CollectionUtil.newHashMapWithExpectedSize(initialCapacity);
    }

    @Override
    public boolean isRegistered(JobID jobId) {
        return this.jobManagerRunners.containsKey(jobId);
    }

    @Override
    public void register(JobManagerRunner jobManagerRunner) {
        Preconditions.checkArgument(!this.isRegistered(jobManagerRunner.getJobID()), "A job with the ID %s is already registered.", jobManagerRunner.getJobID());
        this.jobManagerRunners.put(jobManagerRunner.getJobID(), jobManagerRunner);
    }

    @Override
    public JobManagerRunner get(JobID jobId) {
        this.assertJobRegistered(jobId);
        return this.jobManagerRunners.get(jobId);
    }

    @Override
    public int size() {
        return this.jobManagerRunners.size();
    }

    @Override
    public Set<JobID> getRunningJobIds() {
        return new HashSet<JobID>(this.jobManagerRunners.keySet());
    }

    @Override
    public Collection<JobManagerRunner> getJobManagerRunners() {
        return new ArrayList<JobManagerRunner>(this.jobManagerRunners.values());
    }

    @Override
    public CompletableFuture<Void> localCleanupAsync(JobID jobId, Executor unusedExecutor) {
        if (this.isRegistered(jobId)) {
            return this.unregister(jobId).closeAsync();
        }
        return FutureUtils.completedVoidFuture();
    }

    @Override
    public JobManagerRunner unregister(JobID jobId) {
        this.assertJobRegistered(jobId);
        return this.jobManagerRunners.remove(jobId);
    }

    private void assertJobRegistered(JobID jobId) {
        if (!this.isRegistered(jobId)) {
            throw new NoSuchElementException("There is no running job registered for the job ID " + String.valueOf(jobId));
        }
    }
}

