/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.flink.runtime.executiongraph.IndexRange;
import org.apache.flink.runtime.executiongraph.IndexRangeUtil;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.util.Preconditions;

class ConsumedSubpartitionContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int numConsumedShuffleDescriptors;
    private final Map<IndexRange, IndexRange> consumedShuffleDescriptorToSubpartitionRangeMap;

    private ConsumedSubpartitionContext(int numConsumedShuffleDescriptors, Map<IndexRange, IndexRange> consumedShuffleDescriptorToSubpartitionRangeMap) {
        this.numConsumedShuffleDescriptors = numConsumedShuffleDescriptors;
        this.consumedShuffleDescriptorToSubpartitionRangeMap = Preconditions.checkNotNull(consumedShuffleDescriptorToSubpartitionRangeMap);
    }

    public int getNumConsumedShuffleDescriptors() {
        return this.numConsumedShuffleDescriptors;
    }

    public Collection<IndexRange> getConsumedShuffleDescriptorRanges() {
        return Collections.unmodifiableCollection(IndexRangeUtil.mergeIndexRanges(this.consumedShuffleDescriptorToSubpartitionRangeMap.keySet()));
    }

    public IndexRange getConsumedSubpartitionRange(int shuffleDescriptorIndex) {
        ArrayList<IndexRange> consumedSubpartitionRanges = new ArrayList<IndexRange>();
        for (Map.Entry<IndexRange, IndexRange> entry : this.consumedShuffleDescriptorToSubpartitionRangeMap.entrySet()) {
            IndexRange shuffleDescriptorRange = entry.getKey();
            if (shuffleDescriptorIndex < shuffleDescriptorRange.getStartIndex() || shuffleDescriptorIndex > shuffleDescriptorRange.getEndIndex()) continue;
            consumedSubpartitionRanges.add(entry.getValue());
        }
        List<IndexRange> mergedConsumedSubpartitionRanges = IndexRangeUtil.mergeIndexRanges(consumedSubpartitionRanges);
        Preconditions.checkState(mergedConsumedSubpartitionRanges.size() == 1, "Illegal consumed subpartition range for shuffle descriptor index " + shuffleDescriptorIndex);
        return mergedConsumedSubpartitionRanges.get(0);
    }

    public static ConsumedSubpartitionContext buildConsumedSubpartitionContext(Map<IndexRange, IndexRange> consumedSubpartitionGroups, ConsumedPartitionGroup consumedPartitionGroup, Function<Integer, IntermediateResultPartitionID> partitionIdRetriever) {
        Map<IntermediateResultPartitionID, Integer> resultPartitionsInOrder = consumedPartitionGroup.getResultPartitionsInOrder();
        if (consumedSubpartitionGroups.size() == 1 && consumedSubpartitionGroups.keySet().iterator().next().size() == resultPartitionsInOrder.size()) {
            return ConsumedSubpartitionContext.buildConsumedSubpartitionContext(resultPartitionsInOrder.size(), consumedSubpartitionGroups.values().iterator().next());
        }
        LinkedHashMap<IndexRange, IndexRange> consumedShuffleDescriptorToSubpartitionRangeMap = new LinkedHashMap<IndexRange, IndexRange>();
        for (Map.Entry<IndexRange, IndexRange> entry : consumedSubpartitionGroups.entrySet()) {
            IndexRange partitionRange = entry.getKey();
            IndexRange subpartitionRange = entry.getValue();
            IndexRange shuffleDescriptorRange = new IndexRange(resultPartitionsInOrder.get(partitionIdRetriever.apply(partitionRange.getStartIndex())), resultPartitionsInOrder.get(partitionIdRetriever.apply(partitionRange.getEndIndex())));
            Preconditions.checkState(partitionRange.size() == shuffleDescriptorRange.size() && !consumedShuffleDescriptorToSubpartitionRangeMap.containsKey(shuffleDescriptorRange));
            consumedShuffleDescriptorToSubpartitionRangeMap.put(shuffleDescriptorRange, subpartitionRange);
        }
        int numConsumedShuffleDescriptors = 0;
        List<IndexRange> mergedConsumedShuffleDescriptor = IndexRangeUtil.mergeIndexRanges(consumedShuffleDescriptorToSubpartitionRangeMap.keySet());
        for (IndexRange range : mergedConsumedShuffleDescriptor) {
            numConsumedShuffleDescriptors += range.size();
        }
        return new ConsumedSubpartitionContext(numConsumedShuffleDescriptors, consumedShuffleDescriptorToSubpartitionRangeMap);
    }

    public static ConsumedSubpartitionContext buildConsumedSubpartitionContext(int numConsumedShuffleDescriptors, IndexRange consumedSubpartitionRange) {
        Preconditions.checkState(numConsumedShuffleDescriptors > 0);
        return new ConsumedSubpartitionContext(numConsumedShuffleDescriptors, Map.of(new IndexRange(0, numConsumedShuffleDescriptors - 1), consumedSubpartitionRange));
    }

    public String toString() {
        return String.format("ConsumedSubpartitionContext [num consumed shuffle descriptors: %s, consumed shuffle descriptors to subpartition range: %s]", this.numConsumedShuffleDescriptors, this.consumedShuffleDescriptorToSubpartitionRangeMap);
    }
}

