/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.api.common.resources.ExternalResource;
import org.apache.flink.api.common.resources.Resource;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.externalresource.ExternalResourceUtils;
import org.apache.flink.util.Preconditions;

public class ResourceProfile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ResourceProfile UNKNOWN = new ResourceProfile();
    @VisibleForTesting
    public static final ResourceProfile ANY = ResourceProfile.newBuilder().setCpuCores(Double.MAX_VALUE).setTaskHeapMemory(MemorySize.MAX_VALUE).setTaskOffHeapMemory(MemorySize.MAX_VALUE).setManagedMemory(MemorySize.MAX_VALUE).setNetworkMemory(MemorySize.MAX_VALUE).build();
    public static final ResourceProfile ZERO = ResourceProfile.newBuilder().build();
    static final BigDecimal MAX_CPU_CORE_NUMBER_TO_LOG = new BigDecimal(16384);
    static final MemorySize MAX_MEMORY_SIZE_TO_LOG = new MemorySize(0x4000000000000L);
    @Nullable
    private final CPUResource cpuCores;
    @Nullable
    private final MemorySize taskHeapMemory;
    @Nullable
    private final MemorySize taskOffHeapMemory;
    @Nullable
    private final MemorySize managedMemory;
    @Nullable
    private final MemorySize networkMemory;
    private final Map<String, ExternalResource> extendedResources;

    private ResourceProfile(CPUResource cpuCores, MemorySize taskHeapMemory, MemorySize taskOffHeapMemory, MemorySize managedMemory, MemorySize networkMemory, Map<String, ExternalResource> extendedResources) {
        Preconditions.checkNotNull(cpuCores);
        this.cpuCores = cpuCores;
        this.taskHeapMemory = Preconditions.checkNotNull(taskHeapMemory);
        this.taskOffHeapMemory = Preconditions.checkNotNull(taskOffHeapMemory);
        this.managedMemory = Preconditions.checkNotNull(managedMemory);
        this.networkMemory = Preconditions.checkNotNull(networkMemory);
        this.extendedResources = Preconditions.checkNotNull(extendedResources).entrySet().stream().filter(entry -> !Preconditions.checkNotNull((ExternalResource)entry.getValue()).isZero()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private ResourceProfile() {
        this.cpuCores = null;
        this.taskHeapMemory = null;
        this.taskOffHeapMemory = null;
        this.managedMemory = null;
        this.networkMemory = null;
        this.extendedResources = new HashMap<String, ExternalResource>();
    }

    public CPUResource getCpuCores() {
        this.throwUnsupportedOperationExceptionIfUnknown();
        return this.cpuCores;
    }

    public MemorySize getTaskHeapMemory() {
        this.throwUnsupportedOperationExceptionIfUnknown();
        return this.taskHeapMemory;
    }

    public MemorySize getTaskOffHeapMemory() {
        this.throwUnsupportedOperationExceptionIfUnknown();
        return this.taskOffHeapMemory;
    }

    public MemorySize getManagedMemory() {
        this.throwUnsupportedOperationExceptionIfUnknown();
        return this.managedMemory;
    }

    public MemorySize getNetworkMemory() {
        this.throwUnsupportedOperationExceptionIfUnknown();
        return this.networkMemory;
    }

    public MemorySize getTotalMemory() {
        this.throwUnsupportedOperationExceptionIfUnknown();
        return this.getOperatorsMemory().add(this.networkMemory);
    }

    public MemorySize getOperatorsMemory() {
        this.throwUnsupportedOperationExceptionIfUnknown();
        return this.taskHeapMemory.add(this.taskOffHeapMemory).add(this.managedMemory);
    }

    public Map<String, ExternalResource> getExtendedResources() {
        this.throwUnsupportedOperationExceptionIfUnknown();
        return Collections.unmodifiableMap(this.extendedResources);
    }

    private void throwUnsupportedOperationExceptionIfUnknown() {
        if (this.equals(UNKNOWN)) {
            throw new UnsupportedOperationException();
        }
    }

    public boolean isMatching(ResourceProfile required) {
        Preconditions.checkNotNull(required, "Cannot check matching with null resources");
        this.throwUnsupportedOperationExceptionIfUnknown();
        if (this.equals(ANY)) {
            return true;
        }
        if (this.equals(required)) {
            return true;
        }
        return required.equals(UNKNOWN);
    }

    public boolean allFieldsNoLessThan(ResourceProfile other) {
        Preconditions.checkNotNull(other, "Cannot compare null resources");
        if (this.equals(ANY)) {
            return true;
        }
        if (this.equals(other)) {
            return true;
        }
        if (this.equals(UNKNOWN)) {
            return false;
        }
        if (other.equals(UNKNOWN)) {
            return true;
        }
        if (this.cpuCores.getValue().compareTo(other.cpuCores.getValue()) >= 0 && this.taskHeapMemory.compareTo(other.taskHeapMemory) >= 0 && this.taskOffHeapMemory.compareTo(other.taskOffHeapMemory) >= 0 && this.managedMemory.compareTo(other.managedMemory) >= 0 && this.networkMemory.compareTo(other.networkMemory) >= 0) {
            for (Map.Entry<String, ExternalResource> resource : other.extendedResources.entrySet()) {
                if (this.extendedResources.containsKey(resource.getKey()) && this.extendedResources.get(resource.getKey()).getValue().compareTo(resource.getValue().getValue()) >= 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = Objects.hashCode(this.cpuCores);
        result = 31 * result + Objects.hashCode(this.taskHeapMemory);
        result = 31 * result + Objects.hashCode(this.taskOffHeapMemory);
        result = 31 * result + Objects.hashCode(this.managedMemory);
        result = 31 * result + Objects.hashCode(this.networkMemory);
        result = 31 * result + this.extendedResources.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == ResourceProfile.class) {
            ResourceProfile that = (ResourceProfile)obj;
            return Objects.equals(this.cpuCores, that.cpuCores) && Objects.equals(this.taskHeapMemory, that.taskHeapMemory) && Objects.equals(this.taskOffHeapMemory, that.taskOffHeapMemory) && Objects.equals(this.managedMemory, that.managedMemory) && Objects.equals(this.networkMemory, that.networkMemory) && Objects.equals(this.extendedResources, that.extendedResources);
        }
        return false;
    }

    @Nonnull
    public ResourceProfile merge(ResourceProfile other) {
        Preconditions.checkNotNull(other, "Cannot merge with null resources");
        if (this.equals(ANY) || other.equals(ANY)) {
            return ANY;
        }
        if (this.equals(UNKNOWN) || other.equals(UNKNOWN)) {
            return UNKNOWN;
        }
        HashMap<String, ExternalResource> resultExtendedResource = new HashMap<String, ExternalResource>(this.extendedResources);
        other.extendedResources.forEach((name, resource) -> resultExtendedResource.compute((String)name, (ignored, oldResource) -> oldResource == null ? resource : oldResource.merge(resource)));
        return new ResourceProfile(this.cpuCores.merge(other.cpuCores), this.taskHeapMemory.add(other.taskHeapMemory), this.taskOffHeapMemory.add(other.taskOffHeapMemory), this.managedMemory.add(other.managedMemory), this.networkMemory.add(other.networkMemory), resultExtendedResource);
    }

    public ResourceProfile subtract(ResourceProfile other) {
        Preconditions.checkNotNull(other, "Cannot subtract with null resources");
        if (this.equals(ANY) || other.equals(ANY)) {
            return ANY;
        }
        if (this.equals(UNKNOWN) || other.equals(UNKNOWN)) {
            return UNKNOWN;
        }
        Preconditions.checkArgument(this.allFieldsNoLessThan(other), "Try to subtract an unmatched resource profile from this one.");
        HashMap<String, ExternalResource> resultExtendedResource = new HashMap<String, ExternalResource>(this.extendedResources);
        other.extendedResources.forEach((name, resource) -> resultExtendedResource.compute((String)name, (ignored, oldResource) -> oldResource.subtract(resource)));
        return new ResourceProfile(this.cpuCores.subtract(other.cpuCores), this.taskHeapMemory.subtract(other.taskHeapMemory), this.taskOffHeapMemory.subtract(other.taskOffHeapMemory), this.managedMemory.subtract(other.managedMemory), this.networkMemory.subtract(other.networkMemory), resultExtendedResource);
    }

    @Nonnull
    public ResourceProfile multiply(int multiplier) {
        Preconditions.checkArgument(multiplier >= 0, "multiplier must be >= 0");
        if (this.equals(ANY)) {
            return ANY;
        }
        if (this.equals(UNKNOWN)) {
            return UNKNOWN;
        }
        if (multiplier == 0) {
            return ZERO;
        }
        Map<String, ExternalResource> resultExtendedResource = this.extendedResources.entrySet().stream().map(entry -> Tuple2.of((String)entry.getKey(), (ExternalResource)((ExternalResource)entry.getValue()).multiply(multiplier))).collect(Collectors.toMap(tuple -> (String)tuple.f0, tuple -> (ExternalResource)tuple.f1));
        return new ResourceProfile((CPUResource)this.cpuCores.multiply(multiplier), this.taskHeapMemory.multiply(multiplier), this.taskOffHeapMemory.multiply(multiplier), this.managedMemory.multiply(multiplier), this.networkMemory.multiply(multiplier), resultExtendedResource);
    }

    public String toString() {
        if (this.equals(UNKNOWN)) {
            return "ResourceProfile{UNKNOWN}";
        }
        if (this.equals(ANY)) {
            return "ResourceProfile{ANY}";
        }
        return "ResourceProfile{" + this.getResourceString() + (String)(this.extendedResources.isEmpty() ? "" : ", " + ExternalResourceUtils.generateExternalResourcesString(this.extendedResources.values())) + "}";
    }

    private String getResourceString() {
        String resourceStr = this.cpuCores == null || this.cpuCores.getValue().compareTo(MAX_CPU_CORE_NUMBER_TO_LOG) > 0 ? "" : "cpuCores=" + String.valueOf(this.cpuCores.getValue());
        resourceStr = ResourceProfile.addMemorySizeString(resourceStr, "taskHeapMemory", this.taskHeapMemory);
        resourceStr = ResourceProfile.addMemorySizeString(resourceStr, "taskOffHeapMemory", this.taskOffHeapMemory);
        resourceStr = ResourceProfile.addMemorySizeString(resourceStr, "managedMemory", this.managedMemory);
        resourceStr = ResourceProfile.addMemorySizeString(resourceStr, "networkMemory", this.networkMemory);
        return resourceStr;
    }

    private static String addMemorySizeString(String resourceStr, String name, MemorySize size) {
        String comma = resourceStr.isEmpty() ? "" : ", ";
        String memorySizeStr = size == null || size.compareTo(MAX_MEMORY_SIZE_TO_LOG) > 0 ? "" : comma + name + "=" + size.toHumanReadableString();
        return resourceStr + memorySizeStr;
    }

    private Object readResolve() {
        if (this.equals(UNKNOWN)) {
            return UNKNOWN;
        }
        if (this.equals(ANY)) {
            return ANY;
        }
        return this;
    }

    @VisibleForTesting
    static ResourceProfile fromResourceSpec(ResourceSpec resourceSpec) {
        return ResourceProfile.fromResourceSpec(resourceSpec, MemorySize.ZERO);
    }

    public static ResourceProfile fromResourceSpec(ResourceSpec resourceSpec, MemorySize networkMemory) {
        if (ResourceSpec.UNKNOWN.equals(resourceSpec)) {
            return UNKNOWN;
        }
        return ResourceProfile.newBuilder().setCpuCores(resourceSpec.getCpuCores()).setTaskHeapMemory(resourceSpec.getTaskHeapMemory()).setTaskOffHeapMemory(resourceSpec.getTaskOffHeapMemory()).setManagedMemory(resourceSpec.getManagedMemory()).setNetworkMemory(networkMemory).setExtendedResources(resourceSpec.getExtendedResources().values()).build();
    }

    @VisibleForTesting
    public static ResourceProfile fromResources(double cpuCores, int taskHeapMemoryMB) {
        return ResourceProfile.newBuilder().setCpuCores(cpuCores).setTaskHeapMemoryMB(taskHeapMemoryMB).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ResourceProfile resourceProfile) {
        Preconditions.checkArgument(!resourceProfile.equals(UNKNOWN));
        return ResourceProfile.newBuilder().setCpuCores(resourceProfile.cpuCores).setTaskHeapMemory(resourceProfile.taskHeapMemory).setTaskOffHeapMemory(resourceProfile.taskOffHeapMemory).setManagedMemory(resourceProfile.managedMemory).setNetworkMemory(resourceProfile.networkMemory).setExtendedResources(resourceProfile.extendedResources.values());
    }

    public static class Builder {
        private CPUResource cpuCores = new CPUResource(0.0);
        private MemorySize taskHeapMemory = MemorySize.ZERO;
        private MemorySize taskOffHeapMemory = MemorySize.ZERO;
        private MemorySize managedMemory = MemorySize.ZERO;
        private MemorySize networkMemory = MemorySize.ZERO;
        private Map<String, ExternalResource> extendedResources = new HashMap<String, ExternalResource>();

        private Builder() {
        }

        public Builder setCpuCores(CPUResource cpuCores) {
            this.cpuCores = cpuCores;
            return this;
        }

        public Builder setCpuCores(double cpuCores) {
            this.cpuCores = new CPUResource(cpuCores);
            return this;
        }

        public Builder setTaskHeapMemory(MemorySize taskHeapMemory) {
            this.taskHeapMemory = taskHeapMemory;
            return this;
        }

        public Builder setTaskHeapMemoryMB(int taskHeapMemoryMB) {
            this.taskHeapMemory = MemorySize.ofMebiBytes(taskHeapMemoryMB);
            return this;
        }

        public Builder setTaskOffHeapMemory(MemorySize taskOffHeapMemory) {
            this.taskOffHeapMemory = taskOffHeapMemory;
            return this;
        }

        public Builder setTaskOffHeapMemoryMB(int taskOffHeapMemoryMB) {
            this.taskOffHeapMemory = MemorySize.ofMebiBytes(taskOffHeapMemoryMB);
            return this;
        }

        public Builder setManagedMemory(MemorySize managedMemory) {
            this.managedMemory = managedMemory;
            return this;
        }

        public Builder setManagedMemoryMB(int managedMemoryMB) {
            this.managedMemory = MemorySize.ofMebiBytes(managedMemoryMB);
            return this;
        }

        public Builder setNetworkMemory(MemorySize networkMemory) {
            this.networkMemory = networkMemory;
            return this;
        }

        public Builder setNetworkMemoryMB(int networkMemoryMB) {
            this.networkMemory = MemorySize.ofMebiBytes(networkMemoryMB);
            return this;
        }

        public Builder setExtendedResource(ExternalResource extendedResource) {
            this.extendedResources.put(extendedResource.getName(), extendedResource);
            return this;
        }

        public Builder setExtendedResources(Collection<ExternalResource> extendedResources) {
            this.extendedResources = extendedResources.stream().collect(Collectors.toMap(Resource::getName, Function.identity()));
            return this;
        }

        public ResourceProfile build() {
            return new ResourceProfile(this.cpuCores, this.taskHeapMemory, this.taskOffHeapMemory, this.managedMemory, this.networkMemory, this.extendedResources);
        }
    }
}

