/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json.ogg;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonFormatOptions;
import org.apache.flink.formats.json.JsonFormatOptionsUtil;
import org.apache.flink.formats.json.ogg.OggJsonDecodingFormat;
import org.apache.flink.formats.json.ogg.OggJsonFormatOptions;
import org.apache.flink.formats.json.ogg.OggJsonSerializationSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;

@Internal
public class OggJsonFormatFactory
implements DeserializationFormatFactory,
SerializationFormatFactory {
    public static final String IDENTIFIER = "ogg-json";

    private static void validateDecodingFormatOptions(ReadableConfig tableOptions) {
        JsonFormatOptionsUtil.validateDecodingFormatOptions(tableOptions);
    }

    private static void validateEncodingFormatOptions(ReadableConfig tableOptions) {
        JsonFormatOptionsUtil.validateEncodingFormatOptions(tableOptions);
    }

    @Override
    public DecodingFormat<DeserializationSchema<RowData>> createDecodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions(this, formatOptions);
        OggJsonFormatFactory.validateDecodingFormatOptions(formatOptions);
        boolean ignoreParseErrors = formatOptions.get(OggJsonFormatOptions.IGNORE_PARSE_ERRORS);
        TimestampFormat timestampFormat = JsonFormatOptionsUtil.getTimestampFormat(formatOptions);
        return new OggJsonDecodingFormat(ignoreParseErrors, timestampFormat);
    }

    @Override
    public EncodingFormat<SerializationSchema<RowData>> createEncodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions(this, formatOptions);
        OggJsonFormatFactory.validateEncodingFormatOptions(formatOptions);
        final TimestampFormat timestampFormat = JsonFormatOptionsUtil.getTimestampFormat(formatOptions);
        final JsonFormatOptions.MapNullKeyMode mapNullKeyMode = JsonFormatOptionsUtil.getMapNullKeyMode(formatOptions);
        final String mapNullKeyLiteral = formatOptions.get(OggJsonFormatOptions.JSON_MAP_NULL_KEY_LITERAL);
        final boolean encodeDecimalAsPlainNumber = formatOptions.get(JsonFormatOptions.ENCODE_DECIMAL_AS_PLAIN_NUMBER);
        final boolean ignoreNullFields = formatOptions.get(JsonFormatOptions.ENCODE_IGNORE_NULL_FIELDS);
        return new EncodingFormat<SerializationSchema<RowData>>(){

            @Override
            public ChangelogMode getChangelogMode() {
                return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
            }

            @Override
            public SerializationSchema<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType consumedDataType) {
                RowType rowType = (RowType)consumedDataType.getLogicalType();
                return new OggJsonSerializationSchema(rowType, timestampFormat, mapNullKeyMode, mapNullKeyLiteral, encodeDecimalAsPlainNumber, ignoreNullFields);
            }
        };
    }

    @Override
    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    @Override
    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(OggJsonFormatOptions.IGNORE_PARSE_ERRORS);
        options.add(OggJsonFormatOptions.TIMESTAMP_FORMAT);
        options.add(OggJsonFormatOptions.JSON_MAP_NULL_KEY_MODE);
        options.add(OggJsonFormatOptions.JSON_MAP_NULL_KEY_LITERAL);
        options.add(JsonFormatOptions.ENCODE_DECIMAL_AS_PLAIN_NUMBER);
        options.add(JsonFormatOptions.ENCODE_IGNORE_NULL_FIELDS);
        return options;
    }
}

