/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.AbstractJsonDeserializationSchema;
import org.apache.flink.formats.json.JsonParserToRowDataConverters;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonToken;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

@Internal
public class JsonParserRowDataDeserializationSchema
extends AbstractJsonDeserializationSchema {
    private final JsonParserToRowDataConverters.JsonParserToRowDataConverter runtimeConverter;

    public JsonParserRowDataDeserializationSchema(RowType rowType, TypeInformation<RowData> resultTypeInfo, boolean failOnMissingField, boolean ignoreParseErrors, TimestampFormat timestampFormat) {
        this(rowType, resultTypeInfo, failOnMissingField, ignoreParseErrors, timestampFormat, null);
    }

    public JsonParserRowDataDeserializationSchema(RowType rowType, TypeInformation<RowData> resultTypeInfo, boolean failOnMissingField, boolean ignoreParseErrors, TimestampFormat timestampFormat, @Nullable String[][] projectedFields) {
        super(rowType, resultTypeInfo, failOnMissingField, ignoreParseErrors, timestampFormat);
        this.runtimeConverter = new JsonParserToRowDataConverters(failOnMissingField, ignoreParseErrors, timestampFormat).createConverter(projectedFields, Preconditions.checkNotNull(rowType));
    }

    @Override
    public void deserialize(byte[] message, Collector<RowData> out) throws IOException {
        block13: {
            if (message == null || message.length == 0) {
                return;
            }
            try (JsonParser root = this.objectMapper.getFactory().createParser(message);){
                if (root.currentToken() == null) {
                    root.nextToken();
                }
                if (root.currentToken() != JsonToken.START_OBJECT && root.currentToken() != JsonToken.START_ARRAY) {
                    throw JsonMappingException.from(root, "No content to map due to end-of-input");
                }
                if (root.currentToken() == JsonToken.START_ARRAY) {
                    this.processArray(root, out);
                } else {
                    this.processObject(root, out);
                }
            }
            catch (Throwable t) {
                if (this.ignoreParseErrors) break block13;
                throw new IOException(String.format("Failed to deserialize JSON '%s'.", new String(message)), t);
            }
        }
    }

    private void processArray(JsonParser root, Collector<RowData> out) throws IOException {
        while (root.nextToken() != JsonToken.END_ARRAY) {
            out.collect((RowData)this.runtimeConverter.convert(root));
        }
    }

    private void processObject(JsonParser root, Collector<RowData> out) throws IOException {
        out.collect((RowData)this.runtimeConverter.convert(root));
    }
}

