/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.api.common.functions.util.ListCollector;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.json.JsonReadFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.util.Collector;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.jackson.JacksonMapperFactory;

public abstract class AbstractJsonDeserializationSchema
implements DeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    protected final boolean failOnMissingField;
    protected final boolean ignoreParseErrors;
    private final TypeInformation<RowData> resultTypeInfo;
    protected transient ObjectMapper objectMapper;
    private final TimestampFormat timestampFormat;
    private final boolean hasDecimalType;
    private transient Collector<RowData> collector;
    private transient List<RowData> reusableCollectList;

    public AbstractJsonDeserializationSchema(RowType rowType, TypeInformation<RowData> resultTypeInfo, boolean failOnMissingField, boolean ignoreParseErrors, TimestampFormat timestampFormat) {
        if (ignoreParseErrors && failOnMissingField) {
            throw new IllegalArgumentException("JSON format doesn't support failOnMissingField and ignoreParseErrors are both enabled.");
        }
        this.resultTypeInfo = Preconditions.checkNotNull(resultTypeInfo);
        this.failOnMissingField = failOnMissingField;
        this.ignoreParseErrors = ignoreParseErrors;
        this.timestampFormat = timestampFormat;
        this.hasDecimalType = LogicalTypeChecks.hasNested(rowType, t -> t instanceof DecimalType);
    }

    @Override
    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.objectMapper = JacksonMapperFactory.createObjectMapper().configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature(), true);
        if (this.hasDecimalType) {
            this.objectMapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        }
        this.reusableCollectList = new ArrayList<RowData>();
        this.collector = new ListCollector<RowData>(this.reusableCollectList);
    }

    @Override
    @Deprecated
    public RowData deserialize(@Nullable byte[] message) throws IOException {
        this.reusableCollectList.clear();
        this.deserialize(message, this.collector);
        if (this.reusableCollectList.size() > 1) {
            throw new FlinkRuntimeException("Please invoke DeserializationSchema#deserialize(byte[], Collector<RowData>) instead.");
        }
        if (this.reusableCollectList.isEmpty()) {
            return null;
        }
        return this.reusableCollectList.get(0);
    }

    @Override
    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    @Override
    public TypeInformation<RowData> getProducedType() {
        return this.resultTypeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractJsonDeserializationSchema that = (AbstractJsonDeserializationSchema)o;
        return this.failOnMissingField == that.failOnMissingField && this.ignoreParseErrors == that.ignoreParseErrors && this.resultTypeInfo.equals(that.resultTypeInfo) && this.timestampFormat.equals((Object)that.timestampFormat);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.failOnMissingField, this.ignoreParseErrors, this.resultTypeInfo, this.timestampFormat});
    }
}

