/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.plugin;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.core.plugin.PluginDescriptor;
import org.apache.flink.core.plugin.PluginFinder;
import org.apache.flink.util.function.FunctionUtils;

public class DirectoryBasedPluginFinder
implements PluginFinder {
    private static final String JAR_MATCHER_PATTERN = "glob:**.jar";
    private final Path pluginsRootDir;
    private final PathMatcher jarFileMatcher;

    public DirectoryBasedPluginFinder(Path pluginsRootDir) {
        this.pluginsRootDir = pluginsRootDir;
        this.jarFileMatcher = pluginsRootDir.getFileSystem().getPathMatcher(JAR_MATCHER_PATTERN);
    }

    @Override
    public Collection<PluginDescriptor> findPlugins() throws IOException {
        if (!Files.isDirectory(this.pluginsRootDir, new LinkOption[0])) {
            throw new IOException("Plugins root directory [" + String.valueOf(this.pluginsRootDir) + "] does not exist!");
        }
        try (Stream<Path> stream = Files.list(this.pluginsRootDir);){
            Collection collection = stream.filter(path -> Files.isDirectory(path, new LinkOption[0])).map(FunctionUtils.uncheckedFunction(this::createPluginDescriptorForSubDirectory)).collect(Collectors.toList());
            return collection;
        }
    }

    private PluginDescriptor createPluginDescriptorForSubDirectory(Path subDirectory) throws IOException {
        URL[] urls = this.createJarURLsFromDirectory(subDirectory);
        Arrays.sort(urls, Comparator.comparing(URL::toString));
        return new PluginDescriptor(subDirectory.getFileName().toString(), urls, new String[0]);
    }

    private URL[] createJarURLsFromDirectory(Path subDirectory) throws IOException {
        try (Stream<Path> stream = Files.list(subDirectory);){
            URL[] urls = (URL[])stream.filter(p -> Files.isRegularFile(p, new LinkOption[0]) && this.jarFileMatcher.matches((Path)p)).map(FunctionUtils.uncheckedFunction(p -> p.toUri().toURL())).toArray(URL[]::new);
            if (urls.length < 1) {
                throw new IOException("Cannot find any jar files for plugin in directory [" + String.valueOf(subDirectory) + "]. Please provide the jar files for the plugin or delete the directory.");
            }
            URL[] uRLArray = urls;
            return uRLArray;
        }
    }
}

