/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

@PublicEvolving
public class StateSizeTrackOptions {
    @Documentation.Section(value={"state_size_tracking"})
    public static final ConfigOption<Boolean> SIZE_TRACK_ENABLED = ConfigOptions.key("state.size-track.keyed-state-enabled").booleanType().defaultValue(false).withDescription("Whether to track size of keyed state operations, e.g value state put/get/clear. Please note that if state.ttl is enabled, the size of the value will include the size of the TTL-related timestamp.");
    @Documentation.Section(value={"state_size_tracking"})
    public static final ConfigOption<Integer> SIZE_TRACK_SAMPLE_INTERVAL = ConfigOptions.key("state.size-track.sample-interval").intType().defaultValue(100).withDescription(String.format("The sample interval of size track once '%s' is enabled. The default value is 100, which means we would track the size every 100 access requests.", SIZE_TRACK_ENABLED.key()));
    @Documentation.Section(value={"state_size_tracking"})
    public static final ConfigOption<Integer> SIZE_TRACK_HISTORY_SIZE = ConfigOptions.key("state.size-track.history-size").intType().defaultValue(128).withDescription("Defines the number of measured size to maintain at each state access operation.");
    @Documentation.Section(value={"state_size_tracking"})
    public static final ConfigOption<Boolean> SIZE_TRACK_STATE_NAME_AS_VARIABLE = ConfigOptions.key("state.size-track.state-name-as-variable").booleanType().defaultValue(true).withDescription("Whether to expose state name as a variable if tracking size.");
}

