/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeComparator;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.FieldSerializer;
import org.apache.flink.api.java.typeutils.runtime.TupleComparatorBase;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.NullKeyFieldException;
import org.apache.flink.util.InstantiationUtil;

@Internal
public final class PojoComparator<T>
extends CompositeTypeComparator<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Field[] keyFields;
    private final TypeComparator<Object>[] comparators;
    private final int[] normalizedKeyLengths;
    private final int numLeadingNormalizableKeys;
    private final int normalizableKeyPrefixLen;
    private final boolean invertNormKey;
    private TypeSerializer<T> serializer;
    private final Class<T> type;

    public PojoComparator(Field[] keyFields, TypeComparator<?>[] comparators, TypeSerializer<T> serializer, Class<T> type) {
        this.keyFields = keyFields;
        this.comparators = comparators;
        this.type = type;
        this.serializer = serializer;
        this.normalizedKeyLengths = new int[keyFields.length];
        int nKeys = 0;
        int nKeyLen = 0;
        boolean inverted = false;
        for (Field keyField : keyFields) {
            keyField.setAccessible(true);
        }
        for (int i = 0; i < this.comparators.length; ++i) {
            TypeComparator<Object> k = this.comparators[i];
            if (k == null) {
                throw new IllegalArgumentException("One of the passed comparators is null");
            }
            if (keyFields[i] == null) {
                throw new IllegalArgumentException("One of the passed reflection fields is null");
            }
            if (!k.supportsNormalizedKey()) break;
            if (i == 0) {
                inverted = k.invertNormalizedKey();
            } else if (k.invertNormalizedKey() != inverted) break;
            ++nKeys;
            int len = k.getNormalizeKeyLen();
            if (len < 0) {
                throw new RuntimeException("Comparator " + k.getClass().getName() + " specifies an invalid length for the normalized key: " + len);
            }
            this.normalizedKeyLengths[i] = len;
            if ((nKeyLen += this.normalizedKeyLengths[i]) >= 0) continue;
            nKeyLen = Integer.MAX_VALUE;
            break;
        }
        this.numLeadingNormalizableKeys = nKeys;
        this.normalizableKeyPrefixLen = nKeyLen;
        this.invertNormKey = inverted;
    }

    private PojoComparator(PojoComparator<T> toClone) {
        this.keyFields = toClone.keyFields;
        this.comparators = new TypeComparator[toClone.comparators.length];
        for (int i = 0; i < toClone.comparators.length; ++i) {
            this.comparators[i] = toClone.comparators[i].duplicate();
        }
        this.normalizedKeyLengths = toClone.normalizedKeyLengths;
        this.numLeadingNormalizableKeys = toClone.numLeadingNormalizableKeys;
        this.normalizableKeyPrefixLen = toClone.normalizableKeyPrefixLen;
        this.invertNormKey = toClone.invertNormKey;
        this.type = toClone.type;
        try {
            this.serializer = (TypeSerializer)InstantiationUtil.deserializeObject(InstantiationUtil.serializeObject(toClone.serializer), Thread.currentThread().getContextClassLoader());
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Cannot copy serializer", e);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        out.defaultWriteObject();
        out.writeInt(this.keyFields.length);
        for (Field field : this.keyFields) {
            FieldSerializer.serializeField(field, out);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int numKeyFields = in.readInt();
        this.keyFields = new Field[numKeyFields];
        for (int i = 0; i < numKeyFields; ++i) {
            this.keyFields[i] = FieldSerializer.deserializeField(in);
        }
    }

    public Field[] getKeyFields() {
        return this.keyFields;
    }

    @Override
    public void getFlatComparator(List<TypeComparator> flatComparators) {
        for (int i = 0; i < this.comparators.length; ++i) {
            if (this.comparators[i] instanceof CompositeTypeComparator) {
                ((CompositeTypeComparator)this.comparators[i]).getFlatComparator(flatComparators);
                continue;
            }
            flatComparators.add(this.comparators[i]);
        }
    }

    public final Object accessField(Field field, Object object) {
        try {
            object = field.get(object);
        }
        catch (NullPointerException npex) {
            throw new NullKeyFieldException("Unable to access field " + String.valueOf(field) + " on object " + String.valueOf(object));
        }
        catch (IllegalAccessException iaex) {
            throw new RuntimeException("This should not happen since we call setAccesssible(true) in the ctor. fields: " + String.valueOf(field) + " obj: " + String.valueOf(object));
        }
        return object;
    }

    @Override
    public int hash(T value) {
        int code = 0;
        for (int i = 0; i < this.keyFields.length; ++i) {
            code *= TupleComparatorBase.HASH_SALT[i & 0x1F];
            try {
                code += this.comparators[i].hash(this.accessField(this.keyFields[i], value));
                continue;
            }
            catch (NullPointerException npe) {
                throw new RuntimeException("A NullPointerException occurred while accessing a key field in a POJO. Most likely, the value grouped/joined on is null. Field name: " + this.keyFields[i].getName(), npe);
            }
        }
        return code;
    }

    @Override
    public void setReference(T toCompare) {
        for (int i = 0; i < this.keyFields.length; ++i) {
            this.comparators[i].setReference(this.accessField(this.keyFields[i], toCompare));
        }
    }

    @Override
    public boolean equalToReference(T candidate) {
        for (int i = 0; i < this.keyFields.length; ++i) {
            if (this.comparators[i].equalToReference(this.accessField(this.keyFields[i], candidate))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareToReference(TypeComparator<T> referencedComparator) {
        int i;
        PojoComparator other = (PojoComparator)referencedComparator;
        try {
            for (i = 0; i < this.keyFields.length; ++i) {
                int cmp = this.comparators[i].compareToReference(other.comparators[i]);
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
        catch (NullPointerException npex) {
            throw new NullKeyFieldException(this.keyFields[i].toString());
        }
    }

    @Override
    public int compare(T first, T second) {
        for (int i = 0; i < this.keyFields.length; ++i) {
            int cmp = this.comparators[i].compare(this.accessField(this.keyFields[i], first), this.accessField(this.keyFields[i], second));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        T first = this.serializer.createInstance();
        T second = this.serializer.createInstance();
        first = this.serializer.deserialize(first, firstSource);
        second = this.serializer.deserialize(second, secondSource);
        return this.compare(first, second);
    }

    @Override
    public boolean supportsNormalizedKey() {
        return this.numLeadingNormalizableKeys > 0;
    }

    @Override
    public int getNormalizeKeyLen() {
        return this.normalizableKeyPrefixLen;
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return this.numLeadingNormalizableKeys < this.keyFields.length || this.normalizableKeyPrefixLen == Integer.MAX_VALUE || this.normalizableKeyPrefixLen > keyBytes;
    }

    @Override
    public void putNormalizedKey(T value, MemorySegment target, int offset, int numBytes) {
        for (int i = 0; i < this.numLeadingNormalizableKeys && numBytes > 0; ++i) {
            int len = this.normalizedKeyLengths[i];
            len = numBytes >= len ? len : numBytes;
            this.comparators[i].putNormalizedKey(this.accessField(this.keyFields[i], value), target, offset, len);
            numBytes -= len;
            offset += len;
        }
    }

    @Override
    public boolean invertNormalizedKey() {
        return this.invertNormKey;
    }

    @Override
    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    @Override
    public void writeWithKeyNormalization(T record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public T readWithKeyDenormalization(T reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PojoComparator<T> duplicate() {
        return new PojoComparator<T>(this);
    }

    @Override
    public int extractKeys(Object record, Object[] target, int index) {
        int localIndex = index;
        for (int i = 0; i < this.comparators.length; ++i) {
            localIndex += this.comparators[i].extractKeys(this.accessField(this.keyFields[i], record), target, localIndex);
        }
        return localIndex - index;
    }
}

