/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;

@Public
public abstract class AbstractParameterTool
extends ExecutionConfig.GlobalJobParameters
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected static final String NO_VALUE_KEY = "__NO_VALUE_KEY";
    protected static final String DEFAULT_UNDEFINED = "<undefined>";
    protected transient Map<String, String> defaultData;
    protected transient Set<String> unrequestedParameters;

    @PublicEvolving
    public Set<String> getUnrequestedParameters() {
        return Collections.unmodifiableSet(this.unrequestedParameters);
    }

    protected abstract int getNumberOfParameters();

    protected abstract String get(String var1);

    public abstract boolean has(String var1);

    public String getRequired(String key) {
        this.addToDefaults(key, null);
        String value = this.get(key);
        if (value == null) {
            throw new RuntimeException("No data for required key '" + key + "'");
        }
        return value;
    }

    public String get(String key, String defaultValue) {
        this.addToDefaults(key, defaultValue);
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public int getInt(String key) {
        this.addToDefaults(key, null);
        String value = this.getRequired(key);
        return Integer.parseInt(value);
    }

    public int getInt(String key, int defaultValue) {
        this.addToDefaults(key, Integer.toString(defaultValue));
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public long getLong(String key) {
        this.addToDefaults(key, null);
        String value = this.getRequired(key);
        return Long.parseLong(value);
    }

    public long getLong(String key, long defaultValue) {
        this.addToDefaults(key, Long.toString(defaultValue));
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public float getFloat(String key) {
        this.addToDefaults(key, null);
        String value = this.getRequired(key);
        return Float.valueOf(value).floatValue();
    }

    public float getFloat(String key, float defaultValue) {
        this.addToDefaults(key, Float.toString(defaultValue));
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Float.valueOf(value).floatValue();
    }

    public double getDouble(String key) {
        this.addToDefaults(key, null);
        String value = this.getRequired(key);
        return Double.valueOf(value);
    }

    public double getDouble(String key, double defaultValue) {
        this.addToDefaults(key, Double.toString(defaultValue));
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Double.valueOf(value);
    }

    public boolean getBoolean(String key) {
        this.addToDefaults(key, null);
        String value = this.getRequired(key);
        return Boolean.valueOf(value);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        this.addToDefaults(key, Boolean.toString(defaultValue));
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public short getShort(String key) {
        this.addToDefaults(key, null);
        String value = this.getRequired(key);
        return Short.valueOf(value);
    }

    public short getShort(String key, short defaultValue) {
        this.addToDefaults(key, Short.toString(defaultValue));
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Short.valueOf(value);
    }

    public byte getByte(String key) {
        this.addToDefaults(key, null);
        String value = this.getRequired(key);
        return Byte.valueOf(value);
    }

    public byte getByte(String key, byte defaultValue) {
        this.addToDefaults(key, Byte.toString(defaultValue));
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Byte.valueOf(value);
    }

    protected void addToDefaults(String key, String value) {
        String currentValue = this.defaultData.get(key);
        if (currentValue == null) {
            if (value == null) {
                value = DEFAULT_UNDEFINED;
            }
            this.defaultData.put(key, value);
        } else if (currentValue.equals(DEFAULT_UNDEFINED) && value != null) {
            this.defaultData.put(key, value);
        }
    }

    protected abstract Object clone() throws CloneNotSupportedException;

    @Override
    public abstract Map<String, String> toMap();
}

