/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.IOException;
import org.apache.flink.annotation.Public;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.NormalizableKey;
import org.apache.flink.types.ResettableValue;

@Public
public class CharValue
implements NormalizableKey<CharValue>,
ResettableValue<CharValue>,
CopyableValue<CharValue> {
    private static final long serialVersionUID = 1L;
    private char value;

    public CharValue() {
        this.value = '\u0000';
    }

    public CharValue(char value) {
        this.value = value;
    }

    public char getValue() {
        return this.value;
    }

    @Override
    public void setValue(char value) {
        this.value = value;
    }

    @Override
    public void setValue(CharValue value) {
        this.value = value.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void read(DataInputView in) throws IOException {
        this.value = in.readChar();
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        out.writeChar(this.value);
    }

    @Override
    public int compareTo(CharValue o) {
        char other = o.value;
        return this.value < other ? -1 : (this.value > other ? 1 : 0);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CharValue) {
            return ((CharValue)obj).value == this.value;
        }
        return false;
    }

    @Override
    public int getMaxNormalizedKeyLen() {
        return 2;
    }

    @Override
    public void copyNormalizedKey(MemorySegment target, int offset, int len) {
        if (len == 2) {
            target.put(offset, (byte)(this.value >>> 8 & 0xFF));
            target.put(offset + 1, (byte)(this.value & 0xFF));
        } else if (len > 0) {
            if (len == 1) {
                target.put(offset, (byte)(this.value >>> 8 & 0xFF));
            } else {
                target.put(offset, (byte)(this.value >>> 8 & 0xFF));
                target.put(offset + 1, (byte)(this.value & 0xFF));
                for (int i = 2; i < len; ++i) {
                    target.put(offset + i, (byte)0);
                }
            }
        }
    }

    @Override
    public int getBinaryLength() {
        return 2;
    }

    @Override
    public void copyTo(CharValue target) {
        target.value = this.value;
    }

    @Override
    public CharValue copy() {
        return new CharValue(this.value);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.write(source, 2);
    }
}

