/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.state.v2.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.runtime.state.RegisteredStateMetaInfoBase;
import org.apache.flink.runtime.state.RegisteredStateMetaInfoUtils;
import org.apache.flink.runtime.state.StateSerializerProvider;
import org.apache.flink.runtime.state.StateSnapshotTransformer;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.runtime.state.v2.RegisteredKeyAndUserKeyValueStateBackendMetaInfo;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;

public class RegisteredKeyValueStateBackendMetaInfo<N, S>
extends RegisteredStateMetaInfoBase {
    @Nonnull
    protected final StateDescriptor.Type stateType;
    @Nonnull
    protected final StateSerializerProvider<N> namespaceSerializerProvider;
    @Nonnull
    protected final StateSerializerProvider<S> stateSerializerProvider;
    @Nonnull
    protected StateSnapshotTransformer.StateSnapshotTransformFactory<S> stateSnapshotTransformFactory;

    public RegisteredKeyValueStateBackendMetaInfo(@Nonnull String name, @Nonnull StateDescriptor.Type stateType, @Nonnull TypeSerializer<N> namespaceSerializer, @Nonnull TypeSerializer<S> stateSerializer) {
        this(name, stateType, StateSerializerProvider.fromNewRegisteredSerializer(namespaceSerializer), StateSerializerProvider.fromNewRegisteredSerializer(stateSerializer), StateSnapshotTransformer.StateSnapshotTransformFactory.noTransform());
    }

    public RegisteredKeyValueStateBackendMetaInfo(@Nonnull String name, @Nonnull StateDescriptor.Type stateType, @Nonnull TypeSerializer<N> namespaceSerializer, @Nonnull TypeSerializer<S> stateSerializer, @Nonnull StateSnapshotTransformer.StateSnapshotTransformFactory<S> stateSnapshotTransformFactory) {
        this(name, stateType, StateSerializerProvider.fromNewRegisteredSerializer(namespaceSerializer), StateSerializerProvider.fromNewRegisteredSerializer(stateSerializer), stateSnapshotTransformFactory);
    }

    public RegisteredKeyValueStateBackendMetaInfo(@Nonnull StateMetaInfoSnapshot snapshot) {
        this(snapshot.getName(), StateDescriptor.Type.valueOf(snapshot.getOption(StateMetaInfoSnapshot.CommonOptionsKeys.KEYED_STATE_TYPE)), StateSerializerProvider.fromPreviousSerializerSnapshot(Preconditions.checkNotNull(snapshot.getTypeSerializerSnapshot(StateMetaInfoSnapshot.CommonSerializerKeys.NAMESPACE_SERIALIZER))), StateSerializerProvider.fromPreviousSerializerSnapshot(Preconditions.checkNotNull(snapshot.getTypeSerializerSnapshot(StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER))), StateSnapshotTransformer.StateSnapshotTransformFactory.noTransform());
        Preconditions.checkState(StateMetaInfoSnapshot.BackendStateType.KEY_VALUE_V2 == snapshot.getBackendStateType());
    }

    public RegisteredKeyValueStateBackendMetaInfo(@Nonnull String name, @Nonnull StateDescriptor.Type stateType, @Nonnull StateSerializerProvider<N> namespaceSerializerProvider, @Nonnull StateSerializerProvider<S> stateSerializerProvider, @Nonnull StateSnapshotTransformer.StateSnapshotTransformFactory<S> stateSnapshotTransformFactory) {
        super(name);
        this.stateType = stateType;
        this.namespaceSerializerProvider = namespaceSerializerProvider;
        this.stateSerializerProvider = stateSerializerProvider;
        this.stateSnapshotTransformFactory = stateSnapshotTransformFactory;
    }

    @Nonnull
    public StateDescriptor.Type getStateType() {
        return this.stateType;
    }

    @Nonnull
    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializerProvider.currentSchemaSerializer();
    }

    @Nonnull
    public TypeSerializer<S> getStateSerializer() {
        return this.stateSerializerProvider.currentSchemaSerializer();
    }

    @Nonnull
    public TypeSerializerSchemaCompatibility<S> updateStateSerializer(TypeSerializer<S> newStateSerializer) {
        return this.stateSerializerProvider.registerNewSerializerForRestoredState(newStateSerializer);
    }

    @Nonnull
    public TypeSerializerSchemaCompatibility<N> updateNamespaceSerializer(TypeSerializer<N> newNamespaceSerializer) {
        return this.namespaceSerializerProvider.registerNewSerializerForRestoredState(newNamespaceSerializer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisteredKeyValueStateBackendMetaInfo that = (RegisteredKeyValueStateBackendMetaInfo)o;
        if (!this.stateType.equals((Object)that.stateType)) {
            return false;
        }
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        return this.getStateSerializer().equals(that.getStateSerializer()) && this.getNamespaceSerializer().equals(that.getNamespaceSerializer());
    }

    public String toString() {
        return "RegisteredKeyedBackendStateMetaInfo{stateType=" + this.stateType + ", name='" + this.name + "', namespaceSerializer=" + this.getNamespaceSerializer() + ", stateSerializer=" + this.getStateSerializer() + "}";
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getStateType().hashCode();
        result = 31 * result + this.getNamespaceSerializer().hashCode();
        result = 31 * result + this.getStateSerializer().hashCode();
        return result;
    }

    @Override
    @Nonnull
    public StateMetaInfoSnapshot snapshot() {
        return this.computeSnapshot();
    }

    @Override
    @Nonnull
    public RegisteredKeyValueStateBackendMetaInfo<N, S> withSerializerUpgradesAllowed() {
        return new RegisteredKeyValueStateBackendMetaInfo<N, S>(this.snapshot());
    }

    public void checkStateMetaInfo(StateDescriptor<?> stateDesc) {
        Preconditions.checkState(Objects.equals(stateDesc.getStateId(), this.getName()), "Incompatible state names. Was [" + this.getName() + "], registered with [" + stateDesc.getStateId() + "].");
        Preconditions.checkState(stateDesc.getType() == this.getStateType(), "Incompatible key/value state types. Was [" + this.getStateType() + "], registered with [" + stateDesc.getType() + "].");
    }

    @Nonnull
    private StateMetaInfoSnapshot computeSnapshot() {
        Map<String, String> optionsMap = Collections.singletonMap(StateMetaInfoSnapshot.CommonOptionsKeys.KEYED_STATE_TYPE.toString(), this.stateType.toString());
        HashMap<String, TypeSerializer<?>> serializerMap = CollectionUtil.newHashMapWithExpectedSize(2);
        HashMap<String, TypeSerializerSnapshot<?>> serializerConfigSnapshotsMap = CollectionUtil.newHashMapWithExpectedSize(2);
        String namespaceSerializerKey = StateMetaInfoSnapshot.CommonSerializerKeys.NAMESPACE_SERIALIZER.toString();
        String valueSerializerKey = StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER.toString();
        TypeSerializer<N> namespaceSerializer = this.getNamespaceSerializer();
        serializerMap.put(namespaceSerializerKey, namespaceSerializer.duplicate());
        serializerConfigSnapshotsMap.put(namespaceSerializerKey, namespaceSerializer.snapshotConfiguration());
        TypeSerializer<S> stateSerializer = this.getStateSerializer();
        serializerMap.put(valueSerializerKey, stateSerializer.duplicate());
        serializerConfigSnapshotsMap.put(valueSerializerKey, stateSerializer.snapshotConfiguration());
        return new StateMetaInfoSnapshot(this.name, StateMetaInfoSnapshot.BackendStateType.KEY_VALUE_V2, optionsMap, serializerConfigSnapshotsMap, serializerMap);
    }

    public static RegisteredStateMetaInfoBase fromMetaInfoSnapshot(@Nonnull StateMetaInfoSnapshot snapshot) {
        StateMetaInfoSnapshot.BackendStateType backendStateType = snapshot.getBackendStateType();
        switch (backendStateType) {
            case KEY_VALUE: {
                return RegisteredStateMetaInfoUtils.createMetaInfoV2FromV1Snapshot(snapshot);
            }
            case KEY_VALUE_V2: {
                if (snapshot.getOption(StateMetaInfoSnapshot.CommonOptionsKeys.KEYED_STATE_TYPE.toString()).equals(StateDescriptor.Type.MAP.toString())) {
                    return new RegisteredKeyAndUserKeyValueStateBackendMetaInfo(snapshot);
                }
                return new RegisteredKeyValueStateBackendMetaInfo(snapshot);
            }
        }
        return RegisteredStateMetaInfoBase.fromMetaInfoSnapshot(snapshot);
    }
}

