/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.View;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

public class TimerGauge
implements Gauge<Long>,
View {
    private static final int DEFAULT_TIME_SPAN_IN_SECONDS = 60;
    private final Clock clock;
    private final Collection<StartStopListener> startStopListeners = new ArrayList<StartStopListener>();
    private final int timeSpanInSeconds;
    private final long[] values;
    private int idx = 0;
    private boolean fullWindow = false;
    private long currentValue;
    private long currentCount;
    private long currentMeasurementStartTS;
    private long currentUpdateTS;
    private long previousMaxSingleMeasurement;
    private long currentMaxSingleMeasurement;
    private long accumulatedCount;

    public TimerGauge() {
        this(60);
    }

    public TimerGauge(int timeSpanInSeconds) {
        this(SystemClock.getInstance(), timeSpanInSeconds);
    }

    public TimerGauge(Clock clock) {
        this(clock, 60);
    }

    public TimerGauge(Clock clock, int timeSpanInSeconds) {
        this.clock = clock;
        this.timeSpanInSeconds = Math.max(timeSpanInSeconds - timeSpanInSeconds % 5, 5);
        this.values = new long[this.timeSpanInSeconds / 5];
    }

    public synchronized void registerListener(StartStopListener listener) {
        if (this.currentMeasurementStartTS != 0L) {
            listener.markStart();
        }
        this.startStopListeners.add(listener);
    }

    public synchronized void unregisterListener(StartStopListener listener) {
        if (this.currentMeasurementStartTS != 0L) {
            listener.markEnd();
        }
        this.startStopListeners.remove(listener);
    }

    public synchronized void markStart() {
        if (this.currentMeasurementStartTS != 0L) {
            return;
        }
        this.currentMeasurementStartTS = this.currentUpdateTS = this.clock.absoluteTimeMillis();
        for (StartStopListener startStopListener : this.startStopListeners) {
            startStopListener.markStart();
        }
    }

    public synchronized void markEnd() {
        if (this.currentMeasurementStartTS == 0L) {
            return;
        }
        long now = this.clock.absoluteTimeMillis();
        long currentMeasurement = now - this.currentMeasurementStartTS;
        long currentIncrement = now - this.currentUpdateTS;
        this.currentCount += currentIncrement;
        this.accumulatedCount += currentIncrement;
        this.currentMaxSingleMeasurement = Math.max(this.currentMaxSingleMeasurement, currentMeasurement);
        this.currentUpdateTS = 0L;
        this.currentMeasurementStartTS = 0L;
        for (StartStopListener startStopListener : this.startStopListeners) {
            startStopListener.markEnd();
        }
    }

    public synchronized void update() {
        if (this.currentMeasurementStartTS != 0L) {
            long now = this.clock.absoluteTimeMillis();
            this.currentCount += now - this.currentUpdateTS;
            this.accumulatedCount += now - this.currentUpdateTS;
            this.currentUpdateTS = now;
            this.currentMaxSingleMeasurement = Math.max(this.currentMaxSingleMeasurement, now - this.currentMeasurementStartTS);
        }
        this.updateCurrentValue();
        this.previousMaxSingleMeasurement = this.currentMaxSingleMeasurement;
        this.currentCount = 0L;
        this.currentMaxSingleMeasurement = 0L;
    }

    private void updateCurrentValue() {
        if (this.idx == this.values.length - 1) {
            this.fullWindow = true;
        }
        this.values[this.idx] = this.currentCount;
        this.idx = (this.idx + 1) % this.values.length;
        int maxIndex = this.fullWindow ? this.values.length : this.idx;
        long totalTime = 0L;
        for (int i = 0; i < maxIndex; ++i) {
            totalTime += this.values[i];
        }
        this.currentValue = Math.max(Math.min(totalTime / (long)(5 * maxIndex), 1000L), 0L);
    }

    public synchronized Long getValue() {
        return this.currentValue;
    }

    public synchronized long getMaxSingleMeasurement() {
        return this.previousMaxSingleMeasurement;
    }

    public synchronized long getAccumulatedCount() {
        return this.accumulatedCount;
    }

    @VisibleForTesting
    public synchronized long getCount() {
        return this.currentCount;
    }

    public synchronized boolean isMeasuring() {
        return this.currentMeasurementStartTS != 0L;
    }

    public static interface StartStopListener {
        public void markStart();

        public void markEnd();
    }
}

